/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo;

public class BinaryCallsite {
    private final String fBinaryFilePath;
    private final String fBuildId;
    private final long fOffset;
    private final boolean fIsPic;

    public BinaryCallsite(String binaryFilePath, String buildId, long offset, boolean isPic) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Address offset cannot be negative");
        }
        this.fBinaryFilePath = binaryFilePath;
        this.fBuildId = buildId;
        this.fOffset = offset;
        this.fIsPic = isPic;
    }

    public String getBinaryFilePath() {
        return this.fBinaryFilePath;
    }

    public String getBuildId() {
        return this.fBuildId;
    }

    public long getOffset() {
        return this.fOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.fBinaryFilePath);
        if (this.fIsPic) {
            sb.append('+');
        } else {
            sb.append('@');
        }
        sb.append("0x").append(Long.toHexString(this.fOffset));
        return sb.toString();
    }
}

