/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryFile;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo.UstDebugInfoLoadedBinaryFile;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo.UstDebugInfoStateProvider;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfUtils;

public class UstDebugInfoAnalysisModule
extends TmfStateSystemAnalysisModule {
    public static final String ID = "org.eclipse.linuxtools.lttng2.ust.analysis.debuginfo";

    protected ITmfStateProvider createStateProvider() {
        return new UstDebugInfoStateProvider((LttngUstTrace)((Object)NonNullUtils.checkNotNull((Object)((Object)this.getTrace()))));
    }

    public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (!(trace instanceof LttngUstTrace)) {
            return false;
        }
        return super.setTrace(trace);
    }

    protected @Nullable LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        return Collections.EMPTY_SET;
    }

    public boolean canExecute(ITmfTrace trace) {
        if (!(trace instanceof LttngUstTrace)) {
            return false;
        }
        LttngUstTrace ustTrace = (LttngUstTrace)trace;
        String tracerName = CtfUtils.getTracerName((CtfTmfTrace)ustTrace);
        int majorVersion = CtfUtils.getTracerMajorVersion((CtfTmfTrace)ustTrace);
        int minorVersion = CtfUtils.getTracerMinorVersion((CtfTmfTrace)ustTrace);
        if (!"lttng-ust".equals(tracerName)) {
            return false;
        }
        if (majorVersion < 2) {
            return false;
        }
        if (majorVersion == 2 && minorVersion < 8) {
            return false;
        }
        return super.canExecute(trace);
    }

    public Collection<UstDebugInfoBinaryFile> getAllBinaries() {
        this.waitForCompletion();
        ITmfStateSystem ss = (ITmfStateSystem)NonNullUtils.checkNotNull((Object)this.getStateSystem());
        TreeSet<UstDebugInfoBinaryFile> files = new TreeSet<UstDebugInfoBinaryFile>();
        ImmutableList.Builder builder = ImmutableList.builder();
        List vpidQuarks = ss.getSubAttributes(-1, false);
        for (Integer vpidQuark : vpidQuarks) {
            builder.addAll((Iterable)ss.getSubAttributes(vpidQuark.intValue(), false));
        }
        ImmutableList baddrQuarks = builder.build();
        for (Integer baddrQuark : baddrQuarks) {
            List buildIdQuarks = ss.getSubAttributes(baddrQuark.intValue(), false);
            for (Integer buildIdQuark : buildIdQuarks) {
                String buildId = ss.getAttributeName(buildIdQuark.intValue());
                ITmfStateInterval interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)buildIdQuark, (long)ss.getStartTime(), (long)Long.MAX_VALUE);
                if (interval == null) {
                    throw new IllegalStateException();
                }
                String filePath = interval.getStateValue().unboxStr();
                try {
                    int isPicQuark = ss.getQuarkRelative(buildIdQuark.intValue(), new String[]{"is_pic"});
                    int isPicVal = ss.querySingleState(interval.getStartTime(), isPicQuark).getStateValue().unboxInt();
                    boolean isPic = isPicVal != 0;
                    files.add(new UstDebugInfoBinaryFile(filePath, buildId, isPic));
                }
                catch (AttributeNotFoundException e) {
                    throw new IllegalStateException("Missing expected \"is_pic\" attribute");
                }
                catch (StateSystemDisposedException stateSystemDisposedException) {
                    // empty catch block
                }
            }
        }
        return files;
    }

    @Nullable UstDebugInfoLoadedBinaryFile getMatchingFile(long ts, long vpid, long ip) {
        Optional<Integer> potentialBuildIdQuark;
        int baddrQuark;
        List fullState;
        ITmfStateSystem ss;
        block7: {
            block6: {
                this.waitForCompletion();
                ss = (ITmfStateSystem)NonNullUtils.checkNotNull((Object)this.getStateSystem());
                List possibleBaddrQuarks = ss.getQuarks(new String[]{String.valueOf(vpid), "*"});
                NavigableSet possibleBaddrs = possibleBaddrQuarks.stream().map(quark -> {
                    String baddrStr = ss.getAttributeName(quark.intValue());
                    return (Long)NonNullUtils.checkNotNull((Object)Long.valueOf(baddrStr));
                }).collect(Collectors.toCollection(TreeSet::new));
                Long potentialBaddr = possibleBaddrs.floor(ip);
                if (potentialBaddr == null) {
                    return null;
                }
                fullState = ss.queryFullState(ts);
                baddrQuark = ss.getQuarkAbsolute(new String[]{String.valueOf(vpid), String.valueOf(potentialBaddr)});
                long endAddr = ((ITmfStateInterval)fullState.get(baddrQuark)).getStateValue().unboxLong();
                if (ip < endAddr) break block6;
                return null;
            }
            List buildIds = ss.getSubAttributes(baddrQuark, false);
            potentialBuildIdQuark = buildIds.stream().filter(id -> {
                int quark = id;
                ITmfStateValue value = ((ITmfStateInterval)fullState.get(quark)).getStateValue();
                return !value.isNull();
            }).findFirst();
            if (potentialBuildIdQuark.isPresent()) break block7;
            return null;
        }
        try {
            long baddr = Long.parseLong(ss.getAttributeName(baddrQuark));
            int buildIdQuark = potentialBuildIdQuark.get();
            String buildId = ss.getAttributeName(buildIdQuark);
            String filePath = ((ITmfStateInterval)fullState.get(buildIdQuark)).getStateValue().unboxStr();
            int isPicQuark = ss.getQuarkRelative(buildIdQuark, new String[]{"is_pic"});
            int isPicVal = ((ITmfStateInterval)fullState.get(isPicQuark)).getStateValue().unboxInt();
            boolean isPic = isPicVal != 0;
            return new UstDebugInfoLoadedBinaryFile(baddr, filePath, buildId, isPic);
        }
        catch (AttributeNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (StateSystemDisposedException e) {
            return null;
        }
    }
}

