/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;

public final class Attribute {
    private final Attribute parent;
    private final @NonNull String name;
    private final int quark;
    private final Map<String, Attribute> subAttributes;
    private int curDepth;

    public Attribute(Attribute parent, @NonNull String name, int quark) {
        this.parent = parent;
        this.quark = quark;
        this.name = name;
        this.subAttributes = Collections.synchronizedMap(new LinkedHashMap());
    }

    public int getQuark() {
        return this.quark;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public Iterable<Attribute> getSubAttributes() {
        return ImmutableList.copyOf(this.subAttributes.values());
    }

    public int getSubAttributeQuark(String ... path) {
        return this.getSubAttributeQuark(path, 0);
    }

    public Attribute getSubAttributeNode(String ... path) {
        return this.getSubAttributeNode(path, 0);
    }

    private int getSubAttributeQuark(String[] path, int index) {
        Attribute targetNode = this.getSubAttributeNode(path, index);
        if (targetNode == null) {
            return -2;
        }
        return targetNode.getQuark();
    }

    public Attribute getParentAttribute() {
        return this.parent;
    }

    public int getParentAttributeQuark() {
        return this.parent.getQuark();
    }

    public void addSubAttribute(Attribute newSubAttribute) {
        if (newSubAttribute == null) {
            throw new IllegalArgumentException();
        }
        this.subAttributes.put(newSubAttribute.getName(), newSubAttribute);
    }

    private Attribute getSubAttributeNode(String[] path, int index) {
        Attribute nextNode = this.subAttributes.get(path[index]);
        if (nextNode == null) {
            return null;
        }
        if (index == path.length - 1) {
            return nextNode;
        }
        return nextNode.getSubAttributeNode(path, index + 1);
    }

    public String @NonNull [] getFullAttribute() {
        LinkedList<String> list = new LinkedList<String>();
        Attribute curNode = this;
        while (curNode.parent != null) {
            list.addFirst(curNode.getName());
            curNode = curNode.parent;
        }
        return list.toArray(new String[0]);
    }

    public @NonNull String getFullAttributeName() {
        String[] array = this.getFullAttribute();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < array.length - 1) {
            buf.append(array[i]);
            buf.append('/');
            ++i;
        }
        buf.append(array[array.length - 1]);
        return (String)NonNullUtils.checkNotNull((Object)buf.toString());
    }

    public String toString() {
        return String.valueOf(this.getFullAttributeName()) + " (" + this.quark + ')';
    }

    private void attributeNodeToString(PrintWriter writer, Attribute currentNode) {
        writer.println(String.valueOf(currentNode.getName()) + " (" + currentNode.quark + ')');
        ++this.curDepth;
        for (Attribute nextNode : currentNode.getSubAttributes()) {
            if (nextNode == null) continue;
            int j = 0;
            while (j < this.curDepth - 1) {
                writer.print("  ");
                ++j;
            }
            writer.print("  ");
            this.attributeNodeToString(writer, nextNode);
        }
        --this.curDepth;
    }

    public void debugPrint(PrintWriter writer) {
        writer.println("------------------------------");
        writer.println("Attribute tree: (quark)\n");
        this.curDepth = 0;
        this.attributeNodeToString(writer, this);
        writer.print('\n');
    }
}

