/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferReader;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.ISafeByteBufferWriter;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.SafeByteBufferFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public final class HTInterval
implements ITmfStateInterval,
Comparable<HTInterval> {
    private static final String errMsg = "Invalid interval data. Maybe your file is corrupt?";
    private static final byte TYPE_NULL = -1;
    private static final byte TYPE_INTEGER = 0;
    private static final byte TYPE_STRING = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_DOUBLE = 3;
    private static final byte TYPE_CUSTOM = 20;
    private final long start;
    private final long end;
    private final int attribute;
    private final @NonNull TmfStateValue sv;
    private final int fSizeOnDisk;

    public HTInterval(long intervalStart, long intervalEnd, int attribute, @NonNull TmfStateValue value) throws TimeRangeException {
        if (intervalStart > intervalEnd) {
            throw new TimeRangeException("Start:" + intervalStart + ", End:" + intervalEnd);
        }
        this.start = intervalStart;
        this.end = intervalEnd;
        this.attribute = attribute;
        this.sv = value;
        this.fSizeOnDisk = HTInterval.computeSizeOnDisk(this.sv);
    }

    private static int computeSizeOnDisk(ITmfStateValue sv) {
        int minSize = 21;
        switch (sv.getType()) {
            case NULL: {
                return minSize;
            }
            case INTEGER: {
                return minSize + 4;
            }
            case LONG: {
                return minSize + 8;
            }
            case DOUBLE: {
                return minSize + 8;
            }
            case STRING: {
                return minSize + sv.unboxStr().getBytes().length + 2;
            }
            case CUSTOM: {
                return minSize + 2 + ((CustomStateValue)sv).getSerializedSize();
            }
        }
        throw new IllegalStateException();
    }

    private HTInterval(long intervalStart, long intervalEnd, int attribute, @NonNull TmfStateValue value, int size) throws TimeRangeException {
        if (intervalStart > intervalEnd) {
            throw new TimeRangeException("Start:" + intervalStart + ", End:" + intervalEnd);
        }
        this.start = intervalStart;
        this.end = intervalEnd;
        this.attribute = attribute;
        this.sv = value;
        this.fSizeOnDisk = size;
    }

    public static final HTInterval readFrom(ByteBuffer buffer) throws IOException {
        TmfStateValue value;
        int posStart = buffer.position();
        long intervalStart = buffer.getLong();
        long intervalEnd = buffer.getLong();
        int attribute = buffer.getInt();
        byte valueType = buffer.get();
        switch (valueType) {
            case -1: {
                value = TmfStateValue.nullValue();
                break;
            }
            case 0: {
                value = TmfStateValue.newValueInt(buffer.getInt());
                break;
            }
            case 1: {
                byte valueSize = buffer.get();
                byte[] array = new byte[valueSize];
                buffer.get(array);
                value = TmfStateValue.newValueString(new String(array));
                byte res = buffer.get();
                if (res == 0) break;
                throw new IOException(errMsg);
            }
            case 2: {
                value = TmfStateValue.newValueLong(buffer.getLong());
                break;
            }
            case 3: {
                value = TmfStateValue.newValueDouble(buffer.getDouble());
                break;
            }
            case 20: {
                short valueSize = buffer.getShort();
                ISafeByteBufferReader safeBuffer = SafeByteBufferFactory.wrapReader(buffer, valueSize);
                value = CustomStateValue.readSerializedValue(safeBuffer);
                break;
            }
            default: {
                throw new IOException(errMsg);
            }
        }
        try {
            return new HTInterval(intervalStart, intervalEnd, attribute, value, buffer.position() - posStart);
        }
        catch (TimeRangeException e) {
            throw new IOException(errMsg);
        }
    }

    public void writeInterval(ByteBuffer buffer) {
        byte byteFromType = HTInterval.getByteFromType(this.sv.getType());
        buffer.putLong(this.start);
        buffer.putLong(this.end);
        buffer.putInt(this.attribute);
        buffer.put(byteFromType);
        switch (byteFromType) {
            case -1: {
                break;
            }
            case 0: {
                buffer.putInt(this.sv.unboxInt());
                break;
            }
            case 1: {
                String string = this.sv.unboxStr();
                byte[] strArray = string.getBytes();
                buffer.put((byte)strArray.length);
                buffer.put(strArray);
                buffer.put((byte)0);
                break;
            }
            case 2: {
                buffer.putLong(this.sv.unboxLong());
                break;
            }
            case 3: {
                buffer.putDouble(this.sv.unboxDouble());
                break;
            }
            case 20: {
                int size = ((CustomStateValue)this.sv).getSerializedSize();
                buffer.putShort((short)size);
                ISafeByteBufferWriter safeBuffer = SafeByteBufferFactory.wrapWriter(buffer, size);
                ((CustomStateValue)this.sv).serialize(safeBuffer);
                break;
            }
        }
    }

    @Override
    public long getStartTime() {
        return this.start;
    }

    @Override
    public long getEndTime() {
        return this.end;
    }

    @Override
    public int getAttribute() {
        return this.attribute;
    }

    @Override
    public ITmfStateValue getStateValue() {
        return this.sv;
    }

    @Override
    public boolean intersects(long timestamp) {
        return this.start <= timestamp && this.end >= timestamp;
    }

    public int getSizeOnDisk() {
        return this.fSizeOnDisk;
    }

    @Override
    public int compareTo(HTInterval other) {
        if (this.end < other.end) {
            return -1;
        }
        if (this.end > other.end) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        return other instanceof HTInterval && this.compareTo((HTInterval)other) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.start);
        sb.append(", ");
        sb.append(this.end);
        sb.append(']');
        sb.append(", attribute = ");
        sb.append(this.attribute);
        sb.append(", value = ");
        sb.append(this.sv.toString());
        return sb.toString();
    }

    private static byte getByteFromType(ITmfStateValue.Type type) {
        switch (type) {
            case NULL: {
                return -1;
            }
            case INTEGER: {
                return 0;
            }
            case STRING: {
                return 1;
            }
            case LONG: {
                return 2;
            }
            case DOUBLE: {
                return 3;
            }
            case CUSTOM: {
                return 20;
            }
        }
        throw new IllegalStateException();
    }
}

