/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;

class HT_IO {
    private final HTConfig fConfig;
    private final FileInputStream fFileInputStream;
    private final FileOutputStream fFileOutputStream;
    private final FileChannel fFileChannelIn;
    private final FileChannel fFileChannelOut;
    private static final int CACHE_SIZE = 256;
    private static final int CACHE_MASK = 255;
    private static final CacheElement[] NODE_CACHE = new CacheElement[256];

    public HT_IO(HTConfig config, boolean newFile) throws IOException {
        this.fConfig = config;
        File historyTreeFile = config.getStateFile();
        if (newFile) {
            boolean success1 = true;
            if (historyTreeFile.exists()) {
                success1 = historyTreeFile.delete();
            }
            boolean success2 = historyTreeFile.createNewFile();
            if (!success1 || !success2) {
                throw new IOException("Cannot create new file at " + historyTreeFile.getName());
            }
            this.fFileInputStream = new FileInputStream(historyTreeFile);
            this.fFileOutputStream = new FileOutputStream(historyTreeFile, false);
        } else {
            this.fFileInputStream = new FileInputStream(historyTreeFile);
            this.fFileOutputStream = new FileOutputStream(historyTreeFile, true);
        }
        this.fFileChannelIn = this.fFileInputStream.getChannel();
        this.fFileChannelOut = this.fFileOutputStream.getChannel();
    }

    public synchronized @NonNull HTNode readNode(int seqNumber) throws ClosedChannelException {
        int offset = seqNumber + this.hashCode() & 0xFF;
        CacheElement cachedNode = NODE_CACHE[offset];
        if (cachedNode != null && cachedNode.getKey() == this && cachedNode.getValue().getSequenceNumber() == seqNumber) {
            return cachedNode.getValue();
        }
        try {
            this.seekFCToNodePos(this.fFileChannelIn, seqNumber);
            HTNode readNode = HTNode.readNode(this.fConfig, this.fFileChannelIn);
            HT_IO.NODE_CACHE[offset] = new CacheElement(this, readNode);
            return readNode;
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            throw new IllegalStateException();
        }
    }

    public synchronized void writeNode(HTNode node) {
        try {
            int seqNumber = node.getSequenceNumber();
            int offset = seqNumber + this.hashCode() & 0xFF;
            HT_IO.NODE_CACHE[offset] = new CacheElement(this, node);
            this.seekFCToNodePos(this.fFileChannelOut, seqNumber);
            node.writeSelf(this.fFileChannelOut);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    public FileChannel getFcOut() {
        return this.fFileChannelOut;
    }

    public FileInputStream supplyATReader(int nodeOffset) {
        try {
            this.seekFCToNodePos(this.fFileChannelIn, nodeOffset);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return this.fFileInputStream;
    }

    public synchronized void closeFile() {
        try {
            this.fFileInputStream.close();
            this.fFileOutputStream.close();
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    public synchronized void deleteFile() {
        this.closeFile();
        File historyTreeFile = this.fConfig.getStateFile();
        if (!historyTreeFile.delete()) {
            Activator.getDefault().logError("Failed to delete" + historyTreeFile.getName());
        }
    }

    private void seekFCToNodePos(FileChannel fc, int seqNumber) throws IOException {
        fc.position(4096L + (long)seqNumber * (long)this.fConfig.getBlockSize());
    }

    @NonNullByDefault
    private static final class CacheElement {
        private final HTNode value;
        private final HT_IO key;

        public CacheElement(HT_IO ss, HTNode node) {
            this.key = ss;
            this.value = node;
        }

        public HT_IO getKey() {
            return this.key;
        }

        public HTNode getValue() {
            return this.value;
        }
    }
}

