/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.CoreNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HT_IO;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.LeafNode;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;

public class HistoryTree {
    public static final int TREE_HEADER_SIZE = 4096;
    private static final int HISTORY_FILE_MAGIC_NUMBER = 100641024;
    private static final int FILE_VERSION = 6;
    private final HTConfig fConfig;
    private final HT_IO fTreeIO;
    private long fTreeEnd;
    private int fNodeCount;
    private final @NonNull List<@NonNull HTNode> fLatestBranch;

    public HistoryTree(HTConfig conf) throws IOException {
        if (conf.getBlockSize() < 4096) {
            throw new IllegalArgumentException();
        }
        this.fConfig = conf;
        this.fTreeEnd = conf.getTreeStart();
        this.fNodeCount = 0;
        this.fLatestBranch = Collections.synchronizedList(new ArrayList());
        this.fTreeIO = new HT_IO(this.fConfig, true);
        LeafNode firstNode = this.initNewLeafNode(-1, conf.getTreeStart());
        this.fLatestBranch.add(firstNode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistoryTree(File existingStateFile, int expProviderVersion) throws IOException {
        long startTime;
        int rootNodeSeqNb;
        block18: {
            if (!existingStateFile.exists()) {
                throw new IOException("Selected state file does not exist");
            }
            if (existingStateFile.length() <= 0L) {
                throw new IOException("Empty target file");
            }
            Throwable throwable = null;
            Object var10_5 = null;
            try {
                FileInputStream fis = new FileInputStream(existingStateFile);
                try {
                    try (FileChannel fc = fis.getChannel();){
                        ByteBuffer buffer = ByteBuffer.allocate(4096);
                        buffer.order(ByteOrder.LITTLE_ENDIAN);
                        buffer.clear();
                        fc.read(buffer);
                        buffer.flip();
                        int res = buffer.getInt();
                        if (res != 100641024) {
                            throw new IOException("Wrong magic number");
                        }
                        res = buffer.getInt();
                        if (res != 6) {
                            throw new IOException("Mismatching History Tree file format versions");
                        }
                        res = buffer.getInt();
                        if (res != expProviderVersion && expProviderVersion != -42) {
                            throw new IOException("Mismatching event handler versions");
                        }
                        int bs = buffer.getInt();
                        int maxc = buffer.getInt();
                        this.fNodeCount = buffer.getInt();
                        rootNodeSeqNb = buffer.getInt();
                        startTime = buffer.getLong();
                        this.fConfig = new HTConfig(existingStateFile, bs, maxc, expProviderVersion, startTime);
                    }
                    if (fis == null) break block18;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        this.fTreeIO = new HT_IO(this.fConfig, false);
        this.fLatestBranch = this.buildLatestBranch(rootNodeSeqNb);
        this.fTreeEnd = this.getRootNode().getNodeEnd();
        if (startTime == this.getRootNode().getNodeStart()) return;
        throw new IOException("Inconsistent start times in thehistory file, it might be corrupted.");
    }

    private @NonNull List<@NonNull HTNode> buildLatestBranch(int rootNodeSeqNb) throws ClosedChannelException {
        ArrayList<@NonNull HTNode> list = new ArrayList<HTNode>();
        HTNode nextChildNode = this.fTreeIO.readNode(rootNodeSeqNb);
        list.add(nextChildNode);
        while (nextChildNode.getNodeType() == HTNode.NodeType.CORE) {
            nextChildNode = this.fTreeIO.readNode(((CoreNode)nextChildNode).getLatestChild());
            list.add(nextChildNode);
        }
        return Collections.synchronizedList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeTree(long requestedEndTime) {
        List<HTNode> list = this.fLatestBranch;
        synchronized (list) {
            this.fTreeEnd = requestedEndTime;
            int i2 = 0;
            while (i2 < this.fLatestBranch.size()) {
                this.fLatestBranch.get(i2).closeThisNode(this.fTreeEnd);
                this.fTreeIO.writeNode(this.fLatestBranch.get(i2));
                ++i2;
            }
            try {
                Throwable i2 = null;
                Object var5_7 = null;
                try (FileChannel fc = this.fTreeIO.getFcOut();){
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    buffer.clear();
                    fc.position(0L);
                    buffer.putInt(100641024);
                    buffer.putInt(6);
                    buffer.putInt(this.fConfig.getProviderVersion());
                    buffer.putInt(this.fConfig.getBlockSize());
                    buffer.putInt(this.fConfig.getMaxChildren());
                    buffer.putInt(this.fNodeCount);
                    buffer.putInt(this.fLatestBranch.get(0).getSequenceNumber());
                    buffer.putLong(this.fLatestBranch.get(0).getNodeStart());
                    buffer.flip();
                    int res = fc.write(buffer);
                    assert (res <= 4096);
                }
                catch (Throwable throwable) {
                    if (i2 == null) {
                        i2 = throwable;
                    } else if (i2 != throwable) {
                        i2.addSuppressed(throwable);
                    }
                    throw i2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("State system write error");
            }
        }
    }

    public long getTreeStart() {
        return this.fConfig.getTreeStart();
    }

    public long getTreeEnd() {
        return this.fTreeEnd;
    }

    public int getNodeCount() {
        return this.fNodeCount;
    }

    public HTNode getRootNode() {
        return this.fLatestBranch.get(0);
    }

    protected List<@NonNull HTNode> getLatestBranch() {
        return ImmutableList.copyOf(this.fLatestBranch);
    }

    public FileInputStream supplyATReader() {
        return this.fTreeIO.supplyATReader(this.getNodeCount());
    }

    public File supplyATWriterFile() {
        return this.fConfig.getStateFile();
    }

    public long supplyATWriterFilePos() {
        return 4096L + (long)this.getNodeCount() * (long)this.fConfig.getBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTNode readNode(int seqNumber) throws ClosedChannelException {
        List<HTNode> list = this.fLatestBranch;
        synchronized (list) {
            for (HTNode node : this.fLatestBranch) {
                if (node.getSequenceNumber() != seqNumber) continue;
                return node;
            }
        }
        return this.fTreeIO.readNode(seqNumber);
    }

    public void writeNode(HTNode node) {
        this.fTreeIO.writeNode(node);
    }

    public void closeFile() {
        this.fTreeIO.closeFile();
    }

    public void deleteFile() {
        this.fTreeIO.deleteFile();
    }

    public void insertInterval(HTInterval interval) throws TimeRangeException {
        if (interval.getStartTime() < this.fConfig.getTreeStart()) {
            throw new TimeRangeException("Interval Start:" + interval.getStartTime() + ", Config Start:" + this.fConfig.getTreeStart());
        }
        this.tryInsertAtNode(interval, this.fLatestBranch.size() - 1);
    }

    private void tryInsertAtNode(HTInterval interval, int indexOfNode) {
        HTNode targetNode = this.fLatestBranch.get(indexOfNode);
        if (interval.getSizeOnDisk() > targetNode.getNodeFreeSpace()) {
            this.addSiblingNode(indexOfNode);
            this.tryInsertAtNode(interval, this.fLatestBranch.size() - 1);
            return;
        }
        if (interval.getStartTime() < targetNode.getNodeStart()) {
            this.tryInsertAtNode(interval, indexOfNode - 1);
            return;
        }
        targetNode.addInterval(interval);
        if (interval.getEndTime() > this.fTreeEnd) {
            this.fTreeEnd = interval.getEndTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSiblingNode(int indexOfNode) {
        List<HTNode> list = this.fLatestBranch;
        synchronized (list) {
            long splitTime = this.fTreeEnd;
            if (indexOfNode >= this.fLatestBranch.size()) {
                throw new IllegalStateException();
            }
            if (indexOfNode == 0) {
                this.addNewRootNode();
                return;
            }
            if (((CoreNode)this.fLatestBranch.get(indexOfNode - 1)).getNbChildren() == this.fConfig.getMaxChildren()) {
                this.addSiblingNode(indexOfNode - 1);
                return;
            }
            int i = indexOfNode;
            while (i < this.fLatestBranch.size()) {
                HTNode newNode;
                this.fLatestBranch.get(i).closeThisNode(splitTime);
                this.fTreeIO.writeNode(this.fLatestBranch.get(i));
                CoreNode prevNode = (CoreNode)this.fLatestBranch.get(i - 1);
                switch (this.fLatestBranch.get(i).getNodeType()) {
                    case CORE: {
                        newNode = this.initNewCoreNode(prevNode.getSequenceNumber(), splitTime + 1L);
                        break;
                    }
                    case LEAF: {
                        newNode = this.initNewLeafNode(prevNode.getSequenceNumber(), splitTime + 1L);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                prevNode.linkNewChild(newNode);
                this.fLatestBranch.set(i, newNode);
                ++i;
            }
        }
    }

    private void addNewRootNode() {
        long splitTime = this.fTreeEnd;
        HTNode oldRootNode = this.fLatestBranch.get(0);
        CoreNode newRootNode = this.initNewCoreNode(-1, this.fConfig.getTreeStart());
        oldRootNode.setParentSequenceNumber(newRootNode.getSequenceNumber());
        int i = 0;
        while (i < this.fLatestBranch.size()) {
            this.fLatestBranch.get(i).closeThisNode(splitTime);
            this.fTreeIO.writeNode(this.fLatestBranch.get(i));
            ++i;
        }
        newRootNode.linkNewChild(oldRootNode);
        int depth = this.fLatestBranch.size();
        this.fLatestBranch.clear();
        this.fLatestBranch.add(newRootNode);
        int i2 = 1;
        while (i2 < depth) {
            CoreNode prevNode = (CoreNode)this.fLatestBranch.get(i2 - 1);
            CoreNode newNode = this.initNewCoreNode(prevNode.getSequenceNumber(), splitTime + 1L);
            prevNode.linkNewChild(newNode);
            this.fLatestBranch.add(newNode);
            ++i2;
        }
        CoreNode prevNode = (CoreNode)this.fLatestBranch.get(depth - 1);
        LeafNode newNode = this.initNewLeafNode(prevNode.getSequenceNumber(), splitTime + 1L);
        prevNode.linkNewChild(newNode);
        this.fLatestBranch.add(newNode);
    }

    private @NonNull CoreNode initNewCoreNode(int parentSeqNumber, long startTime) {
        CoreNode newNode = new CoreNode(this.fConfig, this.fNodeCount, parentSeqNumber, startTime);
        ++this.fNodeCount;
        return newNode;
    }

    private @NonNull LeafNode initNewLeafNode(int parentSeqNumber, long startTime) {
        LeafNode newNode = new LeafNode(this.fConfig, this.fNodeCount, parentSeqNumber, startTime);
        ++this.fNodeCount;
        return newNode;
    }

    public HTNode selectNextChild(CoreNode currentNode, long t) throws ClosedChannelException {
        assert (currentNode.getNbChildren() > 0);
        int potentialNextSeqNb = currentNode.getSequenceNumber();
        int i = 0;
        while (i < currentNode.getNbChildren()) {
            if (t < currentNode.getChildStart(i)) break;
            potentialNextSeqNb = currentNode.getChild(i);
            ++i;
        }
        if (potentialNextSeqNb == currentNode.getSequenceNumber()) {
            throw new IllegalStateException("No next child node found");
        }
        if (currentNode.isOnDisk()) {
            return this.fTreeIO.readNode(potentialNextSeqNb);
        }
        return this.readNode(potentialNextSeqNb);
    }

    public long getFileSize() {
        return this.fConfig.getStateFile().length();
    }

    public boolean checkNodeIntegrity(HTNode zenode) {
        StringBuffer buf = new StringBuffer();
        boolean ret = true;
        if (!(zenode instanceof CoreNode)) {
            return true;
        }
        CoreNode node = (CoreNode)zenode;
        try {
            HTNode otherNode;
            if (node.getNbChildren() > 0) {
                otherNode = this.fTreeIO.readNode(node.getChild(0));
                if (node.getNodeStart() != otherNode.getNodeStart()) {
                    buf.append("Start time of node (" + node.getNodeStart() + ") " + "does not match start time of first child " + "(" + otherNode.getNodeStart() + "), " + "node #" + otherNode.getSequenceNumber() + ")\n");
                    ret = false;
                }
                if (node.isOnDisk()) {
                    otherNode = this.fTreeIO.readNode(node.getLatestChild());
                    if (node.getNodeEnd() != otherNode.getNodeEnd()) {
                        buf.append("End time of node (" + node.getNodeEnd() + ") does not match end time of last child (" + otherNode.getNodeEnd() + ", node #" + otherNode.getSequenceNumber() + ")\n");
                        ret = false;
                    }
                }
            }
            int i = 0;
            while (i < node.getNbChildren()) {
                otherNode = this.fTreeIO.readNode(node.getChild(i));
                if (otherNode.getNodeStart() != node.getChildStart(i)) {
                    buf.append("  Expected start time of child node #" + node.getChild(i) + ": " + node.getChildStart(i) + "\n" + "  Actual start time of node #" + otherNode.getSequenceNumber() + ": " + otherNode.getNodeStart() + "\n");
                    ret = false;
                }
                ++i;
            }
        }
        catch (ClosedChannelException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        if (!ret) {
            Activator.getDefault().logError("SHT: Integrity check failed for node #" + node.getSequenceNumber() + ":" + buf.toString());
        }
        return ret;
    }

    public void checkIntegrity() {
        try {
            int i = 0;
            while (i < this.fNodeCount) {
                this.checkNodeIntegrity(this.fTreeIO.readNode(i));
                ++i;
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    public String toString() {
        return "Information on the current tree:\n\nBlocksize: " + this.fConfig.getBlockSize() + "\n" + "Max nb. of children per node: " + this.fConfig.getMaxChildren() + "\n" + "Number of nodes: " + this.fNodeCount + "\n" + "Depth of the tree: " + this.fLatestBranch.size() + "\n" + "Size of the treefile: " + this.getFileSize() + "\n" + "Root node has sequence number: " + this.fLatestBranch.get(0).getSequenceNumber() + "\n" + "'Latest leaf' has sequence number: " + this.fLatestBranch.get(this.fLatestBranch.size() - 1).getSequenceNumber();
    }

    private void preOrderPrint(PrintWriter writer, boolean printIntervals, HTNode currentNode, int curDepth) {
        writer.println(currentNode.toString());
        if (printIntervals) {
            currentNode.debugPrintIntervals(writer);
        }
        switch (currentNode.getNodeType()) {
            case LEAF: {
                return;
            }
            case CORE: {
                try {
                    CoreNode node = (CoreNode)currentNode;
                    int extension = node.getExtensionSequenceNumber();
                    while (extension != -1) {
                        HTNode nextNode = this.fTreeIO.readNode(extension);
                        this.preOrderPrint(writer, printIntervals, nextNode, curDepth);
                    }
                    int i = 0;
                    while (i < node.getNbChildren()) {
                        HTNode nextNode = this.fTreeIO.readNode(node.getChild(i));
                        int j = 0;
                        while (j < curDepth) {
                            writer.print("  ");
                            ++j;
                        }
                        writer.print("+-");
                        this.preOrderPrint(writer, printIntervals, nextNode, curDepth + 1);
                        ++i;
                    }
                }
                catch (ClosedChannelException e) {
                    Activator.getDefault().logError(e.getMessage());
                }
                break;
            }
        }
    }

    public void debugPrintFullTree(PrintWriter writer, boolean printIntervals) {
        this.preOrderPrint(writer, false, this.fLatestBranch.get(0), 0);
        if (printIntervals) {
            writer.println("\nDetails of intervals:");
            this.preOrderPrint(writer, true, this.fLatestBranch.get(0), 0);
        }
        writer.println('\n');
    }
}

