/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlStateTransition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TmfXmlState {
    private final String fId;
    private final IXmlStateSystemContainer fContainer;
    private final List<TmfXmlStateTransition> fTransitions;
    private @Nullable TmfXmlState fparent;
    private List<String> fOnEntryActions;
    private List<String> fOnExitActions;
    private Map<String, TmfXmlState> fChildren;
    private @Nullable TmfXmlStateTransition fInitialTransition;
    private @Nullable String fInitialStateId;
    private @Nullable String fFinalStateId;
    private Type fType;

    private TmfXmlState(IXmlStateSystemContainer container, Type type, String id, @Nullable TmfXmlState parent, List<@NonNull TmfXmlStateTransition> transitions, Map<@NonNull String, @NonNull TmfXmlState> children, List<String> onentryActions, List<String> onexitActions) {
        this.fContainer = container;
        this.fType = type;
        this.fId = id;
        this.fparent = parent;
        this.fTransitions = transitions;
        this.fChildren = children;
        this.fOnEntryActions = onentryActions;
        this.fOnExitActions = onexitActions;
    }

    public static TmfXmlState create(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container, @Nullable TmfXmlState parent) {
        Type type = TmfXmlState.getStateType(node);
        String id = node.getAttribute("id");
        List<TmfXmlStateTransition> transitions = TmfXmlState.getTransitions(modelFactory, container, node);
        NodeList nodesOnentry = node.getElementsByTagName("onentry");
        List<String> onentryActions = nodesOnentry.getLength() > 0 ? Arrays.asList(((Element)nodesOnentry.item(0)).getAttribute("action").split(":")) : Collections.EMPTY_LIST;
        NodeList nodesOnexit = node.getElementsByTagName("onexit");
        List<String> onexitActions = nodesOnexit.getLength() > 0 ? Arrays.asList(((Element)nodesOnexit.item(0)).getAttribute("action").split(":")) : Collections.EMPTY_LIST;
        TmfXmlState state = new TmfXmlState(container, type, id, parent, transitions, new HashMap<String, TmfXmlState>(), onentryActions, onexitActions);
        TmfXmlState.initState(state, modelFactory, container, node);
        return state;
    }

    private static void getFinalState(TmfXmlState parentState, ITmfXmlModelFactory modelFactory, IXmlStateSystemContainer container, Element node) {
        NodeList nodesFinal = node.getElementsByTagName("final");
        String finalStateId = null;
        if (nodesFinal.getLength() > 0) {
            Element finalElement = (Element)NonNullUtils.checkNotNull((Object)((Element)nodesFinal.item(0)));
            finalStateId = nodesFinal.getLength() > 0 ? finalElement.getAttribute("id") : null;
            TmfXmlState finalState = modelFactory.createState(finalElement, container, parentState);
            parentState.getChildren().put(finalState.getId(), finalState);
        }
        parentState.fFinalStateId = finalStateId;
    }

    private static void getSubStates(TmfXmlState parentState, ITmfXmlModelFactory modelFactory, IXmlStateSystemContainer container, Element node) {
        NodeList nodesInitial;
        String initial = node.getAttribute("initial");
        TmfXmlStateTransition initialTransition = null;
        if (initial.isEmpty() && (nodesInitial = node.getElementsByTagName("initial")).getLength() == 1) {
            @NonNull Element transitionElement = (Element)NonNullUtils.checkNotNull((Object)((Element)((Element)nodesInitial.item(0)).getElementsByTagName("transition").item(0)));
            initialTransition = modelFactory.createStateTransition(transitionElement, container);
            initial = initialTransition.getTarget();
        }
        NodeList nodesState = node.getElementsByTagName("state");
        int i = 0;
        while (i < nodesState.getLength()) {
            TmfXmlState child = modelFactory.createState((Element)NonNullUtils.checkNotNull((Object)((Element)nodesState.item(i))), container, parentState);
            parentState.getChildren().put(child.getId(), child);
            if (i == 0 && initial.isEmpty()) {
                initial = child.getId();
            }
            ++i;
        }
        parentState.fInitialStateId = initial.isEmpty() ? null : initial;
        parentState.fInitialTransition = initialTransition;
    }

    private static void initState(TmfXmlState state, ITmfXmlModelFactory modelFactory, IXmlStateSystemContainer container, Element node) {
        TmfXmlState.getSubStates(state, modelFactory, container, node);
        TmfXmlState.getFinalState(state, modelFactory, container, node);
    }

    private static List<@NonNull TmfXmlStateTransition> getTransitions(ITmfXmlModelFactory modelFactory, IXmlStateSystemContainer container, Element node) {
        ArrayList<@NonNull TmfXmlStateTransition> transitions = new ArrayList<TmfXmlStateTransition>();
        NodeList nodesTransition = node.getElementsByTagName("transition");
        int i = 0;
        while (i < nodesTransition.getLength()) {
            Element element = (Element)nodesTransition.item(i);
            if (element == null) {
                throw new IllegalArgumentException();
            }
            TmfXmlStateTransition transition = modelFactory.createStateTransition(element, container);
            transitions.add(transition);
            ++i;
        }
        return transitions;
    }

    /*
     * Exception decompiling
     */
    private static Type getStateType(Element node) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl34 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl34 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getId() {
        return this.fId;
    }

    public IXmlStateSystemContainer getContainer() {
        return this.fContainer;
    }

    public List<TmfXmlStateTransition> getTransitionList() {
        return this.fTransitions;
    }

    public List<String> getOnEntryActions() {
        return this.fOnEntryActions;
    }

    public List<String> getOnExitActions() {
        return this.fOnExitActions;
    }

    public Map<String, TmfXmlState> getChildren() {
        return this.fChildren;
    }

    public @Nullable TmfXmlStateTransition getInitialTransition() {
        return this.fInitialTransition;
    }

    public @Nullable String getInitialStateId() {
        return this.fInitialStateId;
    }

    public @Nullable String getFinalStateId() {
        return this.fFinalStateId;
    }

    public @Nullable TmfXmlState getParent() {
        return this.fparent;
    }

    public Type getType() {
        return this.fType;
    }

    public static enum Type {
        FINAL,
        INITIAL,
        FAIL,
        DEFAULT;

    }
}

