/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.util;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;

public class Pair<A, B> {
    private final A fFirst;
    private final B fSecond;

    public Pair(A first, B second) {
        this.fFirst = first;
        this.fSecond = second;
    }

    public A getFirst() {
        return this.fFirst;
    }

    public B getSecond() {
        return this.fSecond;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Pair.hashFromNullable(this.fFirst);
        result = 31 * result + Pair.hashFromNullable(this.fSecond);
        return result;
    }

    private static int hashFromNullable(@Nullable Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (!NonNullUtils.equalsNullable(other.fFirst, this.fFirst)) {
            return false;
        }
        return NonNullUtils.equalsNullable(other.fSecond, this.fSecond);
    }

    public String toString() {
        return "(" + this.fFirst + ", " + this.fSecond + ")";
    }
}

