/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.model.TmfImportHelper;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEditorInput;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class TmfOpenTraceHelper {
    private static final String ENDL = System.getProperty("line.separator");

    private TmfOpenTraceHelper() {
    }

    public static IStatus openTraceFromPath(TmfTraceFolder destinationFolder, String path, Shell shell) throws CoreException {
        return TmfOpenTraceHelper.openTraceFromPath(destinationFolder, path, shell, null);
    }

    public static IStatus openTraceFromPath(TmfTraceFolder destinationFolder, String path, Shell shell, String tracetypeHint) throws CoreException {
        String pathToUse = TmfOpenTraceHelper.checkTracePath(path);
        TraceTypeHelper traceTypeToSet = null;
        try {
            traceTypeToSet = TmfTraceTypeUIUtils.selectTraceType(pathToUse, null, tracetypeHint);
        }
        catch (TmfTraceImportException e) {
            MessageBox mb = new MessageBox(shell);
            mb.setMessage(e.getMessage());
            mb.open();
            return new Status(4, "org.eclipse.tracecompass.tmf.ui", e.getMessage());
        }
        IFolder folder = destinationFolder.getResource();
        String traceName = TmfOpenTraceHelper.getTraceName(pathToUse, folder);
        if (TmfOpenTraceHelper.traceExists(pathToUse, folder)) {
            return TmfOpenTraceHelper.openTraceFromFolder(destinationFolder, traceName);
        }
        IPath pathString = Path.fromOSString((String)pathToUse);
        IResource linkedTrace = TmfImportHelper.createLink(folder, pathString, traceName);
        if (linkedTrace == null || !linkedTrace.exists()) {
            return new Status(4, "org.eclipse.tracecompass.tmf.ui", Messages.TmfOpenTraceHelper_LinkFailed);
        }
        String sourceLocation = URIUtil.toUnencodedString((URI)pathString.toFile().toURI());
        linkedTrace.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
        if (traceTypeToSet == null) {
            return Status.OK_STATUS;
        }
        IStatus ret = TmfTraceTypeUIUtils.setTraceType(linkedTrace, traceTypeToSet);
        if (ret.isOK()) {
            ret = TmfOpenTraceHelper.openTraceFromFolder(destinationFolder, traceName);
        }
        return ret;
    }

    private static String checkTracePath(String path) {
        File file = new File(path);
        if (file.exists() && !file.isDirectory()) {
            File parent = file.getParentFile();
            String pathToUse = parent.getAbsolutePath();
            if (TmfTraceType.isDirectoryTrace((String)pathToUse)) {
                return pathToUse;
            }
            File grandParent = parent.getParentFile();
            if (grandParent != null && TmfTraceType.isDirectoryTrace((String)(pathToUse = grandParent.getAbsolutePath()))) {
                return pathToUse;
            }
        }
        return path;
    }

    private static boolean traceExists(String path, IFolder folder) {
        String val = TmfOpenTraceHelper.getTraceName(path, folder);
        return folder.findMember(val) != null;
    }

    private static boolean isWrongMember(IFolder folder, String name, File traceFile) {
        IResource candidate = folder.findMember(name);
        if (candidate != null) {
            IPath rawLocation = candidate.getRawLocation();
            File file = rawLocation.toFile();
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return !file.equals(traceFile);
        }
        return false;
    }

    private static String getTraceName(String path, IFolder folder) {
        File traceFile = new File(path);
        try {
            traceFile = traceFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String name = traceFile.getName();
        int i = 2;
        while (TmfOpenTraceHelper.isWrongMember(folder, name, traceFile)) {
            name = String.valueOf(traceFile.getName()) + '(' + i + ')';
            ++i;
        }
        return name;
    }

    private static IStatus openTraceFromFolder(TmfTraceFolder destinationFolder, String traceName) {
        List<ITmfProjectModelElement> elements = destinationFolder.getChildren();
        TmfTraceElement traceElement = null;
        for (ITmfProjectModelElement element : elements) {
            if (!(element instanceof TmfTraceElement) || !element.getName().equals(traceName)) continue;
            traceElement = (TmfTraceElement)element;
        }
        if (traceElement == null) {
            return new Status(4, "org.eclipse.tracecompass.tmf.ui", NLS.bind((String)Messages.TmfOpenTraceHelper_TraceNotFound, (Object)traceName));
        }
        TmfOpenTraceHelper.openTraceFromElement(traceElement);
        return Status.OK_STATUS;
    }

    private static ITmfTrace openTraceElement(TmfTraceElement traceElement) {
        ITmfTrace trace = traceElement.instantiateTrace();
        ITmfEvent traceEvent = traceElement.instantiateEvent();
        if (trace == null || traceEvent == null) {
            TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)traceElement.getTypeName()), Messages.TmfOpenTraceHelper_NoTraceType);
            if (trace != null) {
                trace.dispose();
            }
            return null;
        }
        try {
            trace.initTrace(traceElement.getResource(), traceElement.getResource().getLocation().toOSString(), traceEvent.getClass(), traceElement.getElementPath(), traceElement.getTraceType());
        }
        catch (TmfTraceException e) {
            TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)traceElement.getTypeName()), String.valueOf(Messages.TmfOpenTraceHelper_InitError) + ENDL + ENDL + (Object)((Object)e));
            trace.dispose();
            return null;
        }
        return trace;
    }

    private static ITmfTrace openExperimentElement(TmfExperimentElement experimentElement) {
        TmfExperiment experiment = experimentElement.instantiateTrace();
        if (experiment == null) {
            TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)experimentElement.getTypeName()), NLS.bind((String)Messages.TmfOpenTraceHelper_NoTraceOrExperimentType, (Object)experimentElement.getTypeName()));
            return null;
        }
        List<TmfTraceElement> traceEntries = experimentElement.getTraces();
        int cacheSize = Integer.MAX_VALUE;
        ITmfTrace[] traces = new ITmfTrace[traceEntries.size()];
        int i = 0;
        while (i < traceEntries.size()) {
            TmfTraceElement element = traceEntries.get(i);
            ITmfTrace trace = TmfOpenTraceHelper.openTraceElement(element = element.getElementUnderTraceFolder());
            if (trace == null) {
                int j = 0;
                while (j < i) {
                    traces[j].dispose();
                    ++j;
                }
                return null;
            }
            cacheSize = Math.min(cacheSize, trace.getCacheSize());
            traces[i] = trace;
            ++i;
        }
        experiment.initExperiment(ITmfEvent.class, experimentElement.getName(), traces, cacheSize, (IResource)experimentElement.getResource());
        return experiment;
    }

    private static ITmfTrace openProjectElement(TmfCommonProjectElement element) {
        ITmfTrace trace = null;
        if (element instanceof TmfTraceElement) {
            trace = TmfOpenTraceHelper.openTraceElement((TmfTraceElement)element);
        } else if (element instanceof TmfExperimentElement) {
            trace = TmfOpenTraceHelper.openExperimentElement((TmfExperimentElement)element);
        }
        return trace;
    }

    public static void openTraceFromElement(final TmfCommonProjectElement traceElement) {
        IFile file;
        try {
            file = traceElement.createBookmarksFile();
        }
        catch (CoreException e) {
            Activator.getDefault().logError(String.valueOf(NLS.bind((String)Messages.TmfOpenTraceHelper_ErrorOpeningElement, (Object)traceElement.getTypeName())) + ' ' + traceElement.getName());
            TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)traceElement.getTypeName()), String.valueOf(NLS.bind((String)Messages.TmfOpenTraceHelper_ErrorElement, (Object)traceElement.getTypeName())) + ENDL + ENDL + e.getMessage());
            return;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        final IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = TmfOpenTraceHelper.findEditor((IEditorInput)new FileEditorInput(file), true);
        if (editor != null) {
            activePage.activate((IWorkbenchPart)editor);
            return;
        }
        if (traceElement instanceof TmfTraceElement && traceElement.getResource() instanceof IFile && traceElement.getTraceType() == null) {
            try {
                boolean activate = OpenStrategy.activateOnOpen();
                IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)activate);
            }
            catch (PartInitException e) {
                TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)traceElement.getTypeName()), String.valueOf(NLS.bind((String)Messages.TmfOpenTraceHelper_ErrorOpeningElement, (Object)traceElement.getElementPath())) + ENDL + ENDL + e.getMessage());
            }
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                final ITmfTrace trace = TmfOpenTraceHelper.openProjectElement(traceElement);
                if (trace == null) {
                    return;
                }
                String traceEditorId = traceElement.getEditorId();
                final String editorId = traceEditorId != null ? traceEditorId : "org.eclipse.linuxtools.tmf.ui.editors.events";
                final TmfEditorInput editorInput = new TmfEditorInput(file, trace);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            activePage.openEditor(editorInput, editorId);
                            IDE.setDefaultEditor((IFile)file, (String)editorId);
                        }
                        catch (PartInitException e) {
                            TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)traceElement.getTypeName()), String.valueOf(NLS.bind((String)Messages.TmfOpenTraceHelper_ErrorOpeningElement, (Object)traceElement.getTypeName())) + ENDL + ENDL + e.getMessage());
                            Activator.getDefault().logError(String.valueOf(NLS.bind((String)Messages.TmfOpenTraceHelper_ErrorOpeningElement, (Object)traceElement.getTypeName())) + ' ' + traceElement.getName());
                            trace.dispose();
                        }
                    }
                });
            }
        };
        thread.start();
    }

    private static IEditorPart findEditor(IEditorInput input, boolean restore) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                IEditorInput editorInput = editorReference.getEditorInput();
                if (editorInput.equals(input)) {
                    return editorReference.getEditor(restore);
                }
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    public static void reopenTraceFromElement(final TmfCommonProjectElement traceElement, final IReusableEditor editor) {
        IFile file;
        try {
            file = traceElement.createBookmarksFile();
        }
        catch (CoreException e) {
            Activator.getDefault().logError(String.valueOf(NLS.bind((String)Messages.TmfOpenTraceHelper_ErrorOpeningElement, (Object)traceElement.getTypeName())) + ' ' + traceElement.getName());
            TraceUtils.displayErrorMsg(NLS.bind((String)Messages.TmfOpenTraceHelper_OpenElement, (Object)traceElement.getTypeName()), String.valueOf(NLS.bind((String)Messages.TmfOpenTraceHelper_ErrorElement, (Object)traceElement.getTypeName())) + ENDL + ENDL + e.getMessage());
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                ITmfTrace trace = TmfOpenTraceHelper.openProjectElement(traceElement);
                if (trace == null) {
                    return;
                }
                final TmfEditorInput editorInput = new TmfEditorInput(file, trace);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbench wb = PlatformUI.getWorkbench();
                        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                        activePage.reuseEditor(editor, editorInput);
                        activePage.activate((IWorkbenchPart)editor);
                    }
                });
            }
        };
        thread.start();
    }
}

