/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    int defaultCursor;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        if (OS.USE_CAIRO) {
            style |= 0x10000;
        }
        return Sash.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int border = this.getBorderWidthInPixels();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 3;
        } else {
            width += 3;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x10008;
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.handle, true);
        OS.gtk_widget_set_can_focus(this.handle, true);
        int type = (this.style & 0x200) != 0 ? 108 : 116;
        this.defaultCursor = OS.gdk_cursor_new_for_display(OS.gdk_display_get_default(), type);
    }

    void drawBand(int x, int y, int width, int height) {
        if ((this.style & 0x10000) != 0) {
            return;
        }
        int window = this.gtk_widget_get_window(this.parent.paintHandle());
        if (window == 0) {
            return;
        }
        byte[] bits = new byte[]{-86, 85, -86, 85, -86, 85, -86, 85};
        int stipplePixmap = OS.gdk_bitmap_create_from_data(window, bits, 8, 8);
        int gc = OS.gdk_gc_new(window);
        int colormap = OS.gdk_colormap_get_system();
        GdkColor color = new GdkColor();
        OS.gdk_color_white(colormap, color);
        OS.gdk_gc_set_foreground(gc, color);
        OS.gdk_gc_set_stipple(gc, stipplePixmap);
        OS.gdk_gc_set_subwindow(gc, 1);
        OS.gdk_gc_set_fill(gc, 2);
        OS.gdk_gc_set_function(gc, 2);
        OS.gdk_draw_rectangle(window, gc, 1, x, y, width, height);
        OS.g_object_unref(stipplePixmap);
        OS.g_object_unref(gc);
    }

    @Override
    int gtk_button_press_event(int widget, int eventPtr) {
        int result = super.gtk_button_press_event(widget, eventPtr);
        if (result != 0) {
            return result;
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, eventPtr, GdkEventButton.sizeof);
        int button = gdkEvent.button;
        if (button != 1) {
            return 0;
        }
        if (gdkEvent.type == 5) {
            return 0;
        }
        if (gdkEvent.type == 6) {
            return 0;
        }
        int window = this.gtk_widget_get_window(widget);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin(window, origin_x, origin_y);
        this.startX = (int)(gdkEvent.x_root - (double)origin_x[0]);
        this.startY = (int)(gdkEvent.y_root - (double)origin_y[0]);
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = allocation.width;
        int height = allocation.height;
        this.lastX = x;
        this.lastY = y;
        Event event = new Event();
        event.time = gdkEvent.time;
        Rectangle eventRect = new Rectangle(this.lastX, this.lastY, width, height);
        event.setBounds(DPIUtil.autoScaleDown(eventRect));
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - width) - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return 0;
        }
        if (event.doit) {
            this.dragging = true;
            Rectangle rect = DPIUtil.autoScaleUp(event.getBounds());
            this.lastX = rect.x;
            this.lastY = rect.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - width - this.lastX;
            }
            this.parent.update(true, (this.style & 0x10000) == 0);
            this.drawBand(this.lastX, rect.y, width, height);
            if ((this.style & 0x10000) != 0) {
                this.setBoundsInPixels(rect.x, rect.y, width, height);
            }
        }
        return result;
    }

    @Override
    int gtk_button_release_event(int widget, int eventPtr) {
        int result = super.gtk_button_release_event(widget, eventPtr);
        if (result != 0) {
            return result;
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, eventPtr, GdkEventButton.sizeof);
        int button = gdkEvent.button;
        if (button != 1) {
            return 0;
        }
        if (!this.dragging) {
            return 0;
        }
        this.dragging = false;
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        Event event = new Event();
        event.time = gdkEvent.time;
        Rectangle eventRect = new Rectangle(this.lastX, this.lastY, width, height);
        event.setBounds(DPIUtil.autoScaleDown(eventRect));
        this.drawBand(this.lastX, this.lastY, width, height);
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - width) - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return result;
        }
        if (event.doit && (this.style & 0x10000) != 0) {
            Rectangle rect = DPIUtil.autoScaleUp(event.getBounds());
            this.setBoundsInPixels(rect.x, rect.y, width, height);
        }
        return result;
    }

    @Override
    int gtk_draw(int widget, int cairo) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            int context = OS.gtk_widget_get_style_context(widget);
            GtkAllocation allocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(widget, allocation);
            int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
            int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
            OS.gtk_render_background(context, cairo, 0.0, 0.0, width, height);
        }
        return super.gtk_draw(widget, cairo);
    }

    @Override
    int gtk_focus_in_event(int widget, int event) {
        int result = super.gtk_focus_in_event(widget, event);
        if (result != 0) {
            return result;
        }
        if (this.handle != 0) {
            GtkAllocation allocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(this.handle, allocation);
            this.lastX = allocation.x;
            this.lastY = allocation.y;
        }
        return 0;
    }

    @Override
    int gtk_key_press_event(int widget, int eventPtr) {
        int result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0) {
            return result;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
        int keyval = gdkEvent.keyval;
        switch (keyval) {
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                int xChange = 0;
                int yChange = 0;
                int stepSize = 9;
                if ((gdkEvent.state & 4) != 0) {
                    stepSize = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (keyval == 65362 || keyval == 65364) break;
                    xChange = keyval == 65361 ? -stepSize : stepSize;
                } else {
                    if (keyval == 65361 || keyval == 65363) break;
                    yChange = keyval == 65362 ? -stepSize : stepSize;
                }
                int parentBorder = 0;
                GtkAllocation allocation = new GtkAllocation();
                OS.gtk_widget_get_allocation(this.handle, allocation);
                int width = allocation.width;
                int height = allocation.height;
                OS.gtk_widget_get_allocation(this.parent.handle, allocation);
                int parentWidth = allocation.width;
                int parentHeight = allocation.height;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, this.lastX + xChange - parentBorder - this.startX), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, this.lastY + yChange - parentBorder - this.startY), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return result;
                }
                int window = this.gtk_widget_get_window(this.handle);
                int grabMask = 516;
                int gdkCursor = this.cursor != null ? this.cursor.handle : this.defaultCursor;
                int ptrGrabResult = this.gdk_pointer_grab(window, 0, false, grabMask, window, gdkCursor, 0);
                Event event = new Event();
                event.time = gdkEvent.time;
                Rectangle eventRect = new Rectangle(newX, newY, width, height);
                event.setBounds(DPIUtil.autoScaleDown(eventRect));
                if ((this.parent.style & 0x8000000) != 0) {
                    event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - width) - event.x;
                }
                this.sendSelectionEvent(13, event, true);
                if (ptrGrabResult == 0) {
                    this.gdk_pointer_ungrab(window, 0);
                }
                if (this.isDisposed() || !event.doit) break;
                Rectangle rect = DPIUtil.autoScaleUp(event.getBounds());
                this.lastX = rect.x;
                this.lastY = rect.y;
                if ((this.parent.style & 0x8000000) != 0) {
                    this.lastX = this.parent.getClientWidth() - width - this.lastX;
                }
                if ((this.style & 0x10000) != 0) {
                    this.setBoundsInPixels(rect.x, rect.y, width, height);
                    if (this.isDisposed()) break;
                }
                int cursorX = rect.x;
                int cursorY = rect.y;
                if ((this.style & 0x200) != 0) {
                    cursorY += height / 2;
                } else {
                    cursorX += width / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplayInPixels(cursorX, cursorY));
            }
        }
        return result;
    }

    @Override
    int gtk_motion_notify_event(int widget, int eventPtr) {
        int eventState;
        int eventY;
        int eventX;
        int result = super.gtk_motion_notify_event(widget, eventPtr);
        if (result != 0) {
            return result;
        }
        if (!this.dragging) {
            return 0;
        }
        GdkEventMotion gdkEvent = new GdkEventMotion();
        OS.memmove(gdkEvent, eventPtr, GdkEventButton.sizeof);
        if (gdkEvent.is_hint != 0) {
            int[] pointer_x = new int[1];
            int[] pointer_y = new int[1];
            int[] mask = new int[1];
            this.gdk_window_get_device_position(gdkEvent.window, pointer_x, pointer_y, mask);
            eventX = pointer_x[0];
            eventY = pointer_y[0];
            eventState = mask[0];
        } else {
            int[] origin_x = new int[1];
            int[] origin_y = new int[1];
            OS.gdk_window_get_origin(gdkEvent.window, origin_x, origin_y);
            eventX = (int)(gdkEvent.x_root - (double)origin_x[0]);
            eventY = (int)(gdkEvent.y_root - (double)origin_y[0]);
            eventState = gdkEvent.state;
        }
        if ((eventState & 0x100) == 0) {
            return 0;
        }
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = allocation.width;
        int height = allocation.height;
        int parentBorder = 0;
        OS.gtk_widget_get_allocation(this.parent.handle, allocation);
        int parentWidth = allocation.width;
        int parentHeight = allocation.height;
        int newX = this.lastX;
        int newY = this.lastY;
        if ((this.style & 0x200) != 0) {
            newX = Math.min(Math.max(0, eventX + x - this.startX - parentBorder), parentWidth - width);
        } else {
            newY = Math.min(Math.max(0, eventY + y - this.startY - parentBorder), parentHeight - height);
        }
        if (newX == this.lastX && newY == this.lastY) {
            return 0;
        }
        this.drawBand(this.lastX, this.lastY, width, height);
        Event event = new Event();
        event.time = gdkEvent.time;
        Rectangle eventRect = new Rectangle(newX, newY, width, height);
        event.setBounds(DPIUtil.autoScaleDown(eventRect));
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - width) - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return 0;
        }
        Rectangle rect = DPIUtil.autoScaleUp(event.getBounds());
        if (event.doit) {
            this.lastX = rect.x;
            this.lastY = rect.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - width - this.lastX;
            }
        }
        this.parent.update(true, (this.style & 0x10000) == 0);
        this.drawBand(this.lastX, this.lastY, width, height);
        if ((this.style & 0x10000) != 0) {
            this.setBoundsInPixels(rect.x, this.lastY, width, height);
        }
        return result;
    }

    @Override
    int gtk_realize(int widget) {
        this.setCursor(this.cursor != null ? this.cursor.handle : 0);
        return super.gtk_realize(widget);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.gtk_widget_add_events(this.handle, 8);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.defaultCursor != 0) {
            this.gdk_cursor_unref(this.defaultCursor);
        }
        this.defaultCursor = 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void setCursor(int cursor) {
        super.setCursor(cursor != 0 ? cursor : this.defaultCursor);
    }

    @Override
    int traversalCode(int key, GdkEventKey event) {
        return 0;
    }
}

