/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;

public class LamiGenericAspect
extends LamiTableEntryAspect {
    private final int fColIndex;
    private final boolean fIsContinuous;
    private final boolean fIsTimeStamp;

    public LamiGenericAspect(String aspectName, @Nullable String units, int colIndex, boolean isContinuous, boolean isTimeStamp) {
        super(aspectName, units);
        this.fColIndex = colIndex;
        this.fIsContinuous = isContinuous;
        this.fIsTimeStamp = isTimeStamp;
    }

    @Override
    public boolean isContinuous() {
        return this.fIsContinuous;
    }

    @Override
    public boolean isTimeStamp() {
        return this.fIsTimeStamp;
    }

    @Override
    public @Nullable String resolveString(@NonNull LamiTableEntry entry) {
        return entry.getValue(this.fColIndex).toString();
    }

    @Override
    public @Nullable Double resolveDouble(@NonNull LamiTableEntry entry) {
        if (this.fIsContinuous) {
            try {
                if (entry.getValue(this.fColIndex).toString() != null) {
                    return Double.parseDouble(entry.getValue(this.fColIndex).toString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        if (this.isContinuous()) {
            return (o1, o2) -> {
                Double dO1 = this.resolveDouble((LamiTableEntry)o1);
                Double dO2 = this.resolveDouble((LamiTableEntry)o2);
                if (dO1 == null || dO2 == null) {
                    return 0;
                }
                return dO1.compareTo(dO2);
            };
        }
        return (o1, o2) -> {
            String s1 = this.resolveString((LamiTableEntry)o1);
            String s2 = this.resolveString((LamiTableEntry)o2);
            if (s1 == null || s2 == null) {
                return 0;
            }
            return s1.compareTo(s2);
        };
    }
}

