/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiProcess;

public class LamiProcessPIDAspect
extends LamiTableEntryAspect {
    private final int fColIndex;

    public LamiProcessPIDAspect(String colName, int colIndex) {
        super(String.valueOf(colName) + " (PID)", null);
        this.fColIndex = colIndex;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isTimeStamp() {
        return false;
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        LamiData data = entry.getValue(this.fColIndex);
        if (data instanceof LamiProcess) {
            Long pid = ((LamiProcess)data).getPID();
            if (pid == null) {
                return null;
            }
            return pid.toString();
        }
        return data.toString();
    }

    @Override
    public @Nullable Double resolveDouble(LamiTableEntry entry) {
        LamiData data = entry.getValue(this.fColIndex);
        if (data instanceof LamiProcess) {
            Long pid = ((LamiProcess)data).getPID();
            if (pid == null) {
                return null;
            }
            return (double)pid;
        }
        return null;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        return (o1, o2) -> {
            Double dO1 = this.resolveDouble((LamiTableEntry)o1);
            Double dO2 = this.resolveDouble((LamiTableEntry)o2);
            if (dO1 == null || dO2 == null) {
                return 0;
            }
            return dO1.compareTo(dO2);
        };
    }
}

