/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.Messages;

public class LamiIRQ
extends LamiData {
    private final Type fType;
    private final int fNumber;
    private final @Nullable String fName;

    public LamiIRQ(Type irqType, int nb, @Nullable String name) {
        this.fType = irqType;
        this.fNumber = nb;
        this.fName = name;
    }

    public @Nullable String getName() {
        return this.fName;
    }

    public Type getType() {
        return this.fType;
    }

    public int getNumber() {
        return this.fNumber;
    }

    @Override
    public @Nullable String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.fType) {
            case SOFT: {
                sb.append(Messages.LamiIRQ_SoftIRQ).append(' ');
                break;
            }
            default: {
                sb.append(Messages.LamiIRQ_HardwareIRQ).append(' ');
            }
        }
        sb.append(String.valueOf(this.fNumber));
        if (this.fName != null) {
            sb.append(" (" + this.fName + ')');
        }
        return sb.toString();
    }

    public static enum Type {
        HARD,
        SOFT;

    }
}

