/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiEmptyAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiChartModel;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiXYSeriesDescription;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.signals.LamiSelectionUpdateSignal;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiSeriesDialog;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiViewerControl;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.Messages;
import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public final class LamiReportViewTabPage
extends TmfComponent {
    private final LamiResultTable fResultTable;
    private final LamiViewerControl fTableViewerControl;
    private final Set<LamiViewerControl> fCustomGraphViewerControls = new LinkedHashSet<LamiViewerControl>();
    private final Composite fControl;
    private Set<Integer> fSelectionIndexes;

    public LamiReportViewTabPage(Composite parent, LamiResultTable table) {
        super(table.getTableClass().getTableTitle());
        LamiViewerControl tableViewerControl;
        this.fResultTable = table;
        this.fSelectionIndexes = new HashSet<Integer>();
        this.fSelectionIndexes = LamiReportViewTabPage.getIndexOfEntriesIntersectingTimerange((LamiResultTable)NonNullUtils.checkNotNull((Object)this.fResultTable), TmfTraceManager.getInstance().getCurrentTraceContext().getSelectionRange());
        this.fControl = parent;
        this.fTableViewerControl = tableViewerControl = new LamiViewerControl(this.fControl, this.fResultTable);
        tableViewerControl.getToggleAction().run();
        LamiSelectionUpdateSignal signal = new LamiSelectionUpdateSignal((Object)this, this.fSelectionIndexes, ((LamiResultTable)NonNullUtils.checkNotNull((Object)this.fResultTable)).hashCode());
        TmfSignalManager.dispatchSignal((TmfSignal)signal);
        this.fControl.addDisposeListener(e -> {
            this.fTableViewerControl.dispose();
            this.clearAllCustomViewers();
            super.dispose();
        });
    }

    public void dispose() {
        this.fControl.dispose();
    }

    public Composite getControl() {
        return this.fControl;
    }

    public LamiResultTable getResultTable() {
        return this.fResultTable;
    }

    public void clearAllCustomViewers() {
        this.fCustomGraphViewerControls.forEach(LamiViewerControl::dispose);
        this.fCustomGraphViewerControls.clear();
    }

    public void toggleTableViewer() {
        this.fTableViewerControl.getToggleAction().run();
    }

    public void createNewCustomChart(LamiChartModel.ChartType chartType) {
        int xLogScaleOptionIndex = -1;
        int yLogScaleOptionIndex = -1;
        List xStringColumn = this.fResultTable.getTableClass().getAspects().stream().filter(aspect -> !(aspect instanceof LamiEmptyAspect)).collect(Collectors.toList());
        List yStringColumn = this.fResultTable.getTableClass().getAspects().stream().filter(aspect -> !(aspect instanceof LamiEmptyAspect)).collect(Collectors.toList());
        switch (chartType) {
            case BAR_CHART: {
                yStringColumn = yStringColumn.stream().filter(aspect -> !aspect.isTimeStamp() && aspect.isContinuous()).collect(Collectors.toList());
                break;
            }
            case PIE_CHART: {
                break;
            }
            case XY_SCATTER: {
                break;
            }
        }
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)NonNullUtils.checkNotNull((Object)ArrayContentProvider.getInstance());
        LamiSeriesDialog dialog = new LamiSeriesDialog(this.getControl().getShell(), chartType, xStringColumn, yStringColumn, contentProvider, (ILabelProvider)new LabelProvider(){

            public String getText(@Nullable Object element) {
                return ((LamiTableEntryAspect)NonNullUtils.checkNotNull((Object)element)).getLabel();
            }
        }, contentProvider, (ILabelProvider)new LabelProvider(){

            public String getText(@Nullable Object element) {
                return ((LamiTableEntryAspect)NonNullUtils.checkNotNull((Object)element)).getLabel();
            }
        });
        dialog.setTitle(String.valueOf(chartType.toString()) + ' ' + Messages.LamiSeriesDialog_creation);
        switch (chartType) {
            case XY_SCATTER: {
                xLogScaleOptionIndex = dialog.addXCheckBoxOption(String.valueOf(Messages.LamiSeriesDialog_x_axis) + ' ' + Messages.LamiReportView_LogScale, false, new Predicate<LamiTableEntryAspect>(){

                    @Override
                    public boolean test(@NonNull LamiTableEntryAspect t) {
                        return t.isContinuous() && !t.isTimeStamp();
                    }
                });
                break;
            }
        }
        switch (chartType) {
            case BAR_CHART: 
            case XY_SCATTER: {
                yLogScaleOptionIndex = dialog.addYCheckBoxOption(String.valueOf(Messages.LamiSeriesDialog_y_axis) + ' ' + Messages.LamiReportView_LogScale, false, new Predicate<LamiTableEntryAspect>(){

                    @Override
                    public boolean test(@NonNull LamiTableEntryAspect t) {
                        return t.isContinuous() && !t.isTimeStamp();
                    }
                });
                break;
            }
        }
        if (dialog.open() != 0) {
            return;
        }
        List results = Arrays.stream(dialog.getResult()).map(serie -> (LamiXYSeriesDescription)serie).collect(Collectors.toList());
        boolean[] xCheckBoxOptionsResults = dialog.getXCheckBoxOptionValues();
        boolean[] yCheckBoxOptionsResults = dialog.getYCheckBoxOptionValues();
        boolean isXLogScale = false;
        boolean isYLogScale = false;
        if (xLogScaleOptionIndex > -1 && xLogScaleOptionIndex < xCheckBoxOptionsResults.length) {
            isXLogScale = xCheckBoxOptionsResults[xLogScaleOptionIndex];
        }
        if (yLogScaleOptionIndex > -1 && yLogScaleOptionIndex < yCheckBoxOptionsResults.length) {
            isYLogScale = yCheckBoxOptionsResults[yLogScaleOptionIndex];
        }
        List<Object> xAxisColString = new ArrayList();
        List<Object> yAxisColString = new ArrayList();
        switch (chartType) {
            case BAR_CHART: 
            case PIE_CHART: {
                if (results.stream().map(element -> element.getXAspect().getLabel()).distinct().count() != 1L) {
                    throw new IllegalStateException();
                }
                xAxisColString = results.stream().map(element -> element.getXAspect().getLabel()).distinct().collect(Collectors.toList());
                break;
            }
            case XY_SCATTER: {
                xAxisColString = results.stream().map(element -> element.getXAspect().getLabel()).collect(Collectors.toList());
                break;
            }
        }
        yAxisColString = results.stream().map(element -> element.getYAspect().getLabel()).collect(Collectors.toList());
        LamiChartModel model = new LamiChartModel(chartType, NonNullUtils.nullToEmptyString((Object)Messages.LamiReportView_Custom), xAxisColString, yAxisColString, isXLogScale, isYLogScale);
        LamiViewerControl viewerControl = new LamiViewerControl(this.fControl, this.fResultTable, model);
        this.fCustomGraphViewerControls.add(viewerControl);
        viewerControl.getToggleAction().run();
        LamiSelectionUpdateSignal signal = new LamiSelectionUpdateSignal((Object)this, this.fSelectionIndexes, ((LamiResultTable)NonNullUtils.checkNotNull((Object)this.fResultTable)).hashCode());
        TmfSignalManager.dispatchSignal((TmfSignal)signal);
    }

    @TmfSignalHandler
    public void updateSelection(LamiSelectionUpdateSignal signal) {
        LamiResultTable table = this.fResultTable;
        Object source = signal.getSource();
        if (table.hashCode() != signal.getSignalHash() || source == this || source instanceof LamiReportViewTabPage) {
            return;
        }
        Set<Integer> entryIndex = signal.getEntryIndex();
        if (entryIndex.isEmpty()) {
            return;
        }
        if (entryIndex.size() == 1) {
            int index = (Integer)Iterables.getOnlyElement(entryIndex);
            LamiTimeRange timeRange = ((LamiTableEntry)table.getEntries().get(index)).getCorrespondingTimeRange();
            if (timeRange != null) {
                ITmfTimestamp start = TmfTimestamp.fromNanos((long)timeRange.getStart());
                ITmfTimestamp end = TmfTimestamp.fromNanos((long)timeRange.getEnd());
                TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, start, end));
            }
        }
        this.fSelectionIndexes = entryIndex;
    }

    @TmfSignalHandler
    public void externalUpdateSelection(TmfSelectionRangeUpdatedSignal signal) {
        LamiResultTable table = this.fResultTable;
        if (signal.getSource() == this) {
            return;
        }
        TmfTimeRange range = new TmfTimeRange(signal.getBeginTime(), signal.getEndTime());
        Set<Integer> selections = LamiReportViewTabPage.getIndexOfEntriesIntersectingTimerange(table, range);
        LamiSelectionUpdateSignal signal1 = new LamiSelectionUpdateSignal((Object)this, selections, table.hashCode());
        TmfSignalManager.dispatchSignal((TmfSignal)signal1);
    }

    private static Set<Integer> getIndexOfEntriesIntersectingTimerange(LamiResultTable table, TmfTimeRange range) {
        HashSet<Integer> selections = new HashSet<Integer>();
        for (LamiTableEntry entry : table.getEntries()) {
            LamiTimeRange timerange = entry.getCorrespondingTimeRange();
            if (timerange == null) {
                return selections;
            }
            TmfTimeRange tempTimeRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)timerange.getStart()), TmfTimestamp.fromNanos((long)timerange.getEnd()));
            if (tempTimeRange.getIntersection(range) == null) continue;
            selections.add(table.getEntries().indexOf(entry));
        }
        return selections;
    }
}

