/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.latency;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public final class SystemCall
implements ISegment {
    private static final long serialVersionUID = 1554494342105208730L;
    private long fStartTime;
    private long fEndTime;
    private String fName;

    public SystemCall(InitialInfo info, long endTime) {
        this.fStartTime = info.fStartTime;
        this.fName = info.fName;
        this.fEndTime = endTime;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.fStartTime);
        out.writeLong(this.fEndTime);
        out.writeUTF(this.fName);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.fStartTime = in.readLong();
        this.fEndTime = in.readLong();
        this.fName = in.readUTF().intern();
    }

    public long getStart() {
        return this.fStartTime;
    }

    public long getEnd() {
        return this.fEndTime;
    }

    public String getName() {
        return this.fName;
    }

    public int compareTo(@NonNull ISegment o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return "Start Time = " + this.getStart() + "; End Time = " + this.getEnd() + "; Duration = " + this.getLength() + "; Name = " + this.getName();
    }

    public static class InitialInfo {
        private long fStartTime;
        private String fName;

        public InitialInfo(long startTime, String name) {
            this.fStartTime = startTime;
            this.fName = name.intern();
        }
    }
}

