/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageComposite;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageXYViewer;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.Messages;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;

public class CpuUsageView
extends TmfChartView {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.views.cpuusage";
    private @Nullable CpuUsageComposite fTreeViewer = null;
    private @Nullable CpuUsageXYViewer fXYViewer = null;

    public CpuUsageView() {
        super(Messages.CpuUsageView_Title);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            if (this.fTreeViewer != null) {
                this.fTreeViewer.traceSelected(signal);
            }
            if (this.fXYViewer != null) {
                this.fXYViewer.traceSelected(signal);
            }
        }
    }

    protected TmfXYChartViewer createChartViewer(Composite parent) {
        CpuUsageXYViewer viewer = new CpuUsageXYViewer(parent);
        viewer.setSendTimeAlignSignals(true);
        this.fXYViewer = viewer;
        return viewer;
    }

    public TmfViewer createLeftChildViewer(Composite parent) {
        CpuUsageComposite viewer = new CpuUsageComposite(parent);
        viewer.addSelectionChangeListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object structSelection;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (structSelection = ((IStructuredSelection)selection).getFirstElement()) instanceof CpuUsageEntry) {
                    CpuUsageEntry entry = (CpuUsageEntry)((Object)structSelection);
                    if (CpuUsageView.this.fTreeViewer != null) {
                        CpuUsageView.this.fTreeViewer.setSelectedThread(entry.getTid());
                    }
                    if (CpuUsageView.this.fXYViewer != null) {
                        CpuUsageView.this.fXYViewer.setSelectedThread(Long.valueOf(entry.getTid()));
                    }
                }
            }
        });
        viewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                super.controlResized(e);
            }
        });
        this.fTreeViewer = viewer;
        return this.fTreeViewer;
    }

    public void setFocus() {
        if (this.fXYViewer != null) {
            this.fXYViewer.getControl().setFocus();
        }
    }

    @TmfSignalHandler
    public void cpuSelect(TmfCpuSelectedSignal signal) {
        @Nullable CpuUsageXYViewer xyViewer = this.fXYViewer;
        @Nullable CpuUsageComposite treeViewer = this.fTreeViewer;
        if (xyViewer != null && treeViewer != null) {
            int core = signal.getCore();
            if (core >= 0) {
                xyViewer.addCpu(core);
                treeViewer.addCpu(core);
            } else {
                xyViewer.clearCpu();
                treeViewer.clearCpu();
            }
        }
    }
}

