/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics;

import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public class SegmentStoreStatistics {
    private ISegment fMin = new BasicSegment(0L, Long.MAX_VALUE);
    private ISegment fMax = new BasicSegment(Long.MIN_VALUE, 0L);
    private long fNbSegments = 0L;
    private double fAverage = 0.0;
    private double fVariance = 0.0;

    public long getMin() {
        return this.fMin.getLength();
    }

    public long getMax() {
        return this.fMax.getLength();
    }

    public ISegment getMinSegment() {
        return this.fMin;
    }

    public ISegment getMaxSegment() {
        return this.fMax;
    }

    public long getNbSegments() {
        return this.fNbSegments;
    }

    public double getAverage() {
        return this.fAverage;
    }

    public double getStdDev() {
        return this.fNbSegments > 2L ? Math.sqrt(this.fVariance / (double)(this.fNbSegments - 1L)) : Double.NaN;
    }

    public void update(ISegment segment) {
        long value = segment.getLength();
        long min = this.fMin.getLength();
        long max = this.fMax.getLength();
        this.fMin = min <= value ? this.fMin : segment;
        this.fMax = max >= value ? this.fMax : segment;
        ++this.fNbSegments;
        double delta = (double)value - this.fAverage;
        this.fAverage += delta / (double)this.fNbSegments;
        this.fVariance += delta * ((double)value - this.fAverage);
    }
}

