/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.trace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.trace.CTFResponse;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInputReader;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputReaderTimestampComparator;

public class CTFTraceReader
implements AutoCloseable {
    private static final int LINE_LENGTH = 60;
    private static final int MIN_PRIO_SIZE = 16;
    private final CTFTrace fTrace;
    private final List<CTFStreamInputReader> fStreamInputReaders = Collections.synchronizedList(new ArrayList());
    private PriorityQueue<CTFStreamInputReader> fPrio;
    private long[] fEventCountPerTraceFile;
    private long fStartTime;
    private long fEndTime;
    private boolean fClosed = false;

    public CTFTraceReader(CTFTrace trace) throws CTFException {
        this.fTrace = trace;
        this.fStreamInputReaders.clear();
        this.createStreamInputReaders();
        this.populateStreamInputReaderHeap();
        this.fStartTime = 0L;
        if (this.hasMoreEvents()) {
            this.fStartTime = ((IEventDefinition)NonNullUtils.checkNotNull((Object)this.getTopStream().getCurrentEvent())).getTimestamp();
            this.setEndTime(this.fStartTime);
        }
    }

    public CTFTraceReader copyFrom() throws CTFException {
        CTFTraceReader newReader = null;
        newReader = new CTFTraceReader(this.fTrace);
        newReader.fStartTime = this.fStartTime;
        newReader.setEndTime(this.fEndTime);
        return newReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<CTFStreamInputReader> list = this.fStreamInputReaders;
        synchronized (list) {
            for (CTFStreamInputReader reader : this.fStreamInputReaders) {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
            this.fStreamInputReaders.clear();
        }
        this.fPrio.clear();
        this.fClosed = true;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    protected final void setEndTime(long endTime) {
        this.fEndTime = endTime;
    }

    protected PriorityQueue<CTFStreamInputReader> getPrio() {
        return this.fPrio;
    }

    private void createStreamInputReaders() throws CTFException {
        for (ICTFStream stream : this.fTrace.getStreams()) {
            Set<CTFStreamInput> streamInputs = stream.getStreamInputs();
            for (CTFStreamInput streamInput : streamInputs) {
                this.fStreamInputReaders.add(new CTFStreamInputReader((CTFStreamInput)NonNullUtils.checkNotNull((Object)streamInput)));
            }
        }
        this.fEventCountPerTraceFile = new long[this.fStreamInputReaders.size()];
    }

    public boolean isClosed() {
        return this.fClosed;
    }

    public void update() throws CTFException {
        HashSet<CTFStreamInputReader> readers = new HashSet<CTFStreamInputReader>();
        for (ICTFStream stream : this.fTrace.getStreams()) {
            Set<CTFStreamInput> streamInputs = stream.getStreamInputs();
            for (CTFStreamInput streamInput : streamInputs) {
                try {
                    Throwable throwable = null;
                    Object var8_11 = null;
                    try (CTFStreamInputReader streamInputReader = new CTFStreamInputReader((CTFStreamInput)NonNullUtils.checkNotNull((Object)streamInput));){
                        if (this.fStreamInputReaders.contains(streamInputReader)) continue;
                        CTFStreamInputReader streamInputReaderToAdd = new CTFStreamInputReader((CTFStreamInput)NonNullUtils.checkNotNull((Object)streamInput));
                        streamInputReaderToAdd.readNextEvent();
                        this.fStreamInputReaders.add(streamInputReaderToAdd);
                        readers.add(streamInputReaderToAdd);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
        }
        long[] temp = this.fEventCountPerTraceFile;
        this.fEventCountPerTraceFile = new long[readers.size() + temp.length];
        for (CTFStreamInputReader reader : readers) {
            this.fPrio.add(reader);
        }
        int i = 0;
        while (i < temp.length) {
            this.fEventCountPerTraceFile[i] = temp[i];
            ++i;
        }
    }

    public Iterable<IEventDeclaration> getEventDeclarations() {
        HashSet<IEventDeclaration> retSet = new HashSet<IEventDeclaration>();
        for (CTFStreamInputReader sir : this.fStreamInputReaders) {
            retSet.addAll(sir.getEventDeclarations());
        }
        retSet.remove(null);
        return retSet;
    }

    private void populateStreamInputReaderHeap() throws CTFException {
        if (this.fStreamInputReaders.isEmpty()) {
            this.fPrio = new PriorityQueue<CTFStreamInputReader>(16, new StreamInputReaderTimestampComparator());
            return;
        }
        this.fPrio = new PriorityQueue<CTFStreamInputReader>(Math.max(this.fStreamInputReaders.size() * 2, 16), new StreamInputReaderTimestampComparator());
        int pos = 0;
        for (CTFStreamInputReader reader : this.fStreamInputReaders) {
            CTFResponse readNextEvent = reader.readNextEvent();
            if (readNextEvent != CTFResponse.OK && readNextEvent != CTFResponse.WAIT) continue;
            this.fPrio.add(reader);
            this.fEventCountPerTraceFile[pos] = 0L;
            reader.setName(pos);
            ++pos;
        }
    }

    public IEventDefinition getCurrentEventDef() {
        CTFStreamInputReader top = this.getTopStream();
        return top != null ? top.getCurrentEvent() : null;
    }

    public boolean advance() throws CTFException {
        CTFStreamInputReader top = this.fPrio.poll();
        if (top == null) {
            return false;
        }
        switch (top.readNextEvent()) {
            case OK: {
                this.fPrio.add(top);
                IEventDefinition currentEvent = (IEventDefinition)NonNullUtils.checkNotNull((Object)top.getCurrentEvent());
                long topEnd = this.fTrace.timestampCyclesToNanos(currentEvent.getTimestamp());
                this.setEndTime(Math.max(topEnd, this.getEndTime()));
                int n = top.getName();
                this.fEventCountPerTraceFile[n] = this.fEventCountPerTraceFile[n] + 1L;
                this.fEndTime = Math.max(currentEvent.getTimestamp(), this.fEndTime);
                break;
            }
            case WAIT: {
                this.fPrio.add(top);
                break;
            }
        }
        return this.hasMoreEvents();
    }

    public void goToLastEvent() throws CTFException {
        this.seek(this.getEndTime());
        while (this.fPrio.size() > 1) {
            this.advance();
        }
    }

    public boolean seek(long timestamp) throws CTFException {
        this.fPrio.clear();
        for (CTFStreamInputReader streamInputReader : this.fStreamInputReaders) {
            streamInputReader.seek(timestamp);
            if (streamInputReader.getCurrentEvent() == null) continue;
            this.fPrio.add(streamInputReader);
        }
        return this.hasMoreEvents();
    }

    public CTFStreamInputReader getTopStream() {
        return this.fPrio.peek();
    }

    public final boolean hasMoreEvents() {
        return this.fPrio.size() > 0;
    }

    public void printStats() {
        this.printStats(60);
    }

    public void printStats(int width) {
        int numEvents = 0;
        if (width == 0) {
            return;
        }
        long[] lArray = this.fEventCountPerTraceFile;
        int n = this.fEventCountPerTraceFile.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            numEvents = (int)((long)numEvents + i);
            ++n2;
        }
        int j = 0;
        while (j < this.fEventCountPerTraceFile.length) {
            CTFStreamInputReader se = this.fStreamInputReaders.get(j);
            long len = (long)width * this.fEventCountPerTraceFile[se.getName()] / (long)numEvents;
            StringBuilder sb = new StringBuilder(se.getFilename());
            sb.append("\t[");
            int i = 0;
            while ((long)i < len) {
                sb.append('+');
                ++i;
            }
            long i2 = len;
            while (i2 < (long)width) {
                sb.append(' ');
                ++i2;
            }
            sb.append("]\t" + this.fEventCountPerTraceFile[se.getName()] + " Events");
            Activator.log(sb.toString());
            ++j;
        }
    }

    public long getEndTime() {
        return this.fEndTime;
    }

    public void setLive(boolean live) {
        for (CTFStreamInputReader s : this.fPrio) {
            s.setLive(live);
        }
    }

    public boolean isLive() {
        return this.getTopStream().isLive();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.fStartTime ^ this.fStartTime >>> 32);
        result = 31 * result + this.fStreamInputReaders.hashCode();
        result = 31 * result + (this.fTrace == null ? 0 : this.fTrace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CTFTraceReader)) {
            return false;
        }
        CTFTraceReader other = (CTFTraceReader)obj;
        if (!this.fStreamInputReaders.equals(other.fStreamInputReaders)) {
            return false;
        }
        return !(this.fTrace == null ? other.fTrace != null : !this.fTrace.equals(other.fTrace));
    }

    public String toString() {
        return "CTFTraceReader [trace=" + this.fTrace + ']';
    }

    public CTFTrace getTrace() {
        return this.fTrace;
    }

    public void populateIndex() throws CTFException {
        for (CTFStreamInputReader sir : this.fPrio) {
            sir.goToLastEvent();
        }
        this.seek(0L);
    }
}

