/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.EventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TraceEventPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;

public class TraceEventComponent
extends TraceControlComponent {
    public static final String TRACE_EVENT_ICON_FILE_ENABLED = "icons/obj16/event_enabled.gif";
    public static final String TRACE_EVENT_ICON_FILE_DISABLED = "icons/obj16/event_disabled.gif";
    protected IEventInfo fEventInfo = null;
    private Image fDisabledImage = null;

    public TraceEventComponent(String name, ITraceControlComponent parent) {
        super(name, parent);
        this.setImage(TRACE_EVENT_ICON_FILE_ENABLED);
        this.setToolTip(Messages.TraceControl_EventDisplayName);
        this.fEventInfo = new EventInfo(name);
        this.fDisabledImage = Activator.getDefault().loadIcon(TRACE_EVENT_ICON_FILE_DISABLED);
    }

    @Override
    public Image getImage() {
        if (this.fEventInfo.getState() == TraceEnablement.DISABLED) {
            return this.fDisabledImage;
        }
        return super.getImage();
    }

    public void setEventInfo(IEventInfo eventInfo) {
        this.fEventInfo = eventInfo;
    }

    public TraceEventType getEventType() {
        return this.fEventInfo.getEventType();
    }

    public void setEventType(TraceEventType type) {
        this.fEventInfo.setEventType(type);
    }

    public void setEventType(String typeName) {
        this.fEventInfo.setEventType(typeName);
    }

    public TraceEnablement getState() {
        return this.fEventInfo.getState();
    }

    public void setState(TraceEnablement state) {
        this.fEventInfo.setState(state);
    }

    public void setState(String stateName) {
        this.fEventInfo.setState(stateName);
    }

    public TraceLogLevel getLogLevel() {
        return this.fEventInfo.getLogLevel();
    }

    public void setLogLevel(TraceLogLevel level) {
        this.fEventInfo.setLogLevel(level);
    }

    public void setLogLevel(String levelName) {
        this.fEventInfo.setLogLevel(levelName);
    }

    public String getFilterExpression() {
        return this.fEventInfo.getFilterExpression();
    }

    public void setFilterExpression(String filter) {
        this.fEventInfo.setFilterExpression(filter);
    }

    public LogLevelType getLogLevelType() {
        return this.fEventInfo.getLogLevelType();
    }

    public void setLogLevelType(LogLevelType levelType) {
        this.fEventInfo.setLogLevelType(levelType);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySource.class) {
            return adapter.cast(new TraceEventPropertySource(this));
        }
        return null;
    }

    public TargetNodeComponent getTargetNode() {
        return ((TraceChannelComponent)this.getParent()).getTargetNode();
    }

    public String getSessionName() {
        return ((TraceChannelComponent)this.getParent()).getSessionName();
    }

    public TraceSessionComponent getSession() {
        return ((TraceChannelComponent)this.getParent()).getSession();
    }

    public String getChannelName() {
        return this.getParent().getName();
    }

    public boolean isKernel() {
        return ((TraceChannelComponent)this.getParent()).isKernel();
    }

    public void addContexts(List<String> contexts, IProgressMonitor monitor) throws ExecutionException {
        this.getControlService().addContexts(this.getSessionName(), this.getChannelName(), this.getName(), this.isKernel(), contexts, monitor);
    }
}

