/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.Activator;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.layout.LttngUst28EventLayout;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class UstDebugInfoStateProvider
extends AbstractTmfStateProvider {
    public static final String IS_PIC_ATTRIB = "is_pic";
    private static final int VERSION = 2;
    private static final int DL_DLOPEN_INDEX = 1;
    private static final int DL_BUILD_ID_INDEX = 2;
    private static final int DL_DEBUG_LINK_INDEX = 3;
    private static final int DL_DLCLOSE_INDEX = 4;
    private static final int STATEDUMP_BIN_INFO_INDEX = 5;
    private static final int STATEDUMP_BUILD_ID_INDEX = 6;
    private static final int STATEDUMP_DEBUG_LINK_INDEX = 7;
    private final LttngUst28EventLayout fLayout;
    private final Map<String, Integer> fEventNames;
    private final Map<Long, BinInfo> fPendingEntries = new HashMap<Long, BinInfo>();

    public UstDebugInfoStateProvider(LttngUstTrace trace) {
        super((ITmfTrace)trace, "Ust:DebugInfo");
        ILttngUstEventLayout layout = trace.getEventLayout();
        if (!(layout instanceof LttngUst28EventLayout)) {
            throw new IllegalStateException("Debug info analysis was started with an incompatible trace.");
        }
        this.fLayout = (LttngUst28EventLayout)layout;
        this.fEventNames = UstDebugInfoStateProvider.buildEventNames(this.fLayout);
    }

    private static Map<String, Integer> buildEventNames(LttngUst28EventLayout layout) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)layout.eventDlOpen(), (Object)1);
        builder.put((Object)layout.eventDlBuildId(), (Object)2);
        builder.put((Object)layout.eventDlDebugLink(), (Object)3);
        builder.put((Object)layout.eventDlClose(), (Object)4);
        builder.put((Object)layout.eventStatedumpBinInfo(), (Object)5);
        builder.put((Object)layout.eventStateDumpBuildId(), (Object)6);
        builder.put((Object)layout.eventStateDumpDebugLink(), (Object)7);
        return builder.build();
    }

    protected void eventHandle(ITmfEvent event) {
        ITmfEventField vpidCtx = event.getContent().getField(new String[]{this.fLayout.contextVpid()});
        if (vpidCtx == null) {
            return;
        }
        Long vpid = (Long)vpidCtx.getValue();
        if (vpid == null) {
            return;
        }
        @NonNull ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        String name = event.getName();
        Integer index = this.fEventNames.get(name);
        if (index == null) {
            return;
        }
        int intIndex = index;
        try {
            switch (intIndex) {
                case 1: 
                case 5: {
                    this.handleOpen(event, vpid, ss);
                    break;
                }
                case 2: 
                case 6: {
                    this.handleBuildId(event, vpid, ss);
                    break;
                }
                case 3: 
                case 7: {
                    break;
                }
                case 4: {
                    this.handleClose(event, vpid, ss);
                    break;
                }
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.getDefault().logError("Unexpected exception in UstDebugInfoStateProvider", e);
        }
    }

    private void handleOpen(ITmfEvent event, Long vpid, ITmfStateSystemBuilder ss) {
        Long baddr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldBaddr()}).getValue();
        Long memsz = (Long)event.getContent().getField(new String[]{this.fLayout.fieldMemsz()}).getValue();
        String sopath = (String)event.getContent().getField(new String[]{this.fLayout.fieldPath()}).getValue();
        ITmfEventField isPicField = event.getContent().getField(new String[]{this.fLayout.fieldIsPic()});
        Long isPicVal = isPicField == null ? 1L : (Long)isPicField.getValue();
        long endAddr = baddr + memsz;
        int addrQuark = ss.getQuarkAbsoluteAndAdd(new String[]{vpid.toString(), baddr.toString()});
        long ts = event.getTimestamp().getValue();
        ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueLong((long)endAddr), addrQuark);
        BinInfo binInfo = new BinInfo(baddr, (String)NonNullUtils.checkNotNull((Object)sopath), isPicVal.intValue());
        this.fPendingEntries.put(binInfo.fBaddr, binInfo);
    }

    private void handleBuildId(ITmfEvent event, Long vpid, ITmfStateSystemBuilder ss) throws AttributeNotFoundException {
        Long baddr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldBaddr()}).getValue();
        long[] buildIdArray = (long[])NonNullUtils.checkNotNull((Object)((long[])event.getContent().getField(new String[]{this.fLayout.fieldBuildId()}).getValue()));
        String buildId = BaseEncoding.base16().encode(UstDebugInfoStateProvider.longArrayToByteArray(buildIdArray)).toLowerCase();
        BinInfo binInfo = this.fPendingEntries.remove(baddr);
        if (binInfo == null) {
            Activator.getDefault().logWarning("UstDebugInfoStateProvider: Received a build_id event without a matching soinfo/dlopen one.");
            return;
        }
        int addrQuark = ss.getQuarkAbsolute(new String[]{vpid.toString(), baddr.toString()});
        int buildIdQuark = ss.getQuarkRelativeAndAdd(addrQuark, new String[]{buildId});
        long ts = event.getTimestamp().getValue();
        ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueString((String)binInfo.fPath), buildIdQuark);
        int isPicQuark = ss.getQuarkRelativeAndAdd(buildIdQuark, new String[]{IS_PIC_ATTRIB});
        ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueInt((int)binInfo.fIsPic), isPicQuark);
    }

    private void handleClose(ITmfEvent event, Long vpid, ITmfStateSystemBuilder ss) {
        Long baddr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldBaddr()}).getValue();
        try {
            int quark = ss.getQuarkAbsolute(new String[]{vpid.toString(), baddr.toString()});
            long ts = event.getTimestamp().getValue();
            ss.removeAttribute(ts, quark);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
    }

    private static byte[] longArrayToByteArray(long[] array) {
        byte[] ret = new byte[array.length];
        int i = 0;
        while (i < array.length) {
            ret[i] = (byte)array[i];
            ++i;
        }
        return ret;
    }

    public ITmfStateProvider getNewInstance() {
        return new UstDebugInfoStateProvider(this.getTrace());
    }

    public LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public int getVersion() {
        return 2;
    }

    private static class BinInfo {
        public final long fBaddr;
        public final String fPath;
        public final int fIsPic;

        public BinInfo(long baddr, String path, int isPic) {
            this.fBaddr = baddr;
            this.fPath = path;
            this.fIsPic = isPic;
        }
    }
}

