/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo;

import com.google.common.collect.Iterables;
import java.io.File;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo.FileOffsetMapper;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.BinaryCallsite;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.SourceCallsite;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryAspect;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;

public class UstDebugInfoSourceAspect
implements ITmfEventAspect<SourceCallsite> {
    public static final UstDebugInfoSourceAspect INSTANCE = new UstDebugInfoSourceAspect();

    private UstDebugInfoSourceAspect() {
    }

    public String getName() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_SourceAspectName);
    }

    public String getHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_SourceAspectHelpText);
    }

    public @Nullable SourceCallsite resolve(ITmfEvent event) {
        if (!(event.getTrace() instanceof LttngUstTrace)) {
            return null;
        }
        LttngUstTrace trace = (LttngUstTrace)event.getTrace();
        BinaryCallsite bc = UstDebugInfoBinaryAspect.INSTANCE.resolve(event);
        if (bc == null) {
            return null;
        }
        return UstDebugInfoSourceAspect.getSourceCallsite(trace, bc);
    }

    public static @Nullable SourceCallsite getSourceCallsite(LttngUstTrace trace, BinaryCallsite bc) {
        Iterable<SourceCallsite> callsites = FileOffsetMapper.getCallsiteFromOffset(new File(bc.getBinaryFilePath()), bc.getBuildId(), bc.getOffset());
        if (callsites == null || Iterables.isEmpty(callsites)) {
            return null;
        }
        SourceCallsite callsite = (SourceCallsite)((Object)Iterables.getLast(callsites));
        String pathPrefix = trace.getSymbolProviderConfig().getActualRootDirPath();
        if (pathPrefix.isEmpty()) {
            return callsite;
        }
        String fullFileName = String.valueOf(pathPrefix) + callsite.getFileName();
        return new SourceCallsite(fullFileName, callsite.getFunctionName(), callsite.getLineNumber());
    }
}

