/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.udp;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.packet.Packet;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.protocol.udp.UDPEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.unknown.UnknownPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;

public class UDPPacket
extends Packet {
    private final @Nullable Packet fChildPacket;
    private final @Nullable ByteBuffer fPayload;
    private final int fSourcePort;
    private final int fDestinationPort;
    private final int fTotalLength;
    private final int fChecksum;
    private @Nullable UDPEndpoint fSourceEndpoint = null;
    private @Nullable UDPEndpoint fDestinationEndpoint = null;
    private @Nullable Map<String, String> fFields = null;

    public UDPPacket(PcapFile file, @Nullable Packet parent, ByteBuffer packet) throws BadPacketException {
        super(file, parent, PcapProtocol.UDP);
        packet.order(ByteOrder.BIG_ENDIAN);
        packet.position(0);
        this.fSourcePort = ConversionHelper.unsignedShortToInt(packet.getShort());
        this.fDestinationPort = ConversionHelper.unsignedShortToInt(packet.getShort());
        this.fTotalLength = ConversionHelper.unsignedShortToInt(packet.getShort());
        this.fChecksum = ConversionHelper.unsignedShortToInt(packet.getShort());
        if (packet.array().length - packet.position() > 0) {
            byte[] array = new byte[packet.array().length - packet.position()];
            packet.get(array);
            ByteBuffer payload = ByteBuffer.wrap(array);
            payload.order(ByteOrder.BIG_ENDIAN);
            payload.position(0);
            this.fPayload = payload;
        } else {
            this.fPayload = null;
        }
        this.fChildPacket = this.findChildPacket();
    }

    @Override
    public @Nullable Packet getChildPacket() {
        return this.fChildPacket;
    }

    @Override
    public @Nullable ByteBuffer getPayload() {
        return this.fPayload;
    }

    @Override
    protected @Nullable Packet findChildPacket() throws BadPacketException {
        ByteBuffer payload = this.fPayload;
        if (payload == null) {
            return null;
        }
        return new UnknownPacket(this.getPcapFile(), (Packet)this, payload);
    }

    public String toString() {
        String string = String.valueOf(this.getProtocol().getName()) + ", Source Port: " + this.fSourcePort + ", Destination Port: " + this.fDestinationPort + ", Length: " + this.fTotalLength + ", Checksum: " + this.fChecksum + "\n";
        Packet child = this.fChildPacket;
        if (child != null) {
            return String.valueOf(string) + child.toString();
        }
        return string;
    }

    public int getSourcePort() {
        return this.fSourcePort;
    }

    public int getDestinationPort() {
        return this.fDestinationPort;
    }

    public int getTotalLength() {
        return this.fTotalLength;
    }

    public int getChecksum() {
        return this.fChecksum;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public UDPEndpoint getSourceEndpoint() {
        @Nullable UDPEndpoint endpoint = this.fSourceEndpoint;
        if (endpoint == null) {
            endpoint = new UDPEndpoint(this, true);
        }
        this.fSourceEndpoint = endpoint;
        return this.fSourceEndpoint;
    }

    @Override
    public UDPEndpoint getDestinationEndpoint() {
        @Nullable UDPEndpoint endpoint = this.fDestinationEndpoint;
        if (endpoint == null) {
            endpoint = new UDPEndpoint(this, false);
        }
        this.fDestinationEndpoint = endpoint;
        return this.fDestinationEndpoint;
    }

    @Override
    public Map<String, String> getFields() {
        Map<String, String> map = this.fFields;
        if (map == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"Source Port", (Object)String.valueOf(this.fSourcePort)).put((Object)"Destination Port", (Object)String.valueOf(this.fDestinationPort)).put((Object)"Length", (Object)(String.valueOf(String.valueOf(this.fTotalLength)) + " bytes")).put((Object)"Checksum", (Object)String.format("%s%04x", "0x", this.fChecksum));
            this.fFields = builder.build();
            return this.fFields;
        }
        return map;
    }

    @Override
    public String getLocalSummaryString() {
        return "Src Port: " + this.fSourcePort + ", Dst Port: " + this.fDestinationPort;
    }

    @Override
    protected String getSignificationString() {
        return "Source Port: " + this.fSourcePort + ", Destination Port: " + this.fDestinationPort;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fChecksum;
        Packet child = this.fChildPacket;
        result = child != null ? 31 * result + child.hashCode() : (result *= 31);
        result = 31 * result + this.fDestinationPort;
        ByteBuffer payload = this.fPayload;
        result = payload != null ? 31 * result + payload.hashCode() : (result *= 31);
        result = 31 * result + this.fSourcePort;
        result = 31 * result + this.fTotalLength;
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UDPPacket other = (UDPPacket)obj;
        if (this.fChecksum != other.fChecksum) {
            return false;
        }
        if (!NonNullUtils.equalsNullable((Object)this.fChildPacket, (Object)other.fChildPacket)) {
            return false;
        }
        if (this.fDestinationPort != other.fDestinationPort) {
            return false;
        }
        if (!NonNullUtils.equalsNullable((Object)this.fPayload, (Object)other.fPayload)) {
            return false;
        }
        if (this.fSourcePort != other.fSourcePort) {
            return false;
        }
        return this.fTotalLength == other.fTotalLength;
    }
}

