/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;

public final class CoreNode
extends HTNode {
    private static final int SIZE_INT = 4;
    private static final int SIZE_LONG = 8;
    private int nbChildren = 0;
    private int[] children;
    private long[] childStart;
    private volatile int extension = -1;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(false);

    public CoreNode(HTConfig config, int seqNumber, int parentSeqNumber, long start) {
        super(config, seqNumber, parentSeqNumber, start);
        int size = config.getMaxChildren();
        this.children = new int[size];
        this.childStart = new long[size];
    }

    @Override
    protected void readSpecificHeader(ByteBuffer buffer) {
        int size = this.getConfig().getMaxChildren();
        this.extension = buffer.getInt();
        this.nbChildren = buffer.getInt();
        this.children = new int[size];
        int i = 0;
        while (i < this.nbChildren) {
            this.children[i] = buffer.getInt();
            ++i;
        }
        i = this.nbChildren;
        while (i < size) {
            buffer.getInt();
            ++i;
        }
        this.childStart = new long[size];
        i = 0;
        while (i < this.nbChildren) {
            this.childStart[i] = buffer.getLong();
            ++i;
        }
        i = this.nbChildren;
        while (i < size) {
            buffer.getLong();
            ++i;
        }
    }

    @Override
    protected void writeSpecificHeader(ByteBuffer buffer) {
        int size = this.getConfig().getMaxChildren();
        buffer.putInt(this.extension);
        buffer.putInt(this.nbChildren);
        int i = 0;
        while (i < this.nbChildren) {
            buffer.putInt(this.children[i]);
            ++i;
        }
        i = this.nbChildren;
        while (i < size) {
            buffer.putInt(0);
            ++i;
        }
        i = 0;
        while (i < this.nbChildren) {
            buffer.putLong(this.childStart[i]);
            ++i;
        }
        i = this.nbChildren;
        while (i < size) {
            buffer.putLong(0L);
            ++i;
        }
    }

    public int getNbChildren() {
        this.rwl.readLock().lock();
        int ret = this.nbChildren;
        this.rwl.readLock().unlock();
        return ret;
    }

    public int getChild(int index) {
        this.rwl.readLock().lock();
        try {
            int n = this.children[index];
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public int getLatestChild() {
        this.rwl.readLock().lock();
        try {
            int n = this.children[this.nbChildren - 1];
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public long getChildStart(int index) {
        this.rwl.readLock().lock();
        try {
            long l = this.childStart[index];
            return l;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public long getLatestChildStart() {
        this.rwl.readLock().lock();
        try {
            long l = this.childStart[this.nbChildren - 1];
            return l;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public int getExtensionSequenceNumber() {
        return this.extension;
    }

    public void linkNewChild(HTNode childNode) {
        this.rwl.writeLock().lock();
        try {
            assert (this.nbChildren < this.getConfig().getMaxChildren());
            this.children[this.nbChildren] = childNode.getSequenceNumber();
            this.childStart[this.nbChildren] = childNode.getNodeStart();
            ++this.nbChildren;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public HTNode.NodeType getNodeType() {
        return HTNode.NodeType.CORE;
    }

    @Override
    protected int getSpecificHeaderSize() {
        int maxChildren = this.getConfig().getMaxChildren();
        int specificSize = 8 + 4 * maxChildren + 8 * maxChildren;
        return specificSize;
    }

    @Override
    public String toStringSpecific() {
        return String.format("Core Node, %d children %s", this.nbChildren, Arrays.toString(Arrays.copyOf(this.children, this.nbChildren)));
    }
}

