/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.CoreNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTree;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public class HistoryTreeBackend
implements IStateHistoryBackend {
    private final @NonNull String fSsid;
    private final HistoryTree fSht;
    private volatile boolean fFinishedBuilding = false;

    protected boolean isFinishedBuilding() {
        return this.fFinishedBuilding;
    }

    protected void setFinishedBuilding(boolean isFinishedBuilding) {
        this.fFinishedBuilding = isFinishedBuilding;
    }

    public HistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime, int blockSize, int maxChildren) throws IOException {
        this.fSsid = ssid;
        HTConfig conf = new HTConfig(newStateFile, blockSize, maxChildren, providerVersion, startTime);
        this.fSht = new HistoryTree(conf);
    }

    public HistoryTreeBackend(@NonNull String ssid, File newStateFile, int providerVersion, long startTime) throws IOException {
        this(ssid, newStateFile, providerVersion, startTime, 65536, 50);
    }

    public HistoryTreeBackend(@NonNull String ssid, File existingStateFile, int providerVersion) throws IOException {
        this.fSsid = ssid;
        this.fSht = new HistoryTree(existingStateFile, providerVersion);
        this.fFinishedBuilding = true;
    }

    protected HistoryTree getSHT() {
        return this.fSht;
    }

    @Override
    public String getSSID() {
        return this.fSsid;
    }

    @Override
    public long getStartTime() {
        return this.fSht.getTreeStart();
    }

    @Override
    public long getEndTime() {
        return this.fSht.getTreeEnd();
    }

    @Override
    public void insertPastState(long stateStartTime, long stateEndTime, int quark, ITmfStateValue value) throws TimeRangeException {
        HTInterval interval = new HTInterval(stateStartTime, stateEndTime, quark, (TmfStateValue)value);
        this.fSht.insertInterval(interval);
    }

    @Override
    public void finishedBuilding(long endTime) {
        this.fSht.closeTree(endTime);
        this.fFinishedBuilding = true;
    }

    @Override
    public FileInputStream supplyAttributeTreeReader() {
        return this.fSht.supplyATReader();
    }

    @Override
    public File supplyAttributeTreeWriterFile() {
        return this.fSht.supplyATWriterFile();
    }

    @Override
    public long supplyAttributeTreeWriterFilePosition() {
        return this.fSht.supplyATWriterFilePos();
    }

    @Override
    public void removeFiles() {
        this.fSht.deleteFile();
    }

    @Override
    public void dispose() {
        if (this.fFinishedBuilding) {
            this.fSht.closeFile();
        } else {
            this.fSht.deleteFile();
        }
    }

    @Override
    public void doQuery(List<ITmfStateInterval> stateInfo, long t) throws TimeRangeException, StateSystemDisposedException {
        this.checkValidTime(t);
        HTNode currentNode = this.fSht.getRootNode();
        currentNode.writeInfoFromNode(stateInfo, t);
        try {
            while (currentNode.getNodeType() == HTNode.NodeType.CORE) {
                currentNode = this.fSht.selectNextChild((CoreNode)currentNode, t);
                currentNode.writeInfoFromNode(stateInfo, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
    }

    @Override
    public ITmfStateInterval doSingularQuery(long t, int attributeQuark) throws TimeRangeException, StateSystemDisposedException {
        return this.getRelevantInterval(t, attributeQuark);
    }

    private void checkValidTime(long t) {
        long startTime = this.getStartTime();
        long endTime = this.getEndTime();
        if (t < startTime || t > endTime) {
            throw new TimeRangeException(String.format("%s Time:%d, Start:%d, End:%d", this.fSsid, t, startTime, endTime));
        }
    }

    private HTInterval getRelevantInterval(long t, int key) throws TimeRangeException, StateSystemDisposedException {
        this.checkValidTime(t);
        HTNode currentNode = this.fSht.getRootNode();
        HTInterval interval = currentNode.getRelevantInterval(key, t);
        try {
            while (interval == null && currentNode.getNodeType() == HTNode.NodeType.CORE) {
                currentNode = this.fSht.selectNextChild((CoreNode)currentNode, t);
                interval = currentNode.getRelevantInterval(key, t);
            }
        }
        catch (ClosedChannelException e) {
            throw new StateSystemDisposedException(e);
        }
        return interval;
    }

    public long getFileSize() {
        return this.fSht.getFileSize();
    }

    public int getAverageNodeUsage() {
        long total = 0L;
        try {
            int seq = 0;
            while (seq < this.fSht.getNodeCount()) {
                HTNode node = this.fSht.readNode(seq);
                total += node.getNodeUsagePercent();
                ++seq;
            }
        }
        catch (ClosedChannelException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        long ret = total / (long)this.fSht.getNodeCount();
        if (ret < 0L || ret > 100L) {
            throw new IllegalStateException("Average node usage is not a percentage: " + ret);
        }
        return (int)ret;
    }

    @Override
    public void debugPrint(PrintWriter writer) {
        this.debugPrint(writer, false);
    }

    public void debugPrint(PrintWriter writer, boolean printIntervals) {
        writer.println("------------------------------");
        writer.println("State History Tree:\n");
        writer.println(this.fSht.toString());
        writer.println("Average node utilization: " + this.getAverageNodeUsage());
        writer.println("");
        this.fSht.debugPrintFullTree(writer, printIntervals);
    }
}

