/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlBasicTransition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlPatternEventHandler;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenario;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioHistoryBuilder;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlStateTransition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlTransitionValidator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TmfXmlFsm {
    private final Map<String, TmfXmlState> fStatesMap;
    private final List<TmfXmlScenario> fActiveScenariosList;
    private final List<TmfXmlBasicTransition> fPreconditions;
    private final String fId;
    private final ITmfXmlModelFactory fModelFactory;
    private final IXmlStateSystemContainer fContainer;
    private final String fFinalStateId;
    private final String fAbandonStateId;
    private final boolean fInstanceMultipleEnabled;
    private final String fInitialStateId;
    private int fTotalScenarios;

    public static TmfXmlFsm create(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container) {
        Element abandonElement;
        Element finalElement;
        NodeList nodesInitialState;
        String id = node.getAttribute("id");
        boolean instanceMultipleEnabled = node.getAttribute("multiple").isEmpty() ? true : Boolean.parseBoolean(node.getAttribute("multiple"));
        ArrayList<@NonNull TmfXmlBasicTransition> preconditions = new ArrayList<TmfXmlBasicTransition>();
        NodeList nodesPreconditions = node.getElementsByTagName("precondition");
        int i = 0;
        while (i < nodesPreconditions.getLength()) {
            preconditions.add(new TmfXmlBasicTransition((Element)NonNullUtils.checkNotNull((Object)nodesPreconditions.item(i))));
            ++i;
        }
        String initialState = node.getAttribute("initial");
        if (initialState.isEmpty() && (nodesInitialState = node.getElementsByTagName("initial")).getLength() == 1) {
            NodeList nodesTransition = ((Element)nodesInitialState.item(0)).getElementsByTagName("transition");
            if (nodesInitialState.getLength() != 1) {
                throw new IllegalArgumentException("initial state : there should be one and only one initial state.");
            }
            initialState = ((Element)nodesTransition.item(0)).getAttribute("target");
        }
        HashMap<@NonNull String, @NonNull TmfXmlState> statesMap = new HashMap<String, TmfXmlState>();
        NodeList nodesState = node.getElementsByTagName("state");
        int i2 = 0;
        while (i2 < nodesState.getLength()) {
            Element element = (Element)NonNullUtils.checkNotNull((Object)nodesState.item(i2));
            TmfXmlState state = modelFactory.createState(element, container, null);
            statesMap.put(state.getId(), state);
            if (initialState.isEmpty()) {
                initialState = state.getId();
            }
            ++i2;
        }
        if (initialState.isEmpty()) {
            throw new IllegalStateException("No initial state has been declared in fsm " + id);
        }
        String finalStateId = "";
        NodeList nodesFinalState = node.getElementsByTagName("final");
        if (nodesFinalState.getLength() == 1 && !(finalStateId = (finalElement = (Element)NonNullUtils.checkNotNull((Object)((Element)nodesFinalState.item(0)))).getAttribute("id")).isEmpty()) {
            TmfXmlState finalState = modelFactory.createState(finalElement, container, null);
            statesMap.put(finalState.getId(), finalState);
        }
        String abandonStateId = "";
        NodeList nodesAbandonState = node.getElementsByTagName("abandonState");
        if (nodesAbandonState.getLength() == 1 && !(abandonStateId = (abandonElement = (Element)NonNullUtils.checkNotNull((Object)((Element)nodesAbandonState.item(0)))).getAttribute("id")).isEmpty()) {
            TmfXmlState abandonState = modelFactory.createState(abandonElement, container, null);
            statesMap.put(abandonState.getId(), abandonState);
        }
        return new TmfXmlFsm(modelFactory, container, id, instanceMultipleEnabled, initialState, finalStateId, abandonStateId, preconditions, statesMap);
    }

    private TmfXmlFsm(ITmfXmlModelFactory modelFactory, IXmlStateSystemContainer container, String id, boolean multiple, String initialState, String finalState, String abandonState, List<TmfXmlBasicTransition> preconditions, Map<String, TmfXmlState> states) {
        this.fModelFactory = modelFactory;
        this.fTotalScenarios = 0;
        this.fContainer = container;
        this.fId = id;
        this.fInstanceMultipleEnabled = multiple;
        this.fInitialStateId = initialState;
        this.fFinalStateId = finalState;
        this.fAbandonStateId = abandonState;
        this.fPreconditions = ImmutableList.copyOf(preconditions);
        this.fStatesMap = ImmutableMap.copyOf(states);
        this.fActiveScenariosList = new ArrayList<TmfXmlScenario>();
    }

    public String getId() {
        return this.fId;
    }

    public String getInitialStateId() {
        return this.fInitialStateId;
    }

    public String getFinalStateId() {
        return this.fFinalStateId;
    }

    public String getAbandonStateId() {
        return this.fAbandonStateId;
    }

    public Map<String, TmfXmlState> getStatesMap() {
        return Collections.unmodifiableMap(this.fStatesMap);
    }

    public @Nullable TmfXmlStateTransition next(ITmfEvent event, Map<String, TmfXmlTransitionValidator> tests, TmfXmlScenarioInfo scenarioInfo) {
        boolean matched = false;
        TmfXmlStateTransition stateTransition = null;
        TmfXmlState state = this.fStatesMap.get(scenarioInfo.getActiveState());
        if (state == null) {
            Activator.logError(NLS.bind((String)Messages.TmfXmlFsm_StateUndefined, (Object)scenarioInfo.getActiveState(), (Object)this.getId()));
            return null;
        }
        int i = 0;
        while (i < state.getTransitionList().size() && !matched) {
            stateTransition = state.getTransitionList().get(i);
            matched = stateTransition.test(event, scenarioInfo, tests);
            ++i;
        }
        return matched ? stateTransition : null;
    }

    private boolean validatePreconditions(ITmfEvent event, Map<String, TmfXmlTransitionValidator> tests) {
        if (this.fPreconditions.isEmpty()) {
            return true;
        }
        for (TmfXmlBasicTransition precondition : this.fPreconditions) {
            if (!precondition.test(event, null, tests)) continue;
            return true;
        }
        return false;
    }

    public void handleEvent(ITmfEvent event, Map<String, TmfXmlTransitionValidator> transitionMap) {
        if (!this.validatePreconditions(event, transitionMap)) {
            return;
        }
        Iterator<TmfXmlScenario> currentItr = this.fActiveScenariosList.iterator();
        while (currentItr.hasNext()) {
            TmfXmlScenario scenario = currentItr.next();
            if (!scenario.isActive()) {
                currentItr.remove();
                continue;
            }
            TmfXmlFsm.handleScenario(scenario, event);
        }
    }

    public void dispose() {
        for (TmfXmlScenario scenario : this.fActiveScenariosList) {
            if (!scenario.isActive()) continue;
            scenario.cancel();
        }
    }

    private static void handleScenario(TmfXmlScenario scenario, ITmfEvent event) {
        if (scenario.isActive()) {
            scenario.handleEvent(event);
        }
    }

    public synchronized void createScenario(@Nullable ITmfEvent event, TmfXmlPatternEventHandler eventHandler, boolean force) {
        if (force || this.isNewScenarioAllowed()) {
            TmfXmlScenario scenario = new TmfXmlScenario(event, eventHandler, this.fId, this.fContainer, this.fModelFactory);
            ++this.fTotalScenarios;
            this.fActiveScenariosList.add(scenario);
        }
    }

    public synchronized boolean isNewScenarioAllowed() {
        return this.fTotalScenarios > 0 && !this.fActiveScenariosList.get(this.fActiveScenariosList.size() - 1).getScenarioInfos().getStatus().equals((Object)TmfXmlScenarioHistoryBuilder.ScenarioStatusType.PENDING) && this.fInstanceMultipleEnabled;
    }
}

