/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readwrite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlStateValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readwrite.TmfXmlReadWriteModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;

public class TmfXmlReadWriteStateValue
extends TmfXmlStateValue {
    private static final String ILLEGAL_STATE_EXCEPTION_MESSAGE = "The state system hasn't been initialized yet";

    public TmfXmlReadWriteStateValue(TmfXmlReadWriteModelFactory modelFactory, Element node, IXmlStateSystemContainer container, List<ITmfXmlStateAttribute> attributes) {
        this(modelFactory, node, container, attributes, null);
    }

    public TmfXmlReadWriteStateValue(TmfXmlReadWriteModelFactory modelFactory, Element node, IXmlStateSystemContainer container, String eventField) {
        this(modelFactory, node, container, new ArrayList<ITmfXmlStateAttribute>(), eventField);
    }

    private TmfXmlReadWriteStateValue(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container, List<ITmfXmlStateAttribute> attributes, @Nullable String eventField) {
        super(modelFactory, node, container, attributes, eventField);
    }

    protected @Nullable ITmfStateSystemBuilder getStateSystem() {
        return (ITmfStateSystemBuilder)super.getStateSystem();
    }

    @Override
    protected TmfXmlStateValue.TmfXmlStateValueBase initializeStateValue(ITmfXmlModelFactory modelFactory, Element node) {
        TmfXmlStateValueTypeReadWrite stateValueType = null;
        String type = node.getAttribute("type");
        String value = this.getSsContainer().getAttributeValue(node.getAttribute("value"));
        if (value == null) {
            throw new IllegalStateException();
        }
        switch (type) {
            case "int": {
                TmfStateValue stateValue = TmfStateValue.newValueInt((int)Integer.parseInt(value));
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue);
                break;
            }
            case "long": {
                TmfStateValue stateValue = TmfStateValue.newValueLong((long)Long.parseLong(value));
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue);
                break;
            }
            case "string": {
                TmfStateValue stateValue = TmfStateValue.newValueString((String)value);
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue);
                break;
            }
            case "null": {
                TmfStateValue stateValue = TmfStateValue.nullValue();
                stateValueType = new TmfXmlStateValueTmf((ITmfStateValue)stateValue);
                break;
            }
            case "eventField": {
                stateValueType = new TmfXmlStateValueEventField(value);
                break;
            }
            case "eventName": {
                stateValueType = new TmfXmlStateValueEventName();
                break;
            }
            case "delete": {
                stateValueType = new TmfXmlStateValueDelete();
                break;
            }
            case "query": {
                List<@Nullable Element> children = XmlUtils.getChildElements(node);
                ArrayList<ITmfXmlStateAttribute> childAttributes = new ArrayList<ITmfXmlStateAttribute>();
                for (Element child : children) {
                    if (child == null) continue;
                    ITmfXmlStateAttribute queryAttribute = modelFactory.createStateAttribute(child, this.getSsContainer());
                    childAttributes.add(queryAttribute);
                }
                stateValueType = new TmfXmlStateValueQuery(childAttributes);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("TmfXmlStateValue constructor: unexpected element %s for stateValue type", type));
            }
        }
        return stateValueType;
    }

    private static @Nullable ITmfStateValue incrementByType(int quark, ITmfStateSystem ss, ITmfStateValue stateValue) throws AttributeNotFoundException {
        TmfStateValue value = null;
        switch (stateValue.getType()) {
            case LONG: {
                long incrementLong = stateValue.unboxLong();
                ITmfStateValue currentState = ss.queryOngoingState(quark);
                long currentValue = currentState.isNull() ? 0L : currentState.unboxLong();
                value = TmfStateValue.newValueLong((long)(incrementLong + currentValue));
                return value;
            }
            case INTEGER: {
                int increment = stateValue.unboxInt();
                ITmfStateValue currentState = ss.queryOngoingState(quark);
                int currentValue = currentState.isNull() ? 0 : currentState.unboxInt();
                value = TmfStateValue.newValueInt((int)(increment + currentValue));
                return value;
            }
        }
        return value;
    }

    private class TmfXmlStateValueDelete
    extends TmfXmlStateValueTypeReadWrite {
        private TmfXmlStateValueDelete() {
        }

        @Override
        public @NonNull ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
            return TmfStateValue.nullValue();
        }

        @Override
        protected void processValue(int quark, long timestamp, ITmfStateValue value) throws TimeRangeException, AttributeNotFoundException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (!(ss instanceof ITmfStateSystemBuilder)) {
                throw new IllegalStateException("incrementValue should never be called when not building the state system");
            }
            ITmfStateSystemBuilder builder = ss;
            builder.removeAttribute(timestamp, quark);
        }

        public String toString() {
            return "Delete";
        }
    }

    private class TmfXmlStateValueEventField
    extends TmfXmlStateValueTypeReadWrite {
        private final String fFieldName;

        public TmfXmlStateValueEventField(String field) {
            this.fFieldName = field;
        }

        @Override
        public ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
            if (event == null) {
                Activator.logWarning("XML State value: requested an event field, but event is null");
                return TmfStateValue.nullValue();
            }
            return TmfXmlReadWriteStateValue.this.getEventFieldValue(event, this.fFieldName);
        }

        @Override
        public void incrementValue(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            ITmfStateSystem ss = TmfXmlReadWriteStateValue.this.getSsContainer().getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            ITmfStateValue incrementValue = this.getValue(event, scenarioInfo);
            ITmfStateValue value = TmfXmlReadWriteStateValue.incrementByType(quark, ss, incrementValue);
            if (value != null) {
                this.processValue(quark, timestamp, value);
            } else {
                Activator.logWarning(String.format("TmfXmlStateValue: The event field increment %s is not a number type but a %s", this.fFieldName, incrementValue.getType()));
            }
        }

        public String toString() {
            return "Event Field=" + this.fFieldName;
        }
    }

    private class TmfXmlStateValueEventName
    extends TmfXmlStateValueTypeReadWrite {
        private TmfXmlStateValueEventName() {
        }

        @Override
        public @NonNull ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
            if (event == null) {
                Activator.logWarning("XML State value: request event name, but event is null");
                return TmfStateValue.nullValue();
            }
            return TmfStateValue.newValueString((String)event.getName());
        }

        public String toString() {
            return "Event name";
        }
    }

    private class TmfXmlStateValueQuery
    extends TmfXmlStateValueTypeReadWrite {
        private final List<ITmfXmlStateAttribute> fQueryValue;

        public TmfXmlStateValueQuery(List<ITmfXmlStateAttribute> childAttributes) {
            this.fQueryValue = childAttributes;
        }

        @Override
        public ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
            TmfStateValue value = TmfStateValue.nullValue();
            int quarkQuery = -1;
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            for (ITmfXmlStateAttribute attribute : this.fQueryValue) {
                quarkQuery = attribute.getAttributeQuark(event, quarkQuery, scenarioInfo);
                if (quarkQuery == -1) break;
            }
            if (quarkQuery != -1) {
                value = ss.queryOngoingState(quarkQuery);
            }
            return value;
        }

        @Override
        public void incrementValue(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            ITmfStateValue incrementValue = this.getValue(event, scenarioInfo);
            ITmfStateValue value = TmfXmlReadWriteStateValue.incrementByType(quark, (ITmfStateSystem)ss, incrementValue);
            if (value != null) {
                this.processValue(quark, timestamp, value);
            } else {
                Activator.logWarning("TmfXmlStateValue: The query result increment is not a number type");
            }
        }

        public String toString() {
            return "Query=" + this.fQueryValue;
        }
    }

    private class TmfXmlStateValueTmf
    extends TmfXmlStateValueTypeReadWrite {
        private final ITmfStateValue fValue;

        public TmfXmlStateValueTmf(ITmfStateValue value) {
            this.fValue = value;
        }

        @Override
        public ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) {
            return this.fValue;
        }

        @Override
        public void incrementValue(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            ITmfStateValue value = TmfXmlReadWriteStateValue.incrementByType(quark, (ITmfStateSystem)ss, this.fValue);
            if (value != null) {
                this.processValue(quark, timestamp, value);
            } else {
                Activator.logWarning("TmfXmlStateValue: The increment value is not a number type");
            }
        }

        public String toString() {
            return "Value=" + this.fValue;
        }
    }

    protected abstract class TmfXmlStateValueTypeReadWrite
    extends TmfXmlStateValue.TmfXmlStateValueBase {
        protected TmfXmlStateValueTypeReadWrite() {
        }

        @Override
        public final void handleEvent(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            if (TmfXmlReadWriteStateValue.this.isIncrement()) {
                this.incrementValue(event, quark, timestamp, scenarioInfo);
            } else {
                ITmfStateValue value = this.getValue(event, scenarioInfo);
                this.processValue(quark, timestamp, value);
            }
        }

        @Override
        protected void processValue(int quark, long timestamp, ITmfStateValue value) throws AttributeNotFoundException, TimeRangeException, StateValueTypeException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            switch (TmfXmlReadWriteStateValue.this.getStackType()) {
                case POP: {
                    ss.popAttribute(timestamp, quark);
                    break;
                }
                case PUSH: {
                    ss.pushAttribute(timestamp, value, quark);
                    break;
                }
                default: {
                    ss.modifyAttribute(timestamp, value, quark);
                }
            }
        }

        @Override
        protected void incrementValue(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            ITmfStateSystemBuilder ss = TmfXmlReadWriteStateValue.this.getStateSystem();
            if (ss == null) {
                throw new IllegalStateException(TmfXmlReadWriteStateValue.ILLEGAL_STATE_EXCEPTION_MESSAGE);
            }
            StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)ss, (long)timestamp, (int)quark, (int)1);
        }
    }
}

