/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.module;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.module.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.module.TmfXmlLatencyViewOutput;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.module.TmfXmlViewOutput;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.core.analysis.ITmfNewAnalysisModuleListener;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TmfXmlAnalysisOutputSource
implements ITmfNewAnalysisModuleListener {
    public static final @NonNull String DATA_SEPARATOR = ";;;";

    public void moduleCreated(IAnalysisModule module) {
        Map files = XmlUtils.listFiles();
        for (File xmlFile : files.values()) {
            if (!XmlUtils.xmlValidate((File)xmlFile).isOK()) continue;
            try {
                Enum viewType;
                int n;
                int n2;
                Enum[] enumArray;
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(xmlFile);
                doc.getDocumentElement().normalize();
                if (module instanceof ITmfAnalysisModuleWithStateSystems) {
                    enumArray = ViewType.values();
                    n2 = enumArray.length;
                    n = 0;
                    while (n < n2) {
                        viewType = enumArray[n];
                        NodeList ssViewNodes = doc.getElementsByTagName(((ViewType)viewType).getXmlElem());
                        int i = 0;
                        while (i < ssViewNodes.getLength()) {
                            Element node = (Element)ssViewNodes.item(i);
                            List headNodes = XmlUtils.getChildElements((Element)node, (String)"head");
                            if (headNodes.size() == 1) {
                                List analysisNodes = XmlUtils.getChildElements((Element)((Element)headNodes.get(0)), (String)"analysis");
                                for (Element analysis : analysisNodes) {
                                    String analysisId = analysis.getAttribute("id");
                                    if (!analysisId.equals(module.getId())) continue;
                                    String viewId = ((ViewType)viewType).getViewId();
                                    TmfXmlViewOutput output = new TmfXmlViewOutput(viewId, (ViewType)viewType);
                                    output.setOutputProperty("xmlOutputData", String.valueOf(node.getAttribute("id")) + DATA_SEPARATOR + xmlFile.getAbsolutePath(), false);
                                    module.registerOutput((IAnalysisOutput)output);
                                }
                            }
                            ++i;
                        }
                        ++n;
                    }
                }
                if (!(module instanceof XmlPatternAnalysis)) continue;
                enumArray = LatencyViewType.values();
                n2 = enumArray.length;
                n = 0;
                while (n < n2) {
                    viewType = enumArray[n];
                    TmfXmlLatencyViewOutput output = new TmfXmlLatencyViewOutput(((LatencyViewType)viewType).getViewId(), ((LatencyViewType)viewType).getLabel());
                    output.setOutputProperty("xmlLatencyOutputData", String.valueOf(module.getId()) + DATA_SEPARATOR + ((LatencyViewType)viewType).getLabel(), false);
                    module.registerOutput((IAnalysisOutput)output);
                    ++n;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                Activator.logError("Error opening XML file", e);
            }
        }
    }

    public static enum LatencyViewType {
        LATENCY_TABLE("org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latencytable", Messages.TmfXmlAnalysisOutputSource_LatencyTable),
        SCATTER_GRAPH("org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.scattergraph", Messages.TmfXmlAnalysisOutputSource_ScatterGraphTitle),
        DENSITY_VIEW("org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.density", Messages.TmfXmlAnalysisOutputSource_DensityChartTitle),
        STATISTIC_VIEW("org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.statistics", Messages.TmfXmlAnalysisOutputSource_LatencyStatisticsTitle);

        private @NonNull String fLatencyViewId;
        private String fLatencyViewLabel;

        private LatencyViewType(String viewId, String label) {
            this.fLatencyViewId = viewId;
            this.fLatencyViewLabel = label;
        }

        public String getViewId() {
            return this.fLatencyViewId;
        }

        public String getLabel() {
            return this.fLatencyViewLabel;
        }
    }

    public static enum ViewType {
        TIME_GRAPH_VIEW("timeGraphView", "org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph"),
        XY_VIEW("xyView", "org.eclipse.linuxtools.internal.tmf.analysis.xml.ui.views.xyview");

        private final @NonNull String fXmlElem;
        private final String fViewId;

        private ViewType(String xmlElem, String viewId) {
            this.fXmlElem = xmlElem;
            this.fViewId = viewId;
        }

        public @NonNull String getXmlElem() {
            return this.fXmlElem;
        }

        private String getViewId() {
            return this.fViewId;
        }
    }
}

