/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisParameterProvider;

public final class TmfAnalysisParameterProviders {
    public static final String TMF_ANALYSIS_TYPE_ID = "org.eclipse.linuxtools.tmf.core.analysis";
    public static final String PARAMETER_PROVIDER_ELEM = "parameterProvider";
    public static final String CLASS_ATTR = "class";
    public static final String ID_ATTR = "id";
    public static final String ANALYSIS_ID_ELEM = "analysisId";
    private static final Map<String, IAnalysisParameterProvider> fParamProviderInstances = new HashMap<String, IAnalysisParameterProvider>();

    private TmfAnalysisParameterProviders() {
    }

    public static Set<IAnalysisParameterProvider> getParameterProvidersFor(String analysisId) {
        IConfigurationElement[] config;
        HashSet<IAnalysisParameterProvider> providers = new HashSet<IAnalysisParameterProvider>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_ANALYSIS_TYPE_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            if (elementName.equals(PARAMETER_PROVIDER_ELEM)) {
                try {
                    IConfigurationElement[] children = ce.getChildren(ANALYSIS_ID_ELEM);
                    if (children.length == 0) {
                        throw new IllegalStateException();
                    }
                    String id = children[0].getAttribute(ID_ATTR);
                    String className = ce.getAttribute(CLASS_ATTR);
                    if (id != null && className != null && analysisId.equals(id)) {
                        IAnalysisParameterProvider provider = fParamProviderInstances.get(className);
                        if (provider != null) {
                            providers.add(provider);
                        } else {
                            provider = (IAnalysisParameterProvider)NonNullUtils.checkNotNull((Object)((IAnalysisParameterProvider)ce.createExecutableExtension(CLASS_ATTR)));
                            fParamProviderInstances.put(className, provider);
                            providers.add(provider);
                        }
                    }
                }
                catch (CoreException | InvalidRegistryObjectException e) {
                    Activator.logError("Error creating module parameter provider", e);
                }
            }
            ++n2;
        }
        return providers;
    }
}

