/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfEvent
extends PlatformObject
implements ITmfEvent {
    private final ITmfTrace fTrace;
    private final long fRank;
    private final @NonNull ITmfTimestamp fTimestamp;
    private final ITmfEventType fType;
    private final ITmfEventField fContent;

    @Deprecated
    public TmfEvent() {
        this(null, -1L, null, null, null);
    }

    public TmfEvent(ITmfTrace trace, long rank, ITmfTimestamp timestamp, ITmfEventType type, ITmfEventField content) {
        this.fTrace = trace;
        this.fRank = rank;
        this.fTimestamp = timestamp != null ? timestamp : TmfTimestamp.ZERO;
        this.fType = type;
        this.fContent = content;
    }

    public TmfEvent(@NonNull ITmfEvent event) {
        this.fTrace = event.getTrace();
        this.fRank = event.getRank();
        this.fTimestamp = event.getTimestamp();
        this.fType = event.getType();
        this.fContent = event.getContent();
    }

    @Override
    public ITmfTrace getTrace() {
        ITmfTrace trace = this.fTrace;
        if (trace == null) {
            throw new IllegalStateException("Null traces are only allowed on special kind of events and getTrace() should not be called on them");
        }
        return trace;
    }

    @Override
    public long getRank() {
        return this.fRank;
    }

    @Override
    public ITmfTimestamp getTimestamp() {
        return this.fTimestamp;
    }

    @Override
    public ITmfEventType getType() {
        return this.fType;
    }

    @Override
    public ITmfEventField getContent() {
        return this.fContent;
    }

    @Override
    public String getName() {
        ITmfEventType type = this.getType();
        if (type != null) {
            return type.getName();
        }
        return "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fTrace == null ? 0 : this.getTrace().hashCode());
        result = 31 * result + (int)(this.getRank() ^ this.getRank() >>> 32);
        result = 31 * result + this.getTimestamp().hashCode();
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        result = 31 * result + (this.getContent() == null ? 0 : this.getContent().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        TmfEvent other = (TmfEvent)obj;
        if (this.fTrace == null ? other.fTrace != null : !this.getTrace().equals(other.getTrace())) {
            return false;
        }
        if (this.getRank() != other.getRank()) {
            return false;
        }
        if (!this.getTimestamp().equals(other.getTimestamp())) {
            return false;
        }
        if (!NonNullUtils.equalsNullable((Object)this.getType(), (Object)other.getType())) {
            return false;
        }
        return NonNullUtils.equalsNullable((Object)this.getContent(), (Object)other.getContent());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [fTimestamp=" + this.getTimestamp() + ", fTrace=" + this.getTrace() + ", fRank=" + this.getRank() + ", fType=" + this.getType() + ", fContent=" + this.getContent() + "]";
    }
}

