/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.filter.model;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAspectNode;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;

public class TmfFilterCompareNode
extends TmfFilterAspectNode {
    public static final String NODE_NAME = "COMPARE";
    public static final String NOT_ATTR = "not";
    public static final String RESULT_ATTR = "result";
    public static final String TYPE_ATTR = "type";
    public static final String VALUE_ATTR = "value";
    private boolean fNot = false;
    private int fResult;
    private Type fType = Type.NUM;
    private String fValue;
    private transient Number fValueNumber;
    private transient ITmfTimestamp fValueTimestamp;
    private transient TmfTimestampFormat fTimestampFormat = new TmfTimestampFormat("T.SSSSSSSSS");

    public TmfFilterCompareNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public boolean isNot() {
        return this.fNot;
    }

    public void setNot(boolean not) {
        this.fNot = not;
    }

    public int getResult() {
        return this.fResult;
    }

    public void setResult(int result) {
        this.fResult = (int)Math.signum(result);
    }

    public Type getType() {
        return this.fType;
    }

    public void setType(Type type) {
        this.fType = type;
        this.setValue(this.fValue);
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
        this.fValueNumber = null;
        this.fValueTimestamp = null;
        if (value == null) {
            return;
        }
        if (this.fType == Type.NUM) {
            this.fValueNumber = TmfFilterCompareNode.toNumber(value);
        } else if (this.fType == Type.TIMESTAMP) {
            this.fValueTimestamp = this.toTimestamp(value);
        }
    }

    public boolean hasValidValue() {
        if (this.fType == Type.NUM) {
            return this.fValueNumber != null;
        }
        if (this.fType == Type.TIMESTAMP) {
            return this.fValue != null && !this.fValue.isEmpty() && this.fValueTimestamp != null;
        }
        return this.fValue != null;
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        if (event == null || this.fEventAspect == null) {
            return false;
        }
        Object value = this.fEventAspect.resolve(event);
        if (value == null) {
            return false;
        }
        if (this.fType == Type.NUM) {
            if (this.fValueNumber instanceof Double) {
                Number valueNumber = TmfFilterCompareNode.toNumber(value);
                if (valueNumber != null) {
                    return Double.compare(valueNumber.doubleValue(), this.fValueNumber.doubleValue()) == this.fResult ^ this.fNot;
                }
            } else if (this.fValueNumber != null) {
                Number valueNumber = TmfFilterCompareNode.toNumber(value);
                if (valueNumber instanceof Double || valueNumber instanceof Float) {
                    return Double.compare(valueNumber.doubleValue(), this.fValueNumber.doubleValue()) == this.fResult ^ this.fNot;
                }
                if (valueNumber != null) {
                    return Long.compare(valueNumber.longValue(), this.fValueNumber.longValue()) == this.fResult ^ this.fNot;
                }
            }
        } else {
            ITmfTimestamp valueTimestamp;
            if (this.fType == Type.ALPHA) {
                String valueString = value.toString();
                int comp = (int)Math.signum(valueString.compareTo(this.fValue.toString()));
                return comp == this.fResult ^ this.fNot;
            }
            if (this.fType == Type.TIMESTAMP && this.fValueTimestamp != null && (valueTimestamp = this.toTimestamp(value)) != null) {
                int comp = (int)Math.signum(valueTimestamp.compareTo(this.fValueTimestamp));
                return comp == this.fResult ^ this.fNot;
            }
        }
        return false;
    }

    private static Number toNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        try {
            return Long.decode(value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return NumberFormat.getInstance().parse(value.toString());
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    private ITmfTimestamp toTimestamp(Object value) {
        if (value instanceof ITmfTimestamp) {
            return (ITmfTimestamp)value;
        }
        try {
            return TmfTimestamp.fromNanos(this.fTimestampFormat.parseValue(value.toString()));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public List<String> getValidChildren() {
        return new ArrayList<String>(0);
    }

    @Override
    public String toString(boolean explicit) {
        String open;
        String result;
        String string = this.fResult == 0 ? "= " : (result = this.fResult < 0 ? "< " : "> ");
        String string2 = this.fType == Type.NUM ? "" : (open = this.fType == Type.ALPHA ? "\"" : "[");
        String close = this.fType == Type.NUM ? "" : (this.fType == Type.ALPHA ? "\"" : "]");
        return String.valueOf(this.getAspectLabel(explicit)) + (this.fNot ? " not " : " ") + result + open + this.fValue + close;
    }

    @Override
    public ITmfFilterTreeNode clone() {
        TmfFilterCompareNode clone = (TmfFilterCompareNode)super.clone();
        clone.setValue(this.fValue);
        return clone;
    }

    public static enum Type {
        NUM,
        ALPHA,
        TIMESTAMP;

    }
}

