/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.IMarkerAxisListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphBaseControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public class TimeGraphMarkerAxis
extends TimeGraphBaseControl {
    private static final Image COLLAPSED = Activator.getDefault().getImageFromPath("icons/ovr16/collapsed_ovr.gif");
    private static final Image EXPANDED = Activator.getDefault().getImageFromPath("icons/ovr16/expanded_ovr.gif");
    private static final Image HIDE = Activator.getDefault().getImageFromPath("icons/etool16/hide.gif");
    private static final int HIDE_BORDER = 4;
    private static final int HEIGHT;
    private static final int TOP_MARGIN = 1;
    private static final int MAX_LABEL_LENGTH = 256;
    private static final int TEXT_MARGIN = 2;
    private static final int MAX_GAP = 5;
    private static final int X_LIMIT = 0x7FFFFF;
    private @NonNull ITimeDataProvider fTimeProvider;
    private final Set<IMarkerAxisListener> fListeners = new LinkedHashSet<IMarkerAxisListener>();
    private Multimap<String, IMarkerEvent> fMarkers = LinkedHashMultimap.create();
    private @NonNull List<String> fCategories = Collections.EMPTY_LIST;
    private boolean fCollapsed = false;

    static {
        GC gc = new GC((Drawable)Display.getDefault());
        HEIGHT = gc.getFontMetrics().getHeight() + 1;
        gc.dispose();
    }

    public TimeGraphMarkerAxis(Composite parent, @NonNull TimeGraphColorScheme colorScheme, @NonNull ITimeDataProvider timeProvider) {
        super(parent, colorScheme, 0x200C0000);
        this.fTimeProvider = timeProvider;
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Point size = TimeGraphMarkerAxis.this.getSize();
                Rectangle bounds = new Rectangle(0, 0, size.x, size.y);
                TimeGraphMarkerAxis.this.mouseDown(e, bounds, TimeGraphMarkerAxis.this.fTimeProvider.getNameSpace());
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height = 0;
        if (!this.fMarkers.isEmpty() && this.fTimeProvider.getTime0() != this.fTimeProvider.getTime1()) {
            height = this.fCollapsed ? TimeGraphMarkerAxis.COLLAPSED.getBounds().height : 1 + this.fMarkers.keySet().size() * HEIGHT;
        }
        return super.computeSize(wHint, height, changed);
    }

    public void addMarkerAxisListener(IMarkerAxisListener listener) {
        this.fListeners.add(listener);
    }

    public void removeMarkerAxisListener(IMarkerAxisListener listener) {
        this.fListeners.remove(listener);
    }

    public void setTimeProvider(@NonNull ITimeDataProvider timeProvider) {
        this.fTimeProvider = timeProvider;
    }

    public void setMarkerCategories(List<String> categories) {
        this.fCategories = categories == null ? Collections.EMPTY_LIST : categories;
    }

    public void mouseDown(MouseEvent e, Rectangle bounds, int nameSpace) {
        if (bounds.isEmpty()) {
            return;
        }
        if (this.fCollapsed || e.x < bounds.x + Math.min(nameSpace, TimeGraphMarkerAxis.EXPANDED.getBounds().width)) {
            this.fCollapsed = !this.fCollapsed;
            this.getParent().layout();
            this.redraw();
            return;
        }
        if (e.x < bounds.x + nameSpace) {
            String category = this.getHiddenCategoryForEvent(e, bounds);
            if (category != null) {
                for (IMarkerAxisListener listener : this.fListeners) {
                    listener.setMarkerCategoryVisible(category, false);
                }
            }
            return;
        }
        IMarkerEvent marker = this.getMarkerForEvent(e);
        if (marker != null) {
            this.fTimeProvider.setSelectionRangeNotify(marker.getTime(), marker.getTime() + marker.getDuration(), false);
        }
    }

    public void setMarkers(List<IMarkerEvent> markers) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        for (IMarkerEvent marker : markers) {
            map.put((Object)marker.getCategory(), (Object)marker);
        }
        Display.getDefault().asyncExec(() -> this.lambda$0((Multimap)map));
    }

    @Override
    void paint(Rectangle bounds, PaintEvent e) {
        this.drawMarkerAxis(bounds, this.fTimeProvider.getNameSpace(), e.gc);
    }

    protected void drawMarkerAxis(Rectangle bounds, int nameSpace, GC gc) {
        Rectangle rect;
        if (bounds.isEmpty()) {
            return;
        }
        gc.fillRectangle(bounds);
        if (!this.fCollapsed) {
            rect = new Rectangle(bounds.x, bounds.y + 1, bounds.width, HEIGHT);
            for (String category : this.getVisibleCategories()) {
                rect.x = bounds.x;
                rect.width = nameSpace;
                this.drawMarkerCategory(category, rect, gc);
                rect.x = nameSpace;
                rect.width = bounds.width - nameSpace;
                this.drawMarkerLabels(category, rect, gc);
                rect.y += HEIGHT;
            }
        }
        rect = new Rectangle(bounds.x, bounds.y, nameSpace, bounds.height);
        gc.setClipping(rect);
        this.drawToolbar(rect, nameSpace, gc);
    }

    protected void drawMarkerCategory(String category, Rectangle rect, GC gc) {
        if (rect.isEmpty()) {
            return;
        }
        gc.setForeground(gc.getDevice().getSystemColor(21));
        gc.setClipping(rect);
        int width = gc.textExtent((String)category).x + 2;
        int x = rect.x + TimeGraphMarkerAxis.EXPANDED.getBounds().width + TimeGraphMarkerAxis.HIDE.getBounds().width;
        gc.drawText(category, Math.max(x, rect.x + rect.width - width), rect.y, true);
    }

    protected void drawMarkerLabels(String category, Rectangle rect, GC gc) {
        long time1;
        if (rect.isEmpty()) {
            return;
        }
        long time0 = this.fTimeProvider.getTime0();
        if (time0 == (time1 = this.fTimeProvider.getTime1())) {
            return;
        }
        int timeSpace = this.fTimeProvider.getTimeSpace();
        double pixelsPerNanoSec = timeSpace <= 1 ? 0.0 : (double)(timeSpace - 1) / (double)(time1 - time0);
        gc.setClipping(rect);
        for (IMarkerEvent markerEvent : this.fMarkers.get((Object)category)) {
            Color color = this.getColorScheme().getColor(markerEvent.getColor());
            gc.setForeground(color);
            int x1 = TimeGraphMarkerAxis.getXForTime(rect, time0, pixelsPerNanoSec, markerEvent.getTime());
            if (x1 > rect.x + rect.width) {
                return;
            }
            if (markerEvent.getEntry() != null) continue;
            int x2 = TimeGraphMarkerAxis.getXForTime(rect, time0, pixelsPerNanoSec, markerEvent.getTime() + markerEvent.getDuration()) - 1;
            String label = TimeGraphMarkerAxis.getTrimmedLabel(markerEvent);
            if (label != null) {
                int gap;
                int width = gc.textExtent((String)label).x + 2;
                if (x1 < rect.x && x1 + width < x2 && (x1 = Math.min(rect.x + (gap = Math.min(rect.x - x1, 5)), x2 - width)) > rect.x) {
                    int y = rect.y + rect.height / 2;
                    gc.drawLine(rect.x, y, x1, y);
                }
                gc.fillRectangle(x1, rect.y, width, rect.height - 1);
                Utils.drawText(gc, label, x1 + 2, rect.y, true);
                gc.drawRectangle(x1, rect.y, width, rect.height - 1);
                if (x2 <= x1 + width) continue;
                int y = rect.y + rect.height / 2;
                gc.drawLine(x1 + width, y, x2, y);
                continue;
            }
            int y = rect.y + rect.height / 2;
            gc.drawLine(x1, y, x2, y);
        }
    }

    protected void drawToolbar(Rectangle bounds, int nameSpace, GC gc) {
        if (bounds.isEmpty()) {
            return;
        }
        if (this.fCollapsed) {
            gc.drawImage(COLLAPSED, bounds.x, bounds.y);
        } else {
            gc.drawImage(EXPANDED, bounds.x, bounds.y);
            int x = bounds.x + TimeGraphMarkerAxis.EXPANDED.getBounds().width;
            int i = 0;
            while (i < this.fMarkers.keySet().size()) {
                int y = bounds.y + 1 + i * HEIGHT;
                gc.drawImage(HIDE, x, y);
                ++i;
            }
        }
    }

    private static String getTrimmedLabel(IMarkerEvent marker) {
        String label = marker.getLabel();
        if (label == null) {
            return null;
        }
        return label.substring(0, Math.min(label.indexOf(10) != -1 ? label.indexOf(10) : label.length(), 256));
    }

    private static int getXForTime(Rectangle rect, long time0, double pixelsPerNanoSec, long time) {
        int x = rect.x + (int)Math.floor((double)(time - time0) * pixelsPerNanoSec);
        return Math.min(Math.max(x, -8388607), 0x7FFFFF);
    }

    private IMarkerEvent getMarkerForEvent(MouseEvent event) {
        long time1;
        long time0 = this.fTimeProvider.getTime0();
        if (time0 == (time1 = this.fTimeProvider.getTime1())) {
            return null;
        }
        int timeSpace = this.fTimeProvider.getTimeSpace();
        double pixelsPerNanoSec = timeSpace <= 1 ? 0.0 : (double)(timeSpace - 1) / (double)(time1 - time0);
        int categoryIndex = Math.max((event.y - 1) / HEIGHT, 0);
        String category = this.getVisibleCategories().get(categoryIndex);
        IMarkerEvent marker = null;
        GC gc = new GC((Drawable)Display.getDefault());
        Rectangle rect = this.getBounds();
        rect.x += this.fTimeProvider.getNameSpace();
        rect.width -= this.fTimeProvider.getNameSpace();
        for (IMarkerEvent markerEvent : this.fMarkers.get((Object)category)) {
            int width;
            String label = TimeGraphMarkerAxis.getTrimmedLabel(markerEvent);
            if (markerEvent.getEntry() != null) continue;
            int x1 = TimeGraphMarkerAxis.getXForTime(rect, time0, pixelsPerNanoSec, markerEvent.getTime());
            if (x1 > event.x) break;
            if (label != null && event.x <= x1 + (width = gc.textExtent((String)label).x + 2)) {
                marker = markerEvent;
                continue;
            }
            int x2 = TimeGraphMarkerAxis.getXForTime(rect, time0, pixelsPerNanoSec, markerEvent.getTime() + markerEvent.getDuration()) - 1;
            if (event.x > x2) continue;
            marker = markerEvent;
        }
        gc.dispose();
        return marker;
    }

    private String getHiddenCategoryForEvent(MouseEvent e, Rectangle bounds) {
        List<String> categories = this.getVisibleCategories();
        Rectangle rect = HIDE.getBounds();
        rect.x += bounds.x + TimeGraphMarkerAxis.EXPANDED.getBounds().width + 4;
        rect.y += bounds.y + 1 + 4;
        rect.width -= 8;
        rect.height -= 8;
        int i = 0;
        while (i < categories.size()) {
            if (rect.contains(e.x, e.y)) {
                return categories.get(i);
            }
            rect.y += HEIGHT;
            ++i;
        }
        return null;
    }

    private List<String> getVisibleCategories() {
        ArrayList<String> categories = new ArrayList<String>(this.fCategories);
        categories.retainAll(this.fMarkers.keySet());
        return categories;
    }

    private /* synthetic */ void lambda$0(Multimap multimap) {
        if (this.isDisposed()) {
            return;
        }
        this.fMarkers = multimap;
        this.getParent().layout();
        this.redraw();
    }
}

