/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net.proxy.win32.winhttp;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.proxy.win32.winhttp.ProxyBypass;
import org.eclipse.core.internal.net.proxy.win32.winhttp.ProxyProviderUtil;
import org.eclipse.core.net.proxy.IProxyData;

public class StaticProxyConfig {
    private static final String[] KNOWN_TYPES = new String[]{"HTTP", "HTTPS", "FTP", "GOPHER"};
    private List universalProxies = new ArrayList();
    private Map protocolSpecificProxies = new HashMap();
    private ProxyBypass proxyBypass;

    public StaticProxyConfig(String proxiesString, String proxyBypassString) {
        ProxyProviderUtil.fillProxyLists(proxiesString, this.universalProxies, this.protocolSpecificProxies);
        this.proxyBypass = new ProxyBypass(proxyBypassString);
    }

    public void select(URI uri, List proxies) {
        if (this.proxyBypass.bypassProxyFor(uri)) {
            return;
        }
        if (!this.protocolSpecificProxies.isEmpty()) {
            if (uri.getScheme() != null) {
                List protocolProxies = (List)this.protocolSpecificProxies.get(uri.getScheme().toUpperCase());
                if (protocolProxies == null) {
                    return;
                }
                proxies.addAll(protocolProxies);
            } else {
                for (List protocolProxies : this.protocolSpecificProxies.values()) {
                    if (protocolProxies == null) {
                        return;
                    }
                    proxies.addAll(protocolProxies);
                }
            }
        } else {
            IProxyData[] data = this.getUniversalProxiesData();
            if (uri.getScheme() != null) {
                int i = 0;
                while (i < data.length) {
                    if (uri.getScheme().equalsIgnoreCase(data[i].getType())) {
                        proxies.add(data[i]);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < data.length) {
                    proxies.add(data[i]);
                    ++i;
                }
            }
        }
    }

    public IProxyData[] getProxyData() {
        IProxyData[] data = this.getUniversalProxiesData();
        if (data.length > 0) {
            return data;
        }
        ArrayList proxies = new ArrayList();
        for (List protocolProxies : this.protocolSpecificProxies.values()) {
            if (protocolProxies == null) continue;
            proxies.addAll(protocolProxies);
        }
        return proxies.toArray(new IProxyData[0]);
    }

    private IProxyData[] getUniversalProxiesData() {
        if (this.universalProxies.size() == 0) {
            return new IProxyData[0];
        }
        IProxyData[] data = new IProxyData[KNOWN_TYPES.length];
        ProxyData universal = (ProxyData)this.universalProxies.get(0);
        int i = 0;
        while (i < KNOWN_TYPES.length) {
            ProxyData newData = new ProxyData(KNOWN_TYPES[i], universal.getHost(), universal.getPort(), universal.isRequiresAuthentication(), universal.getSource());
            newData.setUserid(universal.getUserId());
            newData.setPassword(universal.getPassword());
            data[i] = newData;
            ++i;
        }
        return data;
    }

    public String[] getNonProxiedHosts() {
        return this.proxyBypass.getNonProxiedHosts();
    }
}

