/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class OpenLocalFileAction
extends BaseSelectionListenerAction {
    protected OpenLocalFileAction(String text) {
        super(text);
    }

    public void run() {
        try {
            IStructuredSelection structSel = this.getStructuredSelection();
            Object[] objArray = structSel.toArray();
            int i = 0;
            while (i < objArray.length) {
                IFileState state = (IFileState)objArray[i];
                if (!state.exists()) {
                    MessageDialog.openError((Shell)TeamUIPlugin.getActivePage().getActivePart().getSite().getShell(), (String)TeamUIMessages.OpenRevisionAction_DeletedRevisionTitle, (String)TeamUIMessages.OpenRevisionAction_DeletedRevisionMessage);
                } else {
                    String id = this.getEditorID(state.getName(), state.getContents());
                    IWorkbenchPage page = TeamUIPlugin.getActivePage();
                    if (page != null) {
                        page.openEditor((IEditorInput)new FileRevisionEditorInput(state), id);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    String getEditorID(String fileName, InputStream contents) {
        IEditorDescriptor descriptor;
        IWorkbench workbench = TeamUIPlugin.getPlugin().getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        IContentType type = null;
        if (contents != null) {
            try {
                type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
            }
            catch (IOException iOException) {}
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        String id = (descriptor = registry.getDefaultEditor(fileName, type)) == null ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        return id;
    }
}

