/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics;

import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.SegmentStoreStatistics;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.statistics.Messages;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public abstract class AbstractSegmentStoreStatisticsViewer
extends AbstractTmfTreeViewer {
    private static final Format FORMATTER = new SubSecondTimeWithUnitFormat();
    private @Nullable TmfAbstractAnalysisModule fModule;
    private MenuManager fTablePopupMenuManager;
    private static final String[] COLUMN_NAMES = new String[]{(String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatistics_LevelLabel), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatistics_Statistics_MinLabel), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatistics_MaxLabel), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatistics_AverageLabel), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatisticsViewer_StandardDeviation), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatisticsViewer_Count), (String)NonNullUtils.checkNotNull((Object)Messages.SegmentStoreStatisticsViewer_Total)};

    public AbstractSegmentStoreStatisticsViewer(Composite parent) {
        super(parent, false);
        this.setLabelProvider((IBaseLabelProvider)new SegmentStoreStatisticsLabelProvider());
        this.fTablePopupMenuManager = new MenuManager();
        this.fTablePopupMenuManager.setRemoveAllWhenShown(true);
        this.fTablePopupMenuManager.addMenuListener(manager -> {
            TreeViewer viewer = this.getTreeViewer();
            ISelection selection = viewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (manager != null) {
                    this.appendToTablePopupMenu(manager, sel);
                }
            }
        });
        Menu tablePopup = this.fTablePopupMenuManager.createContextMenu((Control)this.getTreeViewer().getTree());
        this.getTreeViewer().getTree().setMenu(tablePopup);
    }

    protected abstract @Nullable TmfAbstractAnalysisModule createStatisticsAnalysiModule();

    public @Nullable TmfAbstractAnalysisModule getStatisticsAnalysisModule() {
        return this.fModule;
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return new ITmfTreeColumnDataProvider(){

            public List<@Nullable TmfTreeColumnData> getColumnData() {
                ArrayList<@Nullable TmfTreeColumnData> columns = new ArrayList<TmfTreeColumnData>();
                TmfTreeColumnData column = new TmfTreeColumnData(COLUMN_NAMES[0]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return n1.getName().compareTo(n2.getName());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[1]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Long.compare(n1.getEntry().getMin(), n2.getEntry().getMin());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[2]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Long.compare(n1.getEntry().getMax(), n2.getEntry().getMax());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[3]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Double.compare(n1.getEntry().getAverage(), n2.getEntry().getAverage());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[4]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Double.compare(n1.getEntry().getStdDev(), n2.getEntry().getStdDev());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[5]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Long.compare(n1.getEntry().getNbSegments(), n2.getEntry().getNbSegments());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[6]);
                column.setAlignment(131072);
                column.setComparator(new ViewerComparator(){

                    public int compare(@Nullable Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
                        if (e1 == null || e2 == null) {
                            return 0;
                        }
                        SegmentStoreStatisticsEntry n1 = (SegmentStoreStatisticsEntry)((Object)e1);
                        SegmentStoreStatisticsEntry n2 = (SegmentStoreStatisticsEntry)((Object)e2);
                        return Double.compare(n1.getEntry().getTotal(), n2.getEntry().getTotal());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData("");
                columns.add(column);
                return columns;
            }
        };
    }

    public void initializeDataSource() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            TmfAbstractAnalysisModule module = this.createStatisticsAnalysiModule();
            if (module == null) {
                return;
            }
            try {
                module.setTrace(trace);
                module.schedule();
                this.fModule = module;
            }
            catch (TmfAnalysisException e) {
                Activator.getDefault().logError("Error initializing statistics analysis module", e);
            }
        }
    }

    protected void appendToTablePopupMenu(IMenuManager manager, IStructuredSelection sel) {
        Object element = sel.getFirstElement();
        if (element instanceof SegmentStoreStatisticsEntry && !(element instanceof HiddenTreeViewerEntry)) {
            final SegmentStoreStatisticsEntry segment = (SegmentStoreStatisticsEntry)((Object)element);
            Action gotoStartTime = new Action(Messages.SegmentStoreStatisticsViewer_GotoMinAction){

                public void run() {
                    long start = segment.getEntry().getMinSegment().getStart();
                    long end = segment.getEntry().getMinSegment().getEnd();
                    AbstractSegmentStoreStatisticsViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentStoreStatisticsViewer.this, TmfTimestamp.fromNanos((long)start), TmfTimestamp.fromNanos((long)end)));
                }
            };
            Action gotoEndTime = new Action(Messages.SegmentStoreStatisticsViewer_GotoMaxAction){

                public void run() {
                    long start = segment.getEntry().getMaxSegment().getStart();
                    long end = segment.getEntry().getMaxSegment().getEnd();
                    AbstractSegmentStoreStatisticsViewer.this.broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)AbstractSegmentStoreStatisticsViewer.this, TmfTimestamp.fromNanos((long)start), TmfTimestamp.fromNanos((long)end)));
                }
            };
            manager.add((IAction)gotoStartTime);
            manager.add((IAction)gotoEndTime);
        }
    }

    protected static String toFormattedString(double value) {
        String percentageString = String.format("%s", FORMATTER.format(value));
        return percentageString;
    }

    protected class HiddenTreeViewerEntry
    extends SegmentStoreStatisticsEntry {
        public HiddenTreeViewerEntry(String name) {
            super(name, new SegmentStoreStatistics());
        }
    }

    protected class SegmentStoreStatisticsEntry
    extends TmfTreeViewerEntry {
        private final SegmentStoreStatistics fEntry;

        public SegmentStoreStatisticsEntry(String name, SegmentStoreStatistics entry) {
            super(name);
            this.fEntry = entry;
        }

        public SegmentStoreStatistics getEntry() {
            return this.fEntry;
        }
    }

    protected static class SegmentStoreStatisticsLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        protected SegmentStoreStatisticsLabelProvider() {
        }

        public String getColumnText(@Nullable Object element, int columnIndex) {
            String value = "";
            if (element instanceof HiddenTreeViewerEntry) {
                if (columnIndex == 0) {
                    value = ((HiddenTreeViewerEntry)((Object)element)).getName();
                }
            } else if (element instanceof SegmentStoreStatisticsEntry) {
                SegmentStoreStatisticsEntry entry = (SegmentStoreStatisticsEntry)((Object)element);
                if (columnIndex == 0) {
                    return String.valueOf(entry.getName());
                }
                if (entry.getEntry().getNbSegments() > 0L) {
                    if (columnIndex == 1) {
                        value = AbstractSegmentStoreStatisticsViewer.toFormattedString(entry.getEntry().getMin());
                    } else if (columnIndex == 2) {
                        value = String.valueOf(AbstractSegmentStoreStatisticsViewer.toFormattedString(entry.getEntry().getMax()));
                    } else if (columnIndex == 3) {
                        value = String.valueOf(AbstractSegmentStoreStatisticsViewer.toFormattedString(entry.getEntry().getAverage()));
                    } else if (columnIndex == 4) {
                        value = String.valueOf(AbstractSegmentStoreStatisticsViewer.toFormattedString(entry.getEntry().getStdDev()));
                    } else if (columnIndex == 5) {
                        value = String.valueOf(entry.getEntry().getNbSegments());
                    } else if (columnIndex == 6) {
                        value = String.valueOf(AbstractSegmentStoreStatisticsViewer.toFormattedString(entry.getEntry().getTotal()));
                    }
                }
            }
            return (String)NonNullUtils.checkNotNull((Object)value);
        }
    }
}

