/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class UstMemoryStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 1;
    private static final Long MINUS_ONE = -1L;
    private static final Long ZERO = 0L;
    private static final String EMPTY_STRING = "";
    private static final int MALLOC_INDEX = 1;
    private static final int FREE_INDEX = 2;
    private static final int CALLOC_INDEX = 3;
    private static final int REALLOC_INDEX = 4;
    private static final int MEMALIGN_INDEX = 5;
    private static final int POSIX_MEMALIGN_INDEX = 6;
    private final Map<Long, Long> fMemory = new HashMap<Long, Long>();
    private final @NonNull ILttngUstEventLayout fLayout;
    private final @NonNull Map<String, Integer> fEventNames;

    public UstMemoryStateProvider(@NonNull LttngUstTrace trace) {
        super((ITmfTrace)trace, "Ust:Memory");
        this.fLayout = trace.getEventLayout();
        this.fEventNames = UstMemoryStateProvider.buildEventNames(this.fLayout);
    }

    private static @NonNull Map<String, Integer> buildEventNames(ILttngUstEventLayout layout) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)layout.eventLibcMalloc(), (Object)1);
        builder.put((Object)layout.eventLibcFree(), (Object)2);
        builder.put((Object)layout.eventLibcCalloc(), (Object)3);
        builder.put((Object)layout.eventLibcRealloc(), (Object)4);
        builder.put((Object)layout.eventLibcMemalign(), (Object)5);
        builder.put((Object)layout.eventLibcPosixMemalign(), (Object)6);
        return builder.build();
    }

    protected void eventHandle(ITmfEvent event) {
        String name = event.getName();
        Integer index = this.fEventNames.get(name);
        int intIndex = index == null ? -1 : index;
        switch (intIndex) {
            case 1: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long size = (Long)event.getContent().getField(new String[]{this.fLayout.fieldSize()}).getValue();
                this.setMem(event, ptr, size);
                break;
            }
            case 2: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                this.setMem(event, ptr, ZERO);
                break;
            }
            case 3: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long nmemb = (Long)event.getContent().getField(new String[]{this.fLayout.fieldNmemb()}).getValue();
                Long size = (Long)event.getContent().getField(new String[]{this.fLayout.fieldSize()}).getValue();
                this.setMem(event, ptr, size * nmemb);
                break;
            }
            case 4: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long newPtr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldInPtr()}).getValue();
                Long size = (Long)event.getContent().getField(new String[]{this.fLayout.fieldSize()}).getValue();
                this.setMem(event, ptr, ZERO);
                this.setMem(event, newPtr, size);
                break;
            }
            case 5: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long size = (Long)event.getContent().getField(new String[]{this.fLayout.fieldSize()}).getValue();
                this.setMem(event, ptr, size);
                break;
            }
            case 6: {
                Long ptr = (Long)event.getContent().getField(new String[]{this.fLayout.fieldOutPtr()}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long size = (Long)event.getContent().getField(new String[]{this.fLayout.fieldSize()}).getValue();
                this.setMem(event, ptr, size);
                break;
            }
        }
    }

    public ITmfStateProvider getNewInstance() {
        return new UstMemoryStateProvider(this.getTrace());
    }

    public LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public int getVersion() {
        return 1;
    }

    private Long getVtid(ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(new String[]{this.fLayout.contextVtid()});
        if (field == null) {
            return MINUS_ONE;
        }
        return (Long)field.getValue();
    }

    private String getProcname(ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(new String[]{this.fLayout.contextProcname()});
        if (field == null) {
            return EMPTY_STRING;
        }
        return (String)field.getValue();
    }

    private void setMem(ITmfEvent event, Long ptr, Long size) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        long ts = event.getTimestamp().toNanos();
        Long tid = this.getVtid(event);
        Long memoryDiff = size;
        if (ZERO.equals(size)) {
            Long memSize = this.fMemory.remove(ptr);
            if (memSize == null) {
                return;
            }
            memoryDiff = -memSize.longValue();
        } else {
            this.fMemory.put(ptr, size);
        }
        try {
            int tidQuark = ss.getQuarkAbsoluteAndAdd(new String[]{tid.toString()});
            int tidMemQuark = ss.getQuarkRelativeAndAdd(tidQuark, new String[]{"Memory"});
            ITmfStateValue prevMem = ss.queryOngoingState(tidMemQuark);
            if (prevMem.isNull()) {
                int procNameQuark = ss.getQuarkRelativeAndAdd(tidQuark, new String[]{"Procname"});
                String procName = this.getProcname(event);
                if (tid.equals(MINUS_ONE)) {
                    procName = "Others";
                }
                ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueString((String)procName), procNameQuark);
                prevMem = TmfStateValue.newValueLong((long)0L);
            }
            long prevMemValue = prevMem.unboxLong();
            ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueLong((long)(prevMemValue += memoryDiff.longValue())), tidMemQuark);
        }
        catch (StateValueTypeException | TimeRangeException e) {
            throw new IllegalStateException(e);
        }
    }
}

