/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlMapEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlPatternEventHandler;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioHistoryBuilder;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readwrite.TmfXmlReadWriteModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.ISegmentListener;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternSegmentStoreModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlPatternStateProvider
extends AbstractTmfStateProvider
implements IXmlStateSystemContainer {
    private final IPath fFilePath;
    private final @NonNull String fStateId;
    private final Map<String, String> fDefinedValues = new HashMap<String, String>();
    private final @NonNull Set<@NonNull TmfXmlLocation> fLocations;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull TmfXmlMapEntry>> fMappingGroups;
    private final @NonNull Map<@NonNull String, @NonNull String> fStoredFields = new HashMap<String, String>();
    private TmfXmlPatternEventHandler fHandler;
    private final ISegmentListener fListener;
    private final @NonNull TmfXmlScenarioHistoryBuilder fHistoryBuilder;

    public XmlPatternStateProvider(@NonNull ITmfTrace trace, @NonNull String stateid, @Nullable IPath file, ISegmentListener listener) {
        super(trace, stateid);
        this.fStateId = stateid;
        this.fFilePath = file;
        this.fListener = listener;
        this.fHistoryBuilder = new TmfXmlScenarioHistoryBuilder();
        String pathString = this.fFilePath.makeAbsolute().toOSString();
        Element doc = XmlUtils.getElementInFile(pathString, "pattern", this.fStateId);
        if (doc == null) {
            this.fLocations = new HashSet<TmfXmlLocation>();
            this.fMappingGroups = new HashMap<String, Set<TmfXmlMapEntry>>();
            Activator.logError("Failed to find a pattern in " + pathString);
            return;
        }
        NodeList storedFieldNodes = doc.getElementsByTagName("storedField");
        int i = 0;
        while (i < storedFieldNodes.getLength()) {
            Element element = (Element)storedFieldNodes.item(i);
            String key = element.getAttribute("alias");
            this.fStoredFields.put(element.getAttribute("id"), key.isEmpty() ? element.getAttribute("id") : key);
            ++i;
        }
        NodeList definedStateNodes = doc.getElementsByTagName("definedValue");
        int i2 = 0;
        while (i2 < definedStateNodes.getLength()) {
            Element element = (Element)definedStateNodes.item(i2);
            this.fDefinedValues.put(element.getAttribute("name"), element.getAttribute("value"));
            ++i2;
        }
        ITmfXmlModelFactory modelFactory = TmfXmlReadWriteModelFactory.getInstance();
        NodeList locationNodes = doc.getElementsByTagName("location");
        HashSet<@NonNull TmfXmlLocation> locations = new HashSet<TmfXmlLocation>();
        int i3 = 0;
        while (i3 < locationNodes.getLength()) {
            Element element = (Element)locationNodes.item(i3);
            if (element != null) {
                TmfXmlLocation location = modelFactory.createLocation(element, this);
                locations.add(location);
            }
            ++i3;
        }
        this.fLocations = Collections.unmodifiableSet(locations);
        @NonNull HashMap<@NonNull String, @NonNull HashSet<@NonNull E>> mapGroups = new HashMap();
        NodeList mapNodes = doc.getElementsByTagName("mappingGroup");
        int i4 = 0;
        while (i4 < mapNodes.getLength()) {
            Element map = (Element)mapNodes.item(i4);
            String id = map.getAttribute("id");
            HashSet<@NonNull TmfXmlMapEntry> entrySet = (HashSet<TmfXmlMapEntry>)mapGroups.get(id);
            if (entrySet == null) {
                entrySet = new HashSet<TmfXmlMapEntry>();
                mapGroups.put(id, entrySet);
            }
            NodeList entryNodes = map.getElementsByTagName("entry");
            int j = 0;
            while (j < entryNodes.getLength()) {
                Element entryElement = (Element)entryNodes.item(j);
                if (entryElement != null) {
                    TmfXmlMapEntry entry = modelFactory.createMapEntry(entryElement, this);
                    entrySet.add(entry);
                }
                ++j;
            }
            ++i4;
        }
        this.fMappingGroups = Collections.unmodifiableMap(mapGroups);
        NodeList nodes = doc.getElementsByTagName("patternHandler");
        this.fHandler = modelFactory.createPatternEventHandler((Element)NonNullUtils.checkNotNull((Object)((Element)nodes.item(0))), this);
    }

    @Override
    public String getAttributeValue(String name) {
        String attribute = name;
        if (attribute.startsWith("$")) {
            attribute = this.getDefinedValue(attribute.substring(1));
        }
        return attribute;
    }

    public String getDefinedValue(String constant) {
        return this.fDefinedValues.get(constant);
    }

    public @NonNull Map<@NonNull String, @NonNull String> getStoredFields() {
        return this.fStoredFields;
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new XmlPatternStateProvider(this.getTrace(), this.getStateId(), this.fFilePath, this.fListener);
    }

    public @NonNull String getStateId() {
        return this.fStateId;
    }

    @Override
    public ITmfStateSystem getStateSystem() {
        return this.getStateSystemBuilder();
    }

    @Override
    public @NonNull Iterable<@NonNull TmfXmlLocation> getLocations() {
        return this.fLocations;
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        this.fHandler.handleEvent(event);
    }

    public ISegmentListener getListener() {
        return this.fListener;
    }

    public void dispose() {
        this.waitForEmptyQueue();
        this.fListener.onNewSegment(XmlPatternSegmentStoreModule.END_SEGMENT);
        this.fHandler.dispose();
        super.dispose();
    }

    public @NonNull TmfXmlScenarioHistoryBuilder getHistoryBuilder() {
        return this.fHistoryBuilder;
    }

    public @Nullable Set<@NonNull TmfXmlMapEntry> getMappingGroup(@NonNull String id) {
        return this.fMappingGroups.get(id);
    }
}

