/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.synchronization;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.ITmfTimestampTransformInvertible;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;

public class TmfTimestampTransformLinearFast
implements ITmfTimestampTransformInvertible {
    private static final long serialVersionUID = 2398540405078949740L;
    private static final int INTEGER_BITS = 32;
    private static final int DECIMAL_BITS = 30;
    private static final HashFunction HASHER = Hashing.goodFastHash((int)32);
    private static final MathContext MC = MathContext.DECIMAL128;
    private final BigDecimal fAlpha;
    private final BigDecimal fBeta;
    private final long fAlphaLong;
    private final long fDeltaMax;
    private final int fDeltaBits;
    private final int fHashCode;
    private transient long fOffset;
    private transient long fRangeStart;
    private transient long fScaleMiss;
    private transient long fScaleHit;

    public TmfTimestampTransformLinearFast() {
        this(BigDecimal.ONE, BigDecimal.ZERO);
    }

    public TmfTimestampTransformLinearFast(double alpha, double beta) {
        this(BigDecimal.valueOf(alpha), BigDecimal.valueOf(beta));
    }

    public TmfTimestampTransformLinearFast(BigDecimal alpha, BigDecimal beta) {
        if (alpha.compareTo(BigDecimal.valueOf(1.0E-9)) < 0 || alpha.compareTo(BigDecimal.valueOf(1.0E9)) > 0) {
            throw new IllegalArgumentException("The slope alpha must in the range [1e-9, 1e9]");
        }
        this.fAlpha = alpha;
        this.fBeta = beta;
        int width = Long.numberOfLeadingZeros(this.fAlpha.longValue()) - 32;
        this.fDeltaBits = Math.max(Math.min(width, 30), 0);
        this.fDeltaMax = 1 << this.fDeltaBits;
        this.fAlphaLong = this.fAlpha.multiply(BigDecimal.valueOf(this.fDeltaMax), MC).longValue();
        this.rescale(0L);
        this.fScaleMiss = 0L;
        this.fScaleHit = 0L;
        this.fHashCode = HASHER.newHasher().putDouble(this.fAlpha.doubleValue()).putDouble(this.fBeta.doubleValue()).putLong(this.fAlphaLong).hash().asInt();
    }

    @Override
    public ITmfTimestamp transform(ITmfTimestamp timestamp) {
        return TmfTimestamp.create(this.transform(timestamp.getValue()), timestamp.getScale());
    }

    @Override
    public long transform(long timestamp) {
        long delta = timestamp - this.fRangeStart;
        if (delta >= this.fDeltaMax || delta < 0L) {
            this.rescale(timestamp);
            delta = Math.abs(timestamp - this.fRangeStart);
            ++this.fScaleMiss;
        } else {
            ++this.fScaleHit;
        }
        return (this.fAlphaLong * delta >> this.fDeltaBits) + this.fOffset;
    }

    private void rescale(long timestamp) {
        this.fRangeStart = timestamp - timestamp % this.fDeltaMax;
        this.fOffset = BigDecimal.valueOf(this.fRangeStart).multiply(this.fAlpha, MC).add(this.fBeta, MC).longValue();
    }

    @Override
    public ITmfTimestampTransform composeWith(ITmfTimestampTransform composeWith) {
        if (composeWith.equals(TmfTimestampTransform.IDENTITY)) {
            return this;
        }
        if (composeWith instanceof TmfTimestampTransformLinearFast) {
            TmfTimestampTransformLinearFast ttl = (TmfTimestampTransformLinearFast)composeWith;
            BigDecimal newAlpha = this.fAlpha.multiply(ttl.getAlpha(), MC);
            BigDecimal newBeta = this.fAlpha.multiply(ttl.getBeta(), MC).add(this.fBeta);
            return new TmfTimestampTransformLinearFast(newAlpha, newBeta);
        }
        return this;
    }

    @Override
    public ITmfTimestampTransform inverse() {
        return new TmfTimestampTransformLinearFast(BigDecimal.ONE.divide(this.fAlpha, MC), BigDecimal.valueOf(-1L).multiply(this.fBeta).divide(this.fAlpha, MC));
    }

    public long getCacheMisses() {
        return this.fScaleMiss;
    }

    public long getCacheHits() {
        return this.fScaleHit;
    }

    public void resetScaleStats() {
        this.fScaleMiss = 0L;
        this.fScaleHit = 0L;
    }

    public BigDecimal getAlpha() {
        return this.fAlpha;
    }

    public BigDecimal getBeta() {
        return this.fBeta;
    }

    public long getDeltaMax() {
        return this.fDeltaMax;
    }

    public String toString() {
        return String.format("%s [ slope = %s, offset = %s ]", this.getClass().getSimpleName(), this.fAlpha.toString(), this.fBeta.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TmfTimestampTransformLinearFast) {
            TmfTimestampTransformLinearFast other = (TmfTimestampTransformLinearFast)obj;
            return this.getAlpha().equals(other.getAlpha()) && this.getBeta().equals(other.getBeta());
        }
        return false;
    }

    public int hashCode() {
        return this.fHashCode;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.rescale(0L);
    }
}

