/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import java.util.regex.Matcher;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CustomTxtEvent
extends CustomEvent {
    public CustomTxtEvent(CustomTxtTraceDefinition definition) {
        super(definition);
    }

    public CustomTxtEvent(CustomTxtTraceDefinition definition, @NonNull TmfEvent other) {
        super(definition, other);
    }

    public CustomTxtEvent(CustomTxtTraceDefinition definition, ITmfTrace parentTrace, ITmfTimestamp timestamp, TmfEventType type) {
        super(definition, parentTrace, timestamp, type);
    }

    @Override
    public void setContent(ITmfEventField content) {
        super.setContent(content);
    }

    public void processGroups(CustomTxtTraceDefinition.InputLine input, Matcher matcher) {
        if (input.eventType != null) {
            this.fData.put(CustomTraceDefinition.Tag.EVENT_TYPE, input.eventType);
        }
        if (input.columns == null) {
            return;
        }
        int i = 0;
        while (i < input.columns.size()) {
            String value;
            CustomTxtTraceDefinition.InputData column = input.columns.get(i);
            if (i < matcher.groupCount() && matcher.group(i + 1) != null && (value = matcher.group(i + 1).trim()).length() != 0) {
                String timeStampInputFormat;
                String s;
                Object key;
                Object object = key = column.tag.equals((Object)CustomTraceDefinition.Tag.OTHER) ? column.name : column.tag;
                if (column.action == 0) {
                    this.fData.put(key, value);
                    if (key.equals((Object)CustomTraceDefinition.Tag.TIMESTAMP)) {
                        this.fData.put(CustomEvent.Key.TIMESTAMP_INPUT_FORMAT, column.format);
                    }
                } else if (column.action == 1) {
                    s = (String)this.fData.get(key);
                    if (s != null) {
                        this.fData.put(key, String.valueOf(s) + value);
                    } else {
                        this.fData.put(key, value);
                    }
                    if (key.equals((Object)CustomTraceDefinition.Tag.TIMESTAMP)) {
                        timeStampInputFormat = (String)this.fData.get((Object)CustomEvent.Key.TIMESTAMP_INPUT_FORMAT);
                        if (timeStampInputFormat != null) {
                            this.fData.put(CustomEvent.Key.TIMESTAMP_INPUT_FORMAT, String.valueOf(timeStampInputFormat) + column.format);
                        } else {
                            this.fData.put(CustomEvent.Key.TIMESTAMP_INPUT_FORMAT, column.format);
                        }
                    }
                } else if (column.action == 2) {
                    s = (String)this.fData.get(key);
                    if (s != null) {
                        this.fData.put(key, String.valueOf(s) + " | " + value);
                    } else {
                        this.fData.put(key, value);
                    }
                    if (key.equals((Object)CustomTraceDefinition.Tag.TIMESTAMP)) {
                        timeStampInputFormat = (String)this.fData.get((Object)CustomEvent.Key.TIMESTAMP_INPUT_FORMAT);
                        if (timeStampInputFormat != null) {
                            this.fData.put(CustomEvent.Key.TIMESTAMP_INPUT_FORMAT, String.valueOf(timeStampInputFormat) + " | " + column.format);
                        } else {
                            this.fData.put(CustomEvent.Key.TIMESTAMP_INPUT_FORMAT, column.format);
                        }
                    }
                }
            }
            ++i;
        }
    }
}

