/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipEntry;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.GzipFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TarEntry;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TarFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ZipFileSystemObject;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class FileSystemObjectImportStructureProvider
implements IImportStructureProvider {
    private IImportStructureProvider fImportProvider;
    private String fArchivePath;

    public FileSystemObjectImportStructureProvider(IImportStructureProvider importStructureProvider, String archivePath) {
        this.fImportProvider = importStructureProvider;
        this.fArchivePath = archivePath;
    }

    public List<IFileSystemObject> getChildren(Object element) {
        List children = this.fImportProvider.getChildren(((IFileSystemObject)element).getRawFileSystemObject());
        ArrayList<IFileSystemObject> adapted = new ArrayList<IFileSystemObject>(children.size());
        for (Object o : children) {
            adapted.add(this.getIFileSystemObject(o));
        }
        adapted.sort(new FileObjectPathComparator());
        return adapted;
    }

    public IFileSystemObject getIFileSystemObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof File) {
            return new FileFileSystemObject((File)o);
        }
        if (o instanceof TarEntry) {
            return new TarFileSystemObject((TarEntry)o, this.fArchivePath);
        }
        if (o instanceof ZipEntry) {
            return new ZipFileSystemObject((ZipEntry)o, this.fArchivePath);
        }
        if (o instanceof GzipEntry) {
            return new GzipFileSystemObject((GzipEntry)o, this.fArchivePath);
        }
        throw new IllegalArgumentException("Object type not handled");
    }

    public InputStream getContents(Object fileSystemObject) {
        return this.fImportProvider.getContents(((IFileSystemObject)fileSystemObject).getRawFileSystemObject());
    }

    public String getFullPath(Object element) {
        return this.fImportProvider.getFullPath(((IFileSystemObject)element).getRawFileSystemObject());
    }

    public String getLabel(Object element) {
        return this.fImportProvider.getLabel(((IFileSystemObject)element).getRawFileSystemObject());
    }

    public boolean isFolder(Object element) {
        return this.fImportProvider.isFolder(((IFileSystemObject)element).getRawFileSystemObject());
    }

    public void dispose() {
    }

    private final class FileObjectPathComparator
    implements Comparator<IFileSystemObject> {
        private FileObjectPathComparator() {
        }

        @Override
        public int compare(IFileSystemObject o1, IFileSystemObject o2) {
            if (o1.isDirectory() != o2.isDirectory()) {
                if (o1.isDirectory()) {
                    return 1;
                }
                return -1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

