/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;

public class TmfViewsElement
extends TmfProjectModelElement {
    public static final String PATH_ELEMENT = ".views";
    private static final String ELEMENT_NAME = Messages.TmfViewsElement_Name;

    protected TmfViewsElement(IResource resource, TmfCommonProjectElement parent) {
        super(ELEMENT_NAME, resource, parent);
    }

    @Override
    public TmfCommonProjectElement getParent() {
        return (TmfCommonProjectElement)super.getParent();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void refreshChildren() {
        HashMap<String, TmfAnalysisElement> childrenMap = new HashMap<String, TmfAnalysisElement>();
        for (TmfAnalysisElement analysis : this.getParent().getAvailableAnalysis()) {
            childrenMap.put(analysis.getAnalysisId(), analysis);
        }
        TraceTypeHelper helper = TmfTraceType.getTraceType((String)this.getParent().getTraceType());
        @NonNull Class traceClass = null;
        if (helper != null) {
            traceClass = helper.getTraceClass();
        }
        if (traceClass == null) {
            for (TmfAnalysisElement analysis : childrenMap.values()) {
                this.removeChild(analysis);
            }
            return;
        }
        IPath nodePath = this.getResource().getFullPath();
        for (IAnalysisModuleHelper module : TmfAnalysisManager.getAnalysisModules((Class)traceClass).values()) {
            TmfAnalysisElement analysis = (TmfAnalysisElement)childrenMap.remove(module.getId());
            if (analysis == null) {
                IFolder analysisRes = ResourcesPlugin.getWorkspace().getRoot().getFolder(nodePath.append(module.getId()));
                analysis = new TmfAnalysisElement(module.getName(), (IResource)analysisRes, this, module);
                this.addChild(analysis);
            }
            analysis.refreshChildren();
        }
        for (TmfAnalysisElement analysis : childrenMap.values()) {
            this.removeChild(analysis);
        }
    }

    @Override
    public Image getIcon() {
        return TmfProjectModelIcons.VIEWS_ICON;
    }
}

