/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.histogram;

import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampDelta;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramBucket;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramDataModel;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramScaledData;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramView;
import org.eclipse.tracecompass.tmf.ui.views.histogram.IHistogramModelListener;
import org.eclipse.tracecompass.tmf.ui.views.histogram.Messages;

public abstract class Histogram
implements ControlListener,
PaintListener,
KeyListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
IHistogramModelListener {
    private final Color fBackgroundColor = Display.getCurrent().getSystemColor(1);
    private final Color fSelectionForegroundColor = Display.getCurrent().getSystemColor(9);
    private final Color fSelectionBackgroundColor = Display.getCurrent().getSystemColor(22);
    private final Color[] fHistoBarColors = new Color[]{new Color((Device)Display.getDefault(), 90, 90, 255), new Color((Device)Display.getDefault(), 0, 240, 0), new Color((Device)Display.getDefault(), 255, 0, 0), new Color((Device)Display.getDefault(), 0, 255, 255), new Color((Device)Display.getDefault(), 255, 80, 255), new Color((Device)Display.getDefault(), 200, 200, 0), new Color((Device)Display.getDefault(), 200, 150, 0), new Color((Device)Display.getDefault(), 150, 255, 150), new Color((Device)Display.getDefault(), 200, 80, 80), new Color((Device)Display.getDefault(), 30, 150, 150), new Color((Device)Display.getDefault(), 200, 200, 255), new Color((Device)Display.getDefault(), 0, 120, 0), new Color((Device)Display.getDefault(), 255, 150, 150), new Color((Device)Display.getDefault(), 140, 80, 140), new Color((Device)Display.getDefault(), 150, 100, 50), new Color((Device)Display.getDefault(), 255, 80, 80), new Color((Device)Display.getDefault(), 200, 200, 200), new Color((Device)Display.getDefault(), 255, 200, 80), new Color((Device)Display.getDefault(), 255, 255, 80), new Color((Device)Display.getDefault(), 255, 200, 200), new Color((Device)Display.getDefault(), 255, 200, 255), new Color((Device)Display.getDefault(), 255, 255, 200), new Color((Device)Display.getDefault(), 200, 255, 255)};
    private final Color fTimeRangeColor = new Color((Device)Display.getCurrent(), 255, 128, 0);
    private final Color fLostEventColor = new Color((Device)Display.getCurrent(), 208, 62, 120);
    protected static final int DRAG_NONE = 0;
    protected static final int DRAG_SELECTION = 1;
    protected static final int DRAG_RANGE = 2;
    protected static final int DRAG_ZOOM = 3;
    protected TmfView fParentView;
    private Composite fComposite;
    private Font fFont;
    private Label fMaxNbEventsLabel;
    private Label fMinNbEventsLabel;
    private Label fTimeRangeStartLabel;
    private Label fTimeRangeEndLabel;
    protected Canvas fCanvas;
    private Composite canvasComposite;
    protected final HistogramDataModel fDataModel;
    protected HistogramScaledData fScaledData;
    protected long fCurrentEventTime = 0L;
    private long fSelectionBegin = 0L;
    private long fSelectionEnd = 0L;
    protected int fDragState = 0;
    protected int fDragButton = 0;
    private int fOffset = 0;
    static boolean showTraces = true;
    private boolean fSendTimeAlignSignals = false;
    protected final String IMAGE_KEY = "double-buffer-image";

    public Histogram(TmfView view, Composite parent) {
        this(view, parent, false);
    }

    public Histogram(TmfView view, Composite parent, boolean sendTimeAlignSignals) {
        this.fParentView = view;
        this.fSendTimeAlignSignals = sendTimeAlignSignals;
        this.fComposite = this.createWidget(parent);
        this.fDataModel = new HistogramDataModel();
        this.fDataModel.addHistogramListener(this);
        this.clear();
        this.fCanvas.addControlListener((ControlListener)this);
        this.fCanvas.addPaintListener((PaintListener)this);
        this.fCanvas.addKeyListener((KeyListener)this);
        this.fCanvas.addMouseListener((MouseListener)this);
        this.fCanvas.addMouseTrackListener((MouseTrackListener)this);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)this);
        TmfSignalManager.register((Object)this);
    }

    public void dispose() {
        TmfSignalManager.deregister((Object)this);
        this.fLostEventColor.dispose();
        Color[] colorArray = this.fHistoBarColors;
        int n = this.fHistoBarColors.length;
        int n2 = 0;
        while (n2 < n) {
            Color c = colorArray[n2];
            c.dispose();
            ++n2;
        }
        this.fTimeRangeColor.dispose();
        this.fFont.dispose();
        this.fDataModel.removeHistogramListener(this);
        this.fDataModel.dispose();
    }

    private Composite createWidget(Composite parent) {
        this.fFont = Histogram.adjustFont(parent);
        int initalWidth = 10;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        Composite composite = new Composite(parent, 4);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 128;
        this.fMaxNbEventsLabel = new Label(composite, 131072);
        this.fMaxNbEventsLabel.setFont(this.fFont);
        this.fMaxNbEventsLabel.setText("0");
        this.fMaxNbEventsLabel.setLayoutData((Object)gridData);
        this.canvasComposite = new Composite(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.heightHint = 0;
        gridData.widthHint = 0;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.canvasComposite.setLayoutData((Object)gridData);
        this.canvasComposite.setLayout((Layout)new FillLayout());
        this.fCanvas = new Canvas(this.canvasComposite, 0x20000000);
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Object image = Histogram.this.fCanvas.getData("double-buffer-image");
                if (image instanceof Image) {
                    ((Image)image).dispose();
                }
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 1024;
        this.fMinNbEventsLabel = new Label(composite, 131072);
        this.fMinNbEventsLabel.setFont(this.fFont);
        this.fMinNbEventsLabel.setText("0");
        this.fMinNbEventsLabel.setLayoutData((Object)gridData);
        gridData = new GridData(10, -1);
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 1024;
        Label dummyLabel = new Label(composite, 0);
        dummyLabel.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        gridData.verticalAlignment = 1024;
        this.fTimeRangeStartLabel = new Label(composite, 0);
        this.fTimeRangeStartLabel.setFont(this.fFont);
        this.fTimeRangeStartLabel.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 1024;
        this.fTimeRangeEndLabel = new Label(composite, 0);
        this.fTimeRangeEndLabel.setFont(this.fFont);
        this.fTimeRangeEndLabel.setLayoutData((Object)gridData);
        return composite;
    }

    private static Font adjustFont(Composite composite) {
        int fontSizeAdjustment = -2;
        Font font = composite.getFont();
        FontData fontData = font.getFontData()[0];
        return new Font(font.getDevice(), fontData.getName(), fontData.getHeight() + -2, fontData.getStyle());
    }

    public long getStartTime() {
        return this.fDataModel.getFirstBucketTime();
    }

    public long getEndTime() {
        return this.fDataModel.getEndTime();
    }

    public long getTimeLimit() {
        return this.fDataModel.getTimeLimit();
    }

    public HistogramDataModel getDataModel() {
        return this.fDataModel;
    }

    void setMaxNbEvents(long maxNbEvents) {
        this.fMaxNbEventsLabel.setText(Long.toString(maxNbEvents));
        this.fMaxNbEventsLabel.getParent().layout();
        this.fCanvas.redraw();
    }

    public boolean showTraces() {
        return showTraces && this.fDataModel.getNbTraces() < this.getMaxNbTraces();
    }

    public int getMaxNbTraces() {
        return this.fHistoBarColors.length;
    }

    public Color getTraceColor(int traceIndex) {
        return this.fHistoBarColors[traceIndex % this.fHistoBarColors.length];
    }

    public void updateTimeRange(long startTime, long endTime) {
        if (this.fDragState == 0) {
            ((HistogramView)this.fParentView).updateTimeRange(startTime, endTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.fDataModel.clear();
        if (this.fDragState == 1) {
            this.updateSelectionTime();
        }
        this.fDragState = 0;
        this.fDragButton = 0;
        HistogramDataModel histogramDataModel = this.fDataModel;
        synchronized (histogramDataModel) {
            this.fScaledData = null;
        }
    }

    public void setSelection(long beginTime, long endTime) {
        this.fSelectionBegin = beginTime > 0L ? beginTime : 0L;
        this.fSelectionEnd = endTime > 0L ? endTime : 0L;
        this.fDataModel.setSelectionNotifyListeners(beginTime, endTime);
    }

    public synchronized long getTimestamp(int offset) {
        HistogramScaledData scaledData = this.fScaledData;
        if (scaledData != null) {
            return scaledData.fFirstBucketTime + Math.round(scaledData.fBucketDuration * (double)offset);
        }
        return 0L;
    }

    public synchronized int getOffset(long timestamp) {
        if (timestamp < this.fDataModel.getFirstBucketTime() || timestamp > this.fDataModel.getEndTime()) {
            return -1;
        }
        return (int)((double)(timestamp - this.fDataModel.getFirstBucketTime()) / this.fScaledData.fBucketDuration);
    }

    protected void setOffset(int offset) {
        this.fOffset = offset;
    }

    protected void moveCursor(int keyCode) {
        switch (keyCode) {
            case 0x1000007: {
                this.fScaledData.fSelectionBeginBucket = 0;
                break;
            }
            case 0x1000008: {
                this.fScaledData.fSelectionBeginBucket = this.fScaledData.fWidth - 1;
                break;
            }
            case 0x1000004: {
                long prevStartTime = this.getTimestamp(this.fScaledData.fSelectionBeginBucket);
                int index = Math.max(0, Math.min(this.fScaledData.fWidth - 1, this.fScaledData.fSelectionBeginBucket + 1));
                while (index < this.fScaledData.fWidth && (this.fScaledData.fData[index].isEmpty() || prevStartTime == this.getTimestamp(index))) {
                    prevStartTime = this.getTimestamp(index);
                    ++index;
                }
                if (index >= this.fScaledData.fWidth) {
                    index = this.fScaledData.fWidth - 1;
                }
                this.fScaledData.fSelectionBeginBucket = index;
                break;
            }
            case 0x1000003: {
                long prevEndTime = this.getTimestamp(this.fScaledData.fSelectionBeginBucket + 1);
                int index = Math.max(0, Math.min(this.fScaledData.fWidth - 1, this.fScaledData.fSelectionBeginBucket - 1));
                while (index >= 0 && (this.fScaledData.fData[index].isEmpty() || prevEndTime == this.getTimestamp(index + 1))) {
                    prevEndTime = this.getTimestamp(index + 1);
                    --index;
                }
                if (index <= 0) {
                    index = 0;
                }
                this.fScaledData.fSelectionBeginBucket = index;
                break;
            }
            default: {
                return;
            }
        }
        this.fScaledData.fSelectionEndBucket = this.fScaledData.fSelectionBeginBucket;
        this.fSelectionEnd = this.fSelectionBegin = this.getTimestamp(this.fScaledData.fSelectionBeginBucket);
        this.updateSelectionTime();
    }

    @Override
    public void modelUpdated() {
        if (!this.fCanvas.isDisposed() && this.fCanvas.getDisplay() != null) {
            this.fCanvas.getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!Histogram.this.fCanvas.isDisposed()) {
                        int canvasWidth = Histogram.this.fCanvas.getBounds().width;
                        int canvasHeight = Histogram.this.fCanvas.getBounds().height;
                        if (canvasWidth <= 0 || canvasHeight <= 0) {
                            return;
                        }
                        Histogram.this.fDataModel.setSelection(Histogram.this.fSelectionBegin, Histogram.this.fSelectionEnd);
                        Histogram.this.fScaledData = Histogram.this.fDataModel.scaleTo(canvasWidth, canvasHeight, 1);
                        HistogramDataModel histogramDataModel = Histogram.this.fDataModel;
                        synchronized (histogramDataModel) {
                            if (Histogram.this.fScaledData != null) {
                                Histogram.this.fCanvas.redraw();
                                Histogram.this.updateRangeTextControls();
                                long maxNbEvents = HistogramScaledData.hideLostEvents ? Histogram.this.fScaledData.fMaxValue : Histogram.this.fScaledData.fMaxCombinedValue;
                                String old = Histogram.this.fMaxNbEventsLabel.getText();
                                Histogram.this.fMaxNbEventsLabel.setText(Long.toString(maxNbEvents));
                                GridData gd = (GridData)Histogram.this.fMaxNbEventsLabel.getLayoutData();
                                gd.widthHint = Math.max(gd.widthHint, ((Histogram)Histogram.this).fMaxNbEventsLabel.computeSize((int)-1, (int)-1).x);
                                Histogram.this.fMaxNbEventsLabel.getParent().layout();
                                if (old.length() < Histogram.this.fMaxNbEventsLabel.getText().length() && Histogram.this.fSendTimeAlignSignals && Histogram.this.fParentView instanceof ITmfTimeAligned) {
                                    TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal(this, ((ITmfTimeAligned)((Object)Histogram.this.fParentView)).getTimeViewAlignmentInfo(), true));
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.fCanvas.addMouseWheelListener(listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.fCanvas.removeMouseWheelListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.fCanvas.addKeyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.fCanvas.removeKeyListener(listener);
    }

    private void updateSelectionTime() {
        if (this.fSelectionBegin > this.fSelectionEnd) {
            long end = this.fSelectionBegin;
            this.fSelectionBegin = this.fSelectionEnd;
            this.fSelectionEnd = end;
        }
        ((HistogramView)this.fParentView).updateSelectionTime(this.fSelectionBegin, this.fSelectionEnd);
    }

    private void updateRangeTextControls() {
        if (this.fDataModel.getNbEvents() != 0L || this.fDataModel.getStartTime() < this.fDataModel.getEndTime()) {
            this.fTimeRangeStartLabel.setText(TmfTimestampFormat.getDefaulTimeFormat().format(this.fDataModel.getStartTime()));
            this.fTimeRangeEndLabel.setText(TmfTimestampFormat.getDefaulTimeFormat().format(this.fDataModel.getEndTime()));
        } else {
            this.fTimeRangeStartLabel.setText("");
            this.fTimeRangeEndLabel.setText("");
        }
    }

    public void paintControl(PaintEvent event) {
        int canvasWidth = this.fCanvas.getBounds().width;
        int canvasHeight = this.fCanvas.getBounds().height;
        if (canvasWidth <= 0 || canvasHeight <= 0) {
            return;
        }
        Image image = (Image)this.fCanvas.getData("double-buffer-image");
        if (image == null || image.getBounds().width != canvasWidth || image.getBounds().height != canvasHeight) {
            if (image != null) {
                image.dispose();
            }
            image = new Image((Device)event.display, canvasWidth, canvasHeight);
            this.fCanvas.setData("double-buffer-image", (Object)image);
        }
        GC imageGC = new GC((Drawable)image);
        this.formatImage(imageGC, image);
        event.gc.drawImage(image, 0, 0);
        imageGC.dispose();
    }

    private void formatImage(GC imageGC, Image image) {
        if (this.fScaledData == null) {
            return;
        }
        HistogramScaledData scaledData = new HistogramScaledData(this.fScaledData);
        try {
            int endBucket;
            int height = image.getBounds().height;
            imageGC.setBackground(this.fBackgroundColor);
            imageGC.fillRectangle(0, 0, image.getBounds().width + 1, image.getBounds().height + 1);
            int limit = scaledData.fWidth;
            double factor = HistogramScaledData.hideLostEvents ? scaledData.fScalingFactor : scaledData.fScalingFactorCombined;
            boolean showTracesColors = this.showTraces();
            int i = 0;
            while (i < limit) {
                HistogramBucket hb = scaledData.fData[i];
                int totalNbEvents = hb.getNbEvents();
                int value = (int)Math.ceil((double)totalNbEvents * factor);
                int x = i + this.fOffset;
                if (!HistogramScaledData.hideLostEvents) {
                    imageGC.setForeground(this.fLostEventColor);
                    int lostEventValue = (int)Math.ceil((double)scaledData.fLostEventsData[i] * factor);
                    if (lostEventValue != 0) {
                        imageGC.drawLine(x, height - value - lostEventValue, x, height - value);
                    }
                }
                if (!hb.isEmpty()) {
                    if (showTracesColors) {
                        int traceIndex = 0;
                        while (traceIndex < hb.getNbTraces()) {
                            int nbEventsForTrace = hb.getNbEvent(traceIndex);
                            if (nbEventsForTrace > 0) {
                                Color c = this.fHistoBarColors[traceIndex % this.fHistoBarColors.length];
                                imageGC.setForeground(c);
                                imageGC.drawLine(x, height - value, x, height);
                                value = (int)Math.ceil((double)(totalNbEvents -= nbEventsForTrace) * scaledData.fScalingFactor);
                            }
                            ++traceIndex;
                        }
                    } else {
                        Color c = this.fHistoBarColors[0];
                        imageGC.setForeground(c);
                        imageGC.drawLine(x, height - value, x, height);
                    }
                }
                ++i;
            }
            int alpha = imageGC.getAlpha();
            imageGC.setAlpha(100);
            imageGC.setForeground(this.fSelectionForegroundColor);
            imageGC.setBackground(this.fSelectionBackgroundColor);
            int beginBucket = scaledData.fSelectionBeginBucket + this.fOffset;
            if (beginBucket >= 0 && beginBucket < limit) {
                imageGC.drawLine(beginBucket, 0, beginBucket, height);
            }
            if ((endBucket = scaledData.fSelectionEndBucket + this.fOffset) >= 0 && endBucket < limit && endBucket != beginBucket) {
                imageGC.drawLine(endBucket, 0, endBucket, height);
            }
            if (Math.abs(endBucket - beginBucket) > 1) {
                if (endBucket > beginBucket) {
                    imageGC.fillRectangle(beginBucket + 1, 0, endBucket - beginBucket - 1, height);
                } else {
                    imageGC.fillRectangle(endBucket + 1, 0, beginBucket - endBucket - 1, height);
                }
            }
            imageGC.setAlpha(alpha);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void drawTimeRangeWindow(GC imageGC, long rangeStartTime, long rangeDuration) {
        if (this.fScaledData == null) {
            return;
        }
        double bucketSpan = this.fScaledData.fBucketDuration;
        long startTime = Math.min(rangeStartTime, rangeStartTime + rangeDuration);
        double rangeWidth = (double)Math.abs(rangeDuration) / bucketSpan;
        int left = (int)((double)(startTime - this.fDataModel.getFirstBucketTime()) / bucketSpan);
        int right = (int)((double)left + rangeWidth);
        int center = (left + right) / 2;
        int height = this.fCanvas.getSize().y;
        int arc = Math.min(15, (int)rangeWidth);
        imageGC.setForeground(this.fTimeRangeColor);
        imageGC.setLineWidth(1);
        imageGC.setLineStyle(1);
        imageGC.drawRoundRectangle(left, 0, (int)rangeWidth, height - 1, arc, arc);
        imageGC.setBackground(this.fTimeRangeColor);
        imageGC.setAlpha(35);
        imageGC.fillRoundRectangle(left + 1, 1, (int)rangeWidth - 1, height - 2, arc, arc);
        imageGC.setAlpha(255);
        imageGC.setForeground(this.fTimeRangeColor);
        imageGC.setLineWidth(1);
        imageGC.setLineStyle(1);
        int chHalfWidth = (rangeWidth < 60.0 ? (int)(rangeWidth * 2.0 / 3.0) : 40) / 2;
        imageGC.drawLine(center - chHalfWidth, height / 2, center + chHalfWidth, height / 2);
        imageGC.drawLine(center, height / 2 - chHalfWidth, center, height / 2 + chHalfWidth);
    }

    public int getPointAreaOffset() {
        Point absCanvas = this.fCanvas.toDisplay(0, 0);
        Point viewPoint = this.fComposite.getParent().toDisplay(0, 0);
        return absCanvas.x - viewPoint.x;
    }

    public int getPointAreaWidth() {
        if (!this.fCanvas.isDisposed()) {
            return this.fComposite.getBounds().width;
        }
        return 0;
    }

    public void keyPressed(KeyEvent event) {
        this.moveCursor(event.keyCode);
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        if (this.fScaledData != null && event.button == 1 && this.fDragState == 0 && (this.fDataModel.getNbEvents() != 0L || this.fDataModel.getStartTime() < this.fDataModel.getEndTime())) {
            this.fDragState = 1;
            this.fDragButton = event.button;
            if ((event.stateMask & SWT.MODIFIER_MASK) == 131072) {
                if (Math.abs(event.x - this.fScaledData.fSelectionBeginBucket) < Math.abs(event.x - this.fScaledData.fSelectionEndBucket)) {
                    this.fScaledData.fSelectionBeginBucket = this.fScaledData.fSelectionEndBucket;
                    this.fSelectionBegin = this.fSelectionEnd;
                }
                this.fSelectionEnd = this.getTimestamp(event.x);
                this.fScaledData.fSelectionEndBucket = event.x;
            } else {
                this.fSelectionBegin = Math.min(this.getTimestamp(event.x), this.getEndTime());
                this.fScaledData.fSelectionBeginBucket = event.x;
                this.fSelectionEnd = this.fSelectionBegin;
                this.fScaledData.fSelectionEndBucket = this.fScaledData.fSelectionBeginBucket;
            }
            this.fCanvas.redraw();
        }
    }

    public void mouseUp(MouseEvent event) {
        if (this.fDragState == 1 && event.button == this.fDragButton) {
            this.fDragState = 0;
            this.fDragButton = 0;
            this.updateSelectionTime();
        }
    }

    public void mouseMove(MouseEvent event) {
        if (this.fDragState == 1 && (this.fDataModel.getNbEvents() != 0L || this.fDataModel.getStartTime() < this.fDataModel.getEndTime())) {
            this.fSelectionEnd = Math.max(this.getStartTime(), Math.min(this.getEndTime(), this.getTimestamp(event.x)));
            this.fScaledData.fSelectionEndBucket = Math.max(0, Math.min(this.fScaledData.fWidth - 1, event.x));
            this.fCanvas.redraw();
        }
    }

    public void mouseEnter(MouseEvent event) {
    }

    public void mouseExit(MouseEvent event) {
    }

    public void mouseHover(MouseEvent event) {
        if ((this.fDataModel.getNbEvents() != 0L || this.fDataModel.getStartTime() < this.fDataModel.getEndTime()) && this.fScaledData != null && event.x >= 0 && event.x - this.fOffset < this.fScaledData.fWidth) {
            String tooltip = this.formatToolTipLabel(event.x - this.fOffset);
            this.fCanvas.setToolTipText(tooltip);
            return;
        }
        this.fCanvas.setToolTipText(null);
    }

    private String formatToolTipLabel(int index) {
        long startTime = this.fScaledData.getBucketStartTime(index);
        if (startTime < 0L) {
            startTime = 0L;
        }
        long endTime = this.fScaledData.getBucketEndTime(index);
        int nbEvents = index >= 0 ? this.fScaledData.fData[index].getNbEvents() : 0;
        String newLine = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        int selectionBeginBucket = Math.min(this.fScaledData.fSelectionBeginBucket, this.fScaledData.fSelectionEndBucket);
        int selectionEndBucket = Math.max(this.fScaledData.fSelectionBeginBucket, this.fScaledData.fSelectionEndBucket);
        if (selectionBeginBucket <= index && index <= selectionEndBucket && this.fSelectionBegin != this.fSelectionEnd) {
            TmfTimestampDelta delta = new TmfTimestampDelta(Math.abs(this.fSelectionEnd - this.fSelectionBegin), -9);
            buffer.append(NLS.bind((String)Messages.Histogram_selectionSpanToolTip, (Object)delta.toString()));
            buffer.append(newLine);
        }
        buffer.append(NLS.bind((String)Messages.Histogram_bucketRangeToolTip, (Object)TmfTimestamp.fromNanos((long)startTime).toString(), (Object)TmfTimestamp.fromNanos((long)endTime).toString()));
        buffer.append(newLine);
        buffer.append(NLS.bind((String)Messages.Histogram_eventCountToolTip, (Object)nbEvents));
        if (!HistogramScaledData.hideLostEvents) {
            int nbLostEvents = index >= 0 ? this.fScaledData.fLostEventsData[index] : 0;
            buffer.append(newLine);
            buffer.append(NLS.bind((String)Messages.Histogram_lostEventCountToolTip, (Object)nbLostEvents));
        }
        return buffer.toString();
    }

    public void controlMoved(ControlEvent event) {
        this.fDataModel.complete();
    }

    public void controlResized(ControlEvent event) {
        this.fDataModel.complete();
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        this.updateRangeTextControls();
        this.fComposite.layout();
    }
}

