/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ILinkEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public abstract class AbstractStateSystemTimeGraphView
extends AbstractTimeGraphView {
    private static final long MAX_INTERVALS = 1000000L;
    private final Map<ITmfStateSystem, List<@NonNull TimeGraphEntry>> fSSEntryListMap = new HashMap<ITmfStateSystem, List<TimeGraphEntry>>();
    private final Multimap<ITmfTrace, ITmfStateSystem> fTraceSSMap = HashMultimap.create();
    private static final Logger LOGGER = TraceCompassLog.getLogger(AbstractStateSystemTimeGraphView.class);

    public AbstractStateSystemTimeGraphView(String id, TimeGraphPresentationProvider pres) {
        super(id, pres);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<@NonNull TimeGraphEntry> getEntryList(ITmfStateSystem ss) {
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            return this.fSSEntryListMap.get(ss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putEntryList(ITmfTrace trace, ITmfStateSystem ss, List<@NonNull TimeGraphEntry> list) {
        super.putEntryList(trace, list);
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            this.fSSEntryListMap.put(ss, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            this.fTraceSSMap.put((Object)trace, (Object)ss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToEntryList(ITmfTrace trace, ITmfStateSystem ss, List<@NonNull TimeGraphEntry> list) {
        super.addToEntryList(trace, list);
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            List<@NonNull TimeGraphEntry> entryList = this.fSSEntryListMap.get(ss);
            if (entryList == null) {
                this.fSSEntryListMap.put(ss, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            } else {
                entryList.addAll(list);
            }
            this.fTraceSSMap.put((Object)trace, (Object)ss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromEntryList(ITmfTrace trace, ITmfStateSystem ss, List<TimeGraphEntry> list) {
        super.removeFromEntryList(trace, list);
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fSSEntryListMap.get(ss);
            if (entryList != null) {
                entryList.removeAll(list);
                if (entryList.isEmpty()) {
                    this.fTraceSSMap.remove((Object)trace, (Object)ss);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected @Nullable AbstractTimeGraphView.ZoomThread createZoomThread(long startTime, long endTime, long resolution, boolean restart) {
        ArrayList<ITmfStateSystem> ssList = null;
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            ssList = new ArrayList<ITmfStateSystem>(this.fTraceSSMap.get((Object)this.getTrace()));
        }
        if (ssList.isEmpty()) {
            return null;
        }
        return new ZoomThreadByTime(ssList, startTime, endTime, resolution, restart);
    }

    protected void queryFullStates(ITmfStateSystem ss, long start, long end, long resolution, @NonNull IProgressMonitor monitor, @NonNull IQueryHandler handler) {
        ArrayList<List<ITmfStateInterval>> fullStates = new ArrayList<List<ITmfStateInterval>>();
        List prevFullState = null;
        try {
            long time = start;
            while (!monitor.isCanceled()) {
                List fullState = ss.queryFullState(time);
                fullStates.add(fullState);
                if ((long)(fullStates.size() * fullState.size()) > 1000000L) {
                    handler.handle(fullStates, prevFullState);
                    prevFullState = (List)fullStates.get(fullStates.size() - 1);
                    fullStates.clear();
                }
                if (time >= end) break;
                time = Math.min(end, time + resolution);
            }
            if (fullStates.size() > 0) {
                handler.handle(fullStates, prevFullState);
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
    }

    protected abstract @Nullable List<ITimeEvent> getEventList(@NonNull TimeGraphEntry var1, ITmfStateSystem var2, @NonNull List<List<ITmfStateInterval>> var3, @Nullable List<ITmfStateInterval> var4, @NonNull IProgressMonitor var5);

    protected @NonNull List<ILinkEvent> getLinkList(ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        return new ArrayList<ILinkEvent>();
    }

    protected @NonNull List<IMarkerEvent> getViewMarkerList(ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
        return new ArrayList<IMarkerEvent>();
    }

    @Override
    @Deprecated
    protected final List<TimeGraphEntry> getEntryList(ITmfTrace trace) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    protected final void addToEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    protected final void putEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    protected final void removeFromEntryList(ITmfTrace trace, List<TimeGraphEntry> list) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    protected final List<ITimeEvent> getEventList(TimeGraphEntry entry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    protected final List<ILinkEvent> getLinkList(long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    protected final List<IMarkerEvent> getViewMarkerList(long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resetView(ITmfTrace viewTrace) {
        super.resetView(viewTrace);
        Map<ITmfStateSystem, List<TimeGraphEntry>> map = this.fSSEntryListMap;
        synchronized (map) {
            for (ITmfStateSystem ss : this.fTraceSSMap.removeAll((Object)viewTrace)) {
                this.fSSEntryListMap.remove(ss);
            }
        }
    }

    public static interface IQueryHandler {
        public void handle(@NonNull List<List<ITmfStateInterval>> var1, @Nullable List<ITmfStateInterval> var2);
    }

    private class ZoomThreadByTime
    extends AbstractTimeGraphView.ZoomThread {
        private final @NonNull List<ITmfStateSystem> fZoomSSList;
        private boolean fClearZoomedLists;

        public ZoomThreadByTime(List<ITmfStateSystem> ssList, long startTime, long endTime, long resolution, boolean restart) {
            super(AbstractStateSystemTimeGraphView.this, startTime, endTime, resolution);
            this.fZoomSSList = ssList;
            this.fClearZoomedLists = !restart;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            ArrayList<ILinkEvent> links = new ArrayList<ILinkEvent>();
            ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
            if (this.fClearZoomedLists) {
                this.clearZoomedLists();
            }
            for (ITmfStateSystem ss : this.fZoomSSList) {
                List entryList = null;
                Map map = AbstractStateSystemTimeGraphView.this.fSSEntryListMap;
                synchronized (map) {
                    entryList = (List)AbstractStateSystemTimeGraphView.this.fSSEntryListMap.get(ss);
                }
                if (entryList == null) continue;
                this.zoomByTime(ss, entryList, links, markers, this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
            }
            if (!this.getMonitor().isCanceled()) {
                markers.addAll(AbstractStateSystemTimeGraphView.this.getTraceMarkerList(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor()));
                this.applyResults(() -> {
                    AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setLinks(links);
                    AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setMarkerCategories(AbstractStateSystemTimeGraphView.this.getMarkerCategories());
                    AbstractStateSystemTimeGraphView.this.getTimeGraphViewer().setMarkers(markers);
                });
            } else {
                LOGGER.info(() -> "[TimeGraphView:ZoomThreadCanceled]");
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            if (this.fClearZoomedLists) {
                this.clearZoomedLists();
            }
        }

        private void zoomByTime(final ITmfStateSystem ss, final List<TimeGraphEntry> entryList, final List<ILinkEvent> links, final List<IMarkerEvent> markers, long startTime, long endTime, long resolution, final @NonNull IProgressMonitor monitor) {
            boolean fullRange;
            long start = Math.max(startTime, ss.getStartTime());
            long end = Math.min(endTime, ss.getCurrentEndTime());
            boolean bl = fullRange = this.getZoomStartTime() <= AbstractStateSystemTimeGraphView.this.getStartTime() && this.getZoomEndTime() >= AbstractStateSystemTimeGraphView.this.getEndTime();
            if (end < start) {
                return;
            }
            if (fullRange) {
                AbstractStateSystemTimeGraphView.this.redraw();
            }
            AbstractStateSystemTimeGraphView.this.queryFullStates(ss, start, end, resolution, monitor, new IQueryHandler(){

                @Override
                public void handle(@NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState) {
                    LOGGER.config(() -> "[TimeGraphView:ZoomThreadGettingStates]");
                    if (!fullRange) {
                        for (TimeGraphEntry entry : entryList) {
                            ZoomThreadByTime.this.zoom((TimeGraphEntry)NonNullUtils.checkNotNull((Object)entry), ss, fullStates, prevFullState, monitor);
                        }
                    }
                    LOGGER.config(() -> "[TimeGraphView:ZoomThreadGettingLinks]");
                    links.addAll(AbstractStateSystemTimeGraphView.this.getLinkList(ss, fullStates, prevFullState, monitor));
                    LOGGER.config(() -> "[TimeGraphView:ZoomThreadGettingMarkers]");
                    markers.addAll(AbstractStateSystemTimeGraphView.this.getViewMarkerList(ss, fullStates, prevFullState, monitor));
                    LOGGER.config(() -> "[TimeGraphView:ZoomThreadDone]");
                }
            });
            AbstractStateSystemTimeGraphView.this.refresh();
        }

        private void zoom(@NonNull TimeGraphEntry entry, ITmfStateSystem ss, @NonNull List<List<ITmfStateInterval>> fullStates, @Nullable List<ITmfStateInterval> prevFullState, @NonNull IProgressMonitor monitor) {
            List<ITimeEvent> eventList = AbstractStateSystemTimeGraphView.this.getEventList(entry, ss, fullStates, prevFullState, monitor);
            if (eventList != null) {
                this.applyResults(() -> {
                    for (ITimeEvent event : eventList) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        entry.addZoomedEvent(event);
                    }
                });
            }
            for (TimeGraphEntry child : entry.getChildren()) {
                if (monitor.isCanceled()) {
                    LOGGER.info(() -> "[TimeGraphView:ZoomThreadCanceled]");
                    return;
                }
                this.zoom(child, ss, fullStates, prevFullState, monitor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearZoomedLists() {
            for (ITmfStateSystem ss : this.fZoomSSList) {
                List entryList = null;
                Map map = AbstractStateSystemTimeGraphView.this.fSSEntryListMap;
                synchronized (map) {
                    entryList = (List)AbstractStateSystemTimeGraphView.this.fSSEntryListMap.get(ss);
                }
                if (entryList == null) continue;
                for (TimeGraphEntry entry : entryList) {
                    this.clearZoomedList(entry);
                }
            }
            this.fClearZoomedLists = false;
        }

        private void clearZoomedList(TimeGraphEntry entry) {
            entry.setZoomedEventList(null);
            for (TimeGraphEntry child : entry.getChildren()) {
                this.clearZoomedList(child);
            }
        }
    }
}

