/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfViewsElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public class TmfExperimentElement
extends TmfCommonProjectElement
implements IPropertySource2 {
    private static final String INFO_CATEGORY = "Info";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String LOCATION = "location";
    private static final String FOLDER_SUFFIX = "_exp";
    private static final String EXPERIMENT_TYPE = "type";
    private static final String EXPERIMENT_TYPE_ID = "type ID";
    private static final ReadOnlyTextPropertyDescriptor NAME_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor("name", "name");
    private static final ReadOnlyTextPropertyDescriptor PATH_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor("path", "path");
    private static final ReadOnlyTextPropertyDescriptor LOCATION_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor("location", "location");
    private static final ReadOnlyTextPropertyDescriptor TYPE_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor("type", "type");
    private static final ReadOnlyTextPropertyDescriptor TYPE_ID_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor("type ID", "type ID");
    private static final IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[]{NAME_DESCRIPTOR, PATH_DESCRIPTOR, LOCATION_DESCRIPTOR, TYPE_DESCRIPTOR, TYPE_ID_DESCRIPTOR};
    private static final Map<String, IConfigurationElement> TRACE_TYPE_ATTRIBUTES;
    private static final Map<String, IConfigurationElement> TRACE_TYPE_UI_ATTRIBUTES;
    private static final Map<String, IConfigurationElement> TRACE_CATEGORIES;

    static {
        NAME_DESCRIPTOR.setCategory(INFO_CATEGORY);
        PATH_DESCRIPTOR.setCategory(INFO_CATEGORY);
        LOCATION_DESCRIPTOR.setCategory(INFO_CATEGORY);
        TYPE_DESCRIPTOR.setCategory(INFO_CATEGORY);
        TYPE_ID_DESCRIPTOR.setCategory(INFO_CATEGORY);
        TRACE_TYPE_ATTRIBUTES = new HashMap<String, IConfigurationElement>();
        TRACE_TYPE_UI_ATTRIBUTES = new HashMap<String, IConfigurationElement>();
        TRACE_CATEGORIES = new HashMap<String, IConfigurationElement>();
    }

    public static void init() {
        IConfigurationElement ce;
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.core.tracetype");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            if (elementName.equals("experiment")) {
                String traceTypeId = ce.getAttribute("id");
                TRACE_TYPE_ATTRIBUTES.put(traceTypeId, ce);
            } else if (elementName.equals("category")) {
                String categoryId = ce.getAttribute("id");
                TRACE_CATEGORIES.put(categoryId, ce);
            }
            ++n2;
        }
        iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.ui.tracetypeui");
        n = config.length;
        n2 = 0;
        while (n2 < n) {
            ce = iConfigurationElementArray[n2];
            String elemName = ce.getName();
            if ("experiment".equals(elemName)) {
                String traceType = ce.getAttribute("tracetype");
                TRACE_TYPE_UI_ATTRIBUTES.put(traceType, ce);
            }
            ++n2;
        }
    }

    public TmfExperimentElement(String name, IFolder folder, TmfExperimentFolder parent) {
        super(name, (IResource)folder, parent);
    }

    public IFolder getResource() {
        return (IFolder)super.getResource();
    }

    @Override
    protected void refreshChildren() {
        IFolder folder = this.getResource();
        HashMap<String, TmfTraceElement> childrenMap = new HashMap<String, TmfTraceElement>();
        for (TmfTraceElement trace : this.getTraces()) {
            childrenMap.put(trace.getElementPath(), trace);
        }
        List<IResource> members = this.getTraceResources();
        for (IResource resource : members) {
            String name = resource.getName();
            String elementPath = resource.getFullPath().makeRelativeTo(folder.getFullPath()).toString();
            ITmfProjectModelElement element = (ITmfProjectModelElement)childrenMap.get(elementPath);
            if (element instanceof TmfTraceElement) {
                childrenMap.remove(elementPath);
                continue;
            }
            element = new TmfTraceElement(name, resource, this);
            this.addChild(element);
        }
        for (ITmfProjectModelElement danglingChild : childrenMap.values()) {
            this.removeChild(danglingChild);
        }
        super.refreshChildren();
        ITmfTrace experiment = this.getTrace();
        if (experiment == null) {
            return;
        }
        TmfViewsElement viewsElement = (TmfViewsElement)NonNullUtils.checkNotNull((Object)this.getChildElementViews());
        HashMap<String, TmfAnalysisElement> analysisMap = new HashMap<String, TmfAnalysisElement>();
        for (TmfAnalysisElement analysis : this.getAvailableAnalysis()) {
            analysisMap.put(analysis.getAnalysisId(), analysis);
        }
        for (IAnalysisModuleHelper module : TmfAnalysisManager.getAnalysisModules().values()) {
            if (analysisMap.containsKey(module.getId()) || !module.appliesToExperiment() || experiment.getAnalysisModule(module.getId()) == null) continue;
            IFolder newresource = ResourcesPlugin.getWorkspace().getRoot().getFolder(this.getResource().getFullPath().append(module.getId()));
            TmfAnalysisElement analysis = new TmfAnalysisElement(module.getName(), (IResource)newresource, viewsElement, module);
            viewsElement.addChild(analysis);
            analysis.refreshChildren();
            analysisMap.put(module.getId(), analysis);
        }
    }

    private List<IResource> getTraceResources() {
        IFolder folder = this.getResource();
        final ArrayList<IResource> list = new ArrayList<IResource>();
        try {
            folder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy resource) throws CoreException {
                    if (resource.isLinked()) {
                        list.add(resource.requestResource());
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        Comparator<IResource> comparator = new Comparator<IResource>(){

            @Override
            public int compare(IResource o1, IResource o2) {
                return o1.getFullPath().toString().compareTo(o2.getFullPath().toString());
            }
        };
        Collections.sort(list, comparator);
        return list;
    }

    @Override
    public @NonNull Image getIcon() {
        Image icon = super.getIcon();
        return icon == null ? TmfProjectModelIcons.DEFAULT_EXPERIMENT_ICON : icon;
    }

    @Override
    public String getLabelText() {
        return String.valueOf(this.getName()) + " [" + this.getTraces().size() + "]";
    }

    @Override
    public void refreshTraceType() {
        IConfigurationElement ce;
        super.refreshTraceType();
        if (this.getTraceType() == null && (ce = TmfTraceType.getTraceAttributes((String)"org.eclipse.linuxtools.tmf.core.experiment.generic")) != null) {
            try {
                IFolder experimentFolder = this.getResource();
                experimentFolder.setPersistentProperty(TmfCommonConstants.TRACETYPE, ce.getAttribute("id"));
                super.refreshTraceType();
            }
            catch (CoreException | InvalidRegistryObjectException throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public List<TmfTraceElement> getTraces() {
        List<ITmfProjectModelElement> children = this.getChildren();
        ArrayList<TmfTraceElement> traces = new ArrayList<TmfTraceElement>();
        for (ITmfProjectModelElement child : children) {
            if (!(child instanceof TmfTraceElement)) continue;
            traces.add((TmfTraceElement)child);
        }
        return traces;
    }

    public void addTrace(TmfTraceElement trace) {
        this.addTrace(trace, true);
    }

    public void addTrace(TmfTraceElement trace, boolean refresh) {
        IFolder experiment = this.getResource();
        IResource resource = trace.getResource();
        IPath location = resource.getLocation();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            String traceTypeId = TmfTraceType.getTraceTypeId((IResource)trace.getResource());
            TraceTypeHelper traceType = TmfTraceType.getTraceType((String)traceTypeId);
            if (resource instanceof IFolder) {
                IFolder folder = experiment.getFolder(trace.getElementPath());
                TraceUtils.createFolder((IFolder)folder.getParent(), (IProgressMonitor)new NullProgressMonitor());
                IStatus result = workspace.validateLinkLocation((IResource)folder, location);
                if (result.isOK() || result.matches(3)) {
                    folder.createLink(location, 256, null);
                    if (traceType != null) {
                        TmfTraceTypeUIUtils.setTraceType((IResource)folder, traceType, refresh);
                    }
                } else {
                    Activator.getDefault().logError("Error creating link. Invalid trace location " + location);
                }
            } else {
                IFile file = experiment.getFile(trace.getElementPath());
                TraceUtils.createFolder((IFolder)file.getParent(), (IProgressMonitor)new NullProgressMonitor());
                IStatus result = workspace.validateLinkLocation((IResource)file, location);
                if (result.isOK() || result.matches(3)) {
                    file.createLink(location, 256, null);
                    if (traceType != null) {
                        TmfTraceTypeUIUtils.setTraceType((IResource)file, traceType, refresh);
                    }
                } else {
                    Activator.getDefault().logError("Error creating link. Invalid trace location " + location);
                }
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error creating link to location " + location, e);
        }
    }

    public void removeTrace(TmfTraceElement trace) throws CoreException {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TmfExperimentElement.this.closeEditors();
            }
        });
        this.removeChild(trace);
        this.deleteTraceResource(trace.getResource());
        this.deleteSupplementaryResources();
    }

    private void deleteTraceResource(IResource resource) throws CoreException {
        resource.delete(true, null);
        IContainer parent = resource.getParent();
        if (!parent.equals((Object)this.getResource()) && parent.members().length == 0) {
            this.deleteTraceResource((IResource)parent);
        }
    }

    @Override
    public IFile createBookmarksFile() throws CoreException {
        return this.createBookmarksFile(this.getProject().getExperimentsFolder().getResource(), "editorInputType.experiment");
    }

    @Override
    public String getEditorId() {
        IConfigurationElement[] defaultEditorCE;
        IConfigurationElement ce;
        if (this.getTraceType() != null && (ce = TRACE_TYPE_UI_ATTRIBUTES.get(this.getTraceType())) != null && (defaultEditorCE = ce.getChildren("defaultEditor")).length == 1) {
            return defaultEditorCE[0].getAttribute("id");
        }
        List<TmfTraceElement> traceEntries = this.getTraces();
        String commonEditorId = null;
        for (TmfTraceElement element : traceEntries) {
            String editorId = element.getEditorId();
            if (commonEditorId == null) {
                commonEditorId = editorId != null ? editorId : "org.eclipse.linuxtools.tmf.ui.editors.events";
                continue;
            }
            if (commonEditorId.equals(editorId)) continue;
            commonEditorId = "org.eclipse.linuxtools.tmf.ui.editors.events";
        }
        return null;
    }

    public TmfExperiment instantiateTrace() {
        block3: {
            IConfigurationElement ce;
            block4: {
                this.refreshSupplementaryFolder();
                if (this.getTraceType() == null) break block3;
                ce = TRACE_TYPE_ATTRIBUTES.get(this.getTraceType());
                if (ce != null) break block4;
                return null;
            }
            try {
                TmfExperiment experiment = (TmfExperiment)ce.createExecutableExtension("experiment_type");
                return experiment;
            }
            catch (CoreException e) {
                Activator.getDefault().logError(NLS.bind((String)Messages.TmfExperimentElement_ErrorInstantiatingTrace, (Object)this.getName()), e);
            }
        }
        return null;
    }

    @Override
    public String getTypeName() {
        return Messages.TmfExperimentElement_TypeName;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Arrays.copyOf(DESCRIPTORS, DESCRIPTORS.length);
    }

    public Object getPropertyValue(Object id) {
        if (NAME.equals(id)) {
            return this.getName();
        }
        if (PATH.equals(id)) {
            return this.getPath().toString();
        }
        if (LOCATION.equals(id)) {
            return this.getLocation().toString();
        }
        if (EXPERIMENT_TYPE.equals(id) && this.getTraceType() != null) {
            IConfigurationElement category;
            IConfigurationElement ce = TRACE_TYPE_ATTRIBUTES.get(this.getTraceType());
            if (ce == null) {
                return "";
            }
            String categoryId = ce.getAttribute("category");
            if (categoryId != null && (category = TRACE_CATEGORIES.get(categoryId)) != null) {
                return String.valueOf(category.getAttribute(NAME)) + ':' + ce.getAttribute(NAME);
            }
            return ce.getAttribute(NAME);
        }
        if (EXPERIMENT_TYPE_ID.equals(id) && this.getTraceType() != null) {
            IConfigurationElement ce = TRACE_TYPE_ATTRIBUTES.get(this.getTraceType());
            if (ce == null) {
                return "";
            }
            return ce.getAttribute("id");
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    @Override
    public String getSuffix() {
        return FOLDER_SUFFIX;
    }
}

