/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.signals.LamiSelectionUpdateSignal;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.ILamiViewer;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.LamiTableContentProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.ui.viewers.table.TmfSimpleTableViewer;

public final class LamiTableViewer
extends TmfSimpleTableViewer
implements ILamiViewer {
    private final LamiResultTable fResultTable;
    private Set<Integer> fSelections;

    public LamiTableViewer(TableViewer tableViewer, LamiResultTable resultTable) {
        super(tableViewer);
        tableViewer.getTable().moveAbove(null);
        this.fResultTable = resultTable;
        this.fSelections = new HashSet<Integer>();
        this.getTableViewer().setContentProvider((IContentProvider)new LamiTableContentProvider());
        this.getTableViewer().getTable().addSelectionListener((SelectionListener)new LamiTableSelectionListener());
        this.createColumns();
        this.fillData();
    }

    private void createColumns() {
        final List aspects = this.fResultTable.getTableClass().getAspects();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (LamiTableEntryAspect aspect : aspects) {
                    LamiTableViewer.this.createColumn(aspect.getLabel(), new LamiTableColumnLabelProvider(aspect), aspect.getComparator());
                }
            }
        });
    }

    private void fillData() {
        TableViewer tableViewer = this.getTableViewer();
        Display.getDefault().asyncExec(() -> {
            if (tableViewer.getTable().isDisposed()) {
                return;
            }
            tableViewer.getTable().setTopIndex(0);
            tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            tableViewer.setInput((Object)this.fResultTable.getEntries());
            LamiTableContentProvider latencyContentProvider = (LamiTableContentProvider)this.getTableViewer().getContentProvider();
            tableViewer.setItemCount(latencyContentProvider.getNbEntries());
            TableColumn[] cols = tableViewer.getTable().getColumns();
            int i = 0;
            while (i < cols.length) {
                LamiTableEntryAspect colAspect = (LamiTableEntryAspect)this.fResultTable.getTableClass().getAspects().get(i);
                int alignment = colAspect.isContinuous() ? 131072 : 16384;
                cols[i].setAlignment(alignment);
                ++i;
            }
            if (!this.fSelections.isEmpty()) {
                int[] selectionsIndexes = this.fSelections.stream().map(index -> (LamiTableEntry)this.fResultTable.getEntries().get((int)index)).mapToInt(entry -> ((LamiTableContentProvider)this.getTableViewer().getContentProvider()).getIndexOf((LamiTableEntry)entry)).toArray();
                Display.getDefault().asyncExec(() -> {
                    this.getTableViewer().getTable().setSelection(selectionsIndexes);
                    this.getTableViewer().getTable().redraw();
                });
            }
        });
        Display.getDefault().asyncExec(() -> {
            if (tableViewer.getTable().isDisposed()) {
                return;
            }
            TableColumn[] cols = tableViewer.getTable().getColumns();
            int i = 0;
            while (i < cols.length) {
                cols[i].pack();
                ++i;
            }
        });
    }

    @TmfSignalHandler
    public void updateSelection(LamiSelectionUpdateSignal signal) {
        if (this.fResultTable.hashCode() != signal.getSignalHash() || this.equals(signal.getSource())) {
            return;
        }
        LamiTableContentProvider latencyContentProvider = (LamiTableContentProvider)this.getTableViewer().getContentProvider();
        Set<Integer> selections = signal.getEntryIndex();
        int[] selectionsIndexes = selections.stream().map(index -> (LamiTableEntry)this.fResultTable.getEntries().get((int)index)).mapToInt(entry -> latencyContentProvider.getIndexOf((LamiTableEntry)entry)).toArray();
        this.fSelections = new HashSet<Integer>(selections);
        Display.getDefault().asyncExec(() -> {
            this.getTableViewer().getTable().setSelection(selectionsIndexes);
            this.getTableViewer().getTable().redraw();
        });
    }

    private static class LamiTableColumnLabelProvider
    extends ColumnLabelProvider {
        private final LamiTableEntryAspect fColumnAspect;

        public LamiTableColumnLabelProvider(LamiTableEntryAspect aspect) {
            this.fColumnAspect = aspect;
        }

        public String getText(@Nullable Object input) {
            if (!(input instanceof LamiTableEntry)) {
                return "";
            }
            LamiTableEntry entry = (LamiTableEntry)input;
            return NonNullUtils.nullToEmptyString((Object)this.fColumnAspect.resolveString(entry));
        }
    }

    private class LamiTableSelectionListener
    extends SelectionAdapter {
        private LamiTableSelectionListener() {
        }

        public void widgetSelected(@Nullable SelectionEvent e) {
            IStructuredSelection selections = LamiTableViewer.this.getTableViewer().getStructuredSelection();
            HashSet<Integer> selectionIndexes = new HashSet<Integer>();
            Object[] objectArray = selections.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedEntry = objectArray[n2];
                selectionIndexes.add(LamiTableViewer.this.fResultTable.getEntries().indexOf(selectedEntry));
                ++n2;
            }
            LamiTableViewer.this.fSelections = selectionIndexes;
            LamiSelectionUpdateSignal signal = new LamiSelectionUpdateSignal(LamiTableViewer.this, selectionIndexes, ((LamiResultTable)NonNullUtils.checkNotNull((Object)LamiTableViewer.this.fResultTable)).hashCode());
            TmfSignalManager.dispatchSignal((TmfSignal)signal);
        }
    }
}

