/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statesystem;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.statesystem.core.StateSystem;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.backends.partial.PartialHistoryBackend;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.backends.partial.PartialStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceCompleteness;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public abstract class TmfStateSystemAnalysisModule
extends TmfAbstractAnalysisModule
implements ITmfAnalysisModuleWithStateSystems {
    private static final String EXTENSION = ".ht";
    private final CountDownLatch fInitialized = new CountDownLatch(1);
    private final Object fRequestSyncObj = new Object();
    private @Nullable ITmfStateSystemBuilder fStateSystem;
    private @Nullable IStateHistoryBackend fHtBackend;
    private @Nullable ITmfEventRequest fRequest;
    private @Nullable TmfTimeRange fTimeRange = null;
    private int fNbRead = 0;
    private boolean fInitializationSucceeded;
    private volatile @Nullable ITmfStateProvider fStateProvider;

    public static @Nullable ITmfStateSystem getStateSystem(ITmfTrace trace, String moduleId) {
        TmfStateSystemAnalysisModule module = TmfTraceUtils.getAnalysisModuleOfClass(trace, TmfStateSystemAnalysisModule.class, moduleId);
        if (module != null) {
            ITmfStateSystem ss = module.getStateSystem();
            if (ss != null) {
                return ss;
            }
            IStatus status = module.schedule();
            if (status.isOK()) {
                return module.waitForInitialization() ? module.getStateSystem() : null;
            }
        }
        return null;
    }

    protected abstract ITmfStateProvider createStateProvider();

    protected StateSystemBackendType getBackendType() {
        return StateSystemBackendType.FULL;
    }

    protected String getSsFileName() {
        return String.valueOf(this.getId()) + EXTENSION;
    }

    public @Nullable ITmfStateSystem getStateSystem() {
        return this.fStateSystem;
    }

    @Override
    public boolean waitForInitialization() {
        try {
            this.fInitialized.await();
        }
        catch (InterruptedException e) {
            return false;
        }
        return this.fInitializationSucceeded;
    }

    @Override
    public boolean isQueryable(long ts) {
        ITmfStateProvider provider = this.fStateProvider;
        if (provider == null) {
            return true;
        }
        return ts <= provider.getLatestSafeTime();
    }

    private @Nullable File getSsFile() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return null;
        }
        String directory = TmfTraceManager.getSupplementaryFileDir(trace);
        File htFile = new File(String.valueOf(directory) + this.getSsFileName());
        return htFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        IProgressMonitor mon = monitor == null ? new NullProgressMonitor() : monitor;
        ITmfStateProvider provider = this.createStateProvider();
        String id = this.getId();
        try {
            StateSystemBackendType backend = this.getBackendType();
            ITmfTrace trace = this.getTrace();
            if (trace == null) {
                this.analysisReady(false);
                return false;
            }
            switch (backend) {
                case FULL: {
                    File htFile = this.getSsFile();
                    if (htFile == null) {
                        return false;
                    }
                    this.createFullHistory(id, provider, htFile);
                    break;
                }
                case PARTIAL: {
                    File htFile = this.getSsFile();
                    if (htFile == null) {
                        return false;
                    }
                    this.createPartialHistory(id, provider, htFile);
                    break;
                }
                case INMEM: {
                    this.createInMemoryHistory(id, provider);
                    break;
                }
                case NULL: {
                    this.createNullHistory(id, provider);
                    break;
                }
            }
        }
        catch (TmfTraceException e) {
            this.analysisReady(false);
            return false;
        }
        if (!mon.isCanceled()) return true;
        return false;
    }

    private void analysisReady(boolean succeeded) {
        this.fInitializationSucceeded = succeeded;
        this.fInitialized.countDown();
    }

    @Override
    protected void canceling() {
        ITmfEventRequest req = this.fRequest;
        if (req != null && !req.isCompleted()) {
            req.cancel();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fStateSystem != null) {
            this.fStateSystem.dispose();
        }
    }

    private void createFullHistory(String id, ITmfStateProvider provider, File htFile) throws TmfTraceException {
        if (htFile.exists()) {
            int version = provider.getVersion();
            try {
                IStateHistoryBackend backend;
                this.fHtBackend = backend = StateHistoryBackendFactory.createHistoryTreeBackendExistingFile((String)id, (File)htFile, (int)version);
                this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend, (boolean)false);
                this.analysisReady(true);
                return;
            }
            catch (IOException backend) {
                // empty catch block
            }
        }
        int QUEUE_SIZE = 10000;
        try {
            IStateHistoryBackend backend;
            this.fHtBackend = backend = StateHistoryBackendFactory.createHistoryTreeBackendNewFile((String)id, (File)htFile, (int)provider.getVersion(), (long)provider.getStartTime(), (int)10000);
            this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
            provider.assignTargetStateSystem(this.fStateSystem);
            this.build(provider);
        }
        catch (IOException e) {
            throw new TmfTraceException(e.toString(), e);
        }
    }

    private void createPartialHistory(String id, ITmfStateProvider provider, File htPartialFile) throws TmfTraceException {
        int QUEUE_SIZE = 10000;
        long granularity = 50000L;
        IStateHistoryBackend realBackend = null;
        try {
            realBackend = StateHistoryBackendFactory.createHistoryTreeBackendNewFile((String)id, (File)htPartialFile, (int)provider.getVersion(), (long)provider.getStartTime(), (int)10000);
        }
        catch (IOException e) {
            throw new TmfTraceException(e.toString(), e);
        }
        ITmfStateProvider partialProvider = provider.getNewInstance();
        PartialStateSystem pss = new PartialStateSystem();
        partialProvider.assignTargetStateSystem((ITmfStateSystemBuilder)pss);
        PartialHistoryBackend partialBackend = new PartialHistoryBackend(String.valueOf(id) + ".partial", partialProvider, pss, realBackend, 50000L);
        StateSystem realSS = (StateSystem)StateSystemFactory.newStateSystem((IStateHistoryBackend)partialBackend);
        pss.assignUpstream(realSS);
        provider.assignTargetStateSystem((ITmfStateSystemBuilder)realSS);
        this.fHtBackend = partialBackend;
        this.fStateSystem = realSS;
        this.build(provider);
    }

    private void createNullHistory(String id, ITmfStateProvider provider) {
        IStateHistoryBackend backend;
        this.fHtBackend = backend = StateHistoryBackendFactory.createNullBackend((String)id);
        this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
        provider.assignTargetStateSystem(this.fStateSystem);
        this.build(provider);
    }

    private void createInMemoryHistory(String id, ITmfStateProvider provider) {
        IStateHistoryBackend backend;
        this.fHtBackend = backend = StateHistoryBackendFactory.createInMemoryBackend((String)id, (long)provider.getStartTime());
        this.fStateSystem = StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
        provider.assignTargetStateSystem(this.fStateSystem);
        this.build(provider);
    }

    private void disposeProvider(boolean deleteFiles) {
        ITmfStateProvider provider = this.fStateProvider;
        if (provider != null) {
            provider.dispose();
        }
        this.fStateProvider = null;
        if (deleteFiles && this.fHtBackend != null) {
            this.fHtBackend.removeFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(ITmfStateProvider provider) {
        if (this.fStateSystem == null || this.fHtBackend == null) {
            throw new IllegalArgumentException();
        }
        ITmfEventRequest request = this.fRequest;
        if (request != null && !request.isCompleted()) {
            request.cancel();
        }
        this.fTimeRange = TmfTimeRange.ETERNITY;
        ITmfTrace trace = provider.getTrace();
        if (!TmfStateSystemAnalysisModule.isCompleteTrace(trace)) {
            this.fTimeRange = trace.getTimeRange();
        }
        this.fStateProvider = provider;
        Object object = this.fRequestSyncObj;
        synchronized (object) {
            this.startRequest();
        }
        this.analysisReady(true);
        try {
            if (this.fRequest != null) {
                this.fRequest.waitForCompletion();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public @Nullable ITmfStateSystem getStateSystem(String id) {
        if (id.equals(this.getId())) {
            return this.fStateSystem;
        }
        return null;
    }

    @Override
    public @NonNull Iterable<@NonNull ITmfStateSystem> getStateSystems() {
        ITmfStateSystemBuilder stateSystem = this.fStateSystem;
        if (stateSystem == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(stateSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        this.fTimeRange = signal.getRange();
        ITmfStateProvider stateProvider = this.fStateProvider;
        Object object = this.fRequestSyncObj;
        synchronized (object) {
            ITmfEventRequest request;
            if (signal.getTrace() == this.getTrace() && stateProvider != null && stateProvider.getAssignedStateSystem() != null && ((request = this.fRequest) == null || request.isCompleted())) {
                this.startRequest();
            }
        }
    }

    private void startRequest() {
        ITmfStateProvider stateProvider = this.fStateProvider;
        TmfTimeRange timeRange = this.fTimeRange;
        if (stateProvider == null || timeRange == null) {
            return;
        }
        StateSystemEventRequest request = new StateSystemEventRequest(stateProvider, timeRange, this.fNbRead);
        stateProvider.getTrace().sendRequest(request);
        this.fRequest = request;
    }

    private static boolean isCompleteTrace(ITmfTrace trace) {
        return !(trace instanceof ITmfTraceCompleteness) || ((ITmfTraceCompleteness)((Object)trace)).isComplete();
    }

    @Override
    public @NonNull Map<@NonNull String, @NonNull String> getProperties() {
        Map<@NonNull String, @NonNull String> properties = super.getProperties();
        StateSystemBackendType backend = this.getBackendType();
        properties.put((String)NonNullUtils.checkNotNull((Object)Messages.TmfStateSystemAnalysisModule_PropertiesBackend), backend.name());
        switch (backend) {
            case FULL: 
            case PARTIAL: {
                File htFile = this.getSsFile();
                if (htFile == null) break;
                if (htFile.exists()) {
                    properties.put((String)NonNullUtils.checkNotNull((Object)Messages.TmfStateSystemAnalysisModule_PropertiesFileSize), FileUtils.byteCountToDisplaySize((long)htFile.length()));
                    break;
                }
                properties.put((String)NonNullUtils.checkNotNull((Object)Messages.TmfStateSystemAnalysisModule_PropertiesFileSize), (String)NonNullUtils.checkNotNull((Object)Messages.TmfStateSystemAnalysisModule_PropertiesAnalysisNotExecuted));
                break;
            }
        }
        return properties;
    }

    protected static enum StateSystemBackendType {
        FULL,
        INMEM,
        NULL,
        PARTIAL;

    }

    private class StateSystemEventRequest
    extends TmfEventRequest {
        private final ITmfStateProvider sci;
        private final ITmfTrace trace;

        public StateSystemEventRequest(ITmfStateProvider sp, TmfTimeRange timeRange, int index) {
            super(ITmfEvent.class, timeRange, index, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND, TmfStateSystemAnalysisModule.this.getDependencyLevel());
            this.sci = sp;
            this.trace = this.sci.getTrace();
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == this.trace) {
                this.sci.processEvent(event);
            } else if (this.trace instanceof TmfExperiment) {
                for (ITmfTrace childTrace : ((TmfExperiment)this.trace).getTraces()) {
                    if (childTrace != event.getTrace()) continue;
                    this.sci.processEvent(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleSuccess() {
            super.handleSuccess();
            if (TmfStateSystemAnalysisModule.isCompleteTrace(this.trace)) {
                TmfStateSystemAnalysisModule.this.disposeProvider(false);
            } else {
                TmfStateSystemAnalysisModule tmfStateSystemAnalysisModule = TmfStateSystemAnalysisModule.this;
                tmfStateSystemAnalysisModule.fNbRead = tmfStateSystemAnalysisModule.fNbRead + this.getNbRead();
                Object object = TmfStateSystemAnalysisModule.this.fRequestSyncObj;
                synchronized (object) {
                    TmfTimeRange timeRange = TmfStateSystemAnalysisModule.this.fTimeRange;
                    if (timeRange != null && this.getRange().getEndTime().getValue() < timeRange.getEndTime().getValue()) {
                        TmfStateSystemAnalysisModule.this.startRequest();
                    }
                }
            }
        }

        @Override
        public void handleCancel() {
            super.handleCancel();
            TmfStateSystemAnalysisModule.this.disposeProvider(true);
        }

        @Override
        public void handleFailure() {
            super.handleFailure();
            TmfStateSystemAnalysisModule.this.disposeProvider(true);
        }
    }
}

