/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.building.LttngKernelExecGraphProvider;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.BaseHandler;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngInterruptContext;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngSystemModel;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class EventContextHandler
extends BaseHandler {
    public EventContextHandler(LttngKernelExecGraphProvider provider) {
        super(provider);
    }

    @Override
    public void handleEvent(ITmfEvent event) {
        IKernelAnalysisEventLayout eventLayout;
        String eventName = event.getName();
        if (eventName.equals((eventLayout = this.getProvider().getEventLayout(event.getTrace())).eventSoftIrqEntry())) {
            this.handleSoftirqEntry(event);
        } else if (eventName.equals(eventLayout.eventSoftIrqExit())) {
            this.handleSoftirqExit(event);
        } else if (eventName.equals(eventLayout.eventHRTimerExpireEntry())) {
            this.handleHrtimerExpireEntry(event);
        } else if (eventName.equals(eventLayout.eventHRTimerExpireExit())) {
            this.handleHrtimerExpireExit(event);
        } else if (eventName.equals(eventLayout.eventIrqHandlerEntry())) {
            this.handleIrqHandlerEntry(event);
        } else if (eventName.equals(eventLayout.eventIrqHandlerExit())) {
            this.handleIrqHandlerExit(event);
        } else if (this.isIpiEntry(event)) {
            this.handleIpiEntry(event);
        } else if (this.isIpiExit(event)) {
            this.handleIpiExit(event);
        }
    }

    private void pushInterruptContext(ITmfEvent event, LttngKernelExecGraphProvider.Context ctx) {
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        LttngSystemModel system = this.getProvider().getSystem();
        LttngInterruptContext interruptCtx = new LttngInterruptContext(event, ctx);
        system.pushContextStack(event.getTrace().getHostId(), cpu, interruptCtx);
    }

    private void popInterruptContext(ITmfEvent event, LttngKernelExecGraphProvider.Context ctx) {
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        LttngSystemModel system = this.getProvider().getSystem();
        LttngInterruptContext interruptCtx = system.peekContextStack(event.getTrace().getHostId(), cpu);
        if (interruptCtx.getContext() == ctx) {
            system.popContextStack(event.getTrace().getHostId(), cpu);
        }
    }

    private void handleSoftirqEntry(ITmfEvent event) {
        this.pushInterruptContext(event, LttngKernelExecGraphProvider.Context.SOFTIRQ);
    }

    private void handleSoftirqExit(ITmfEvent event) {
        this.popInterruptContext(event, LttngKernelExecGraphProvider.Context.SOFTIRQ);
    }

    private void handleIrqHandlerEntry(ITmfEvent event) {
        this.pushInterruptContext(event, LttngKernelExecGraphProvider.Context.IRQ);
    }

    private void handleIrqHandlerExit(ITmfEvent event) {
        this.popInterruptContext(event, LttngKernelExecGraphProvider.Context.IRQ);
    }

    private void handleHrtimerExpireEntry(ITmfEvent event) {
        this.pushInterruptContext(event, LttngKernelExecGraphProvider.Context.HRTIMER);
    }

    private void handleHrtimerExpireExit(ITmfEvent event) {
        this.popInterruptContext(event, LttngKernelExecGraphProvider.Context.HRTIMER);
    }

    private void handleIpiEntry(ITmfEvent event) {
        this.pushInterruptContext(event, LttngKernelExecGraphProvider.Context.IPI);
    }

    private void handleIpiExit(ITmfEvent event) {
        this.popInterruptContext(event, LttngKernelExecGraphProvider.Context.IPI);
    }
}

