/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.swtchart.Chart;

public class KernelMemoryUsageViewer
extends TmfCommonXLineChartViewer {
    private static final String NOT_SELECTED = "-1";
    private TmfStateSystemAnalysisModule fModule = null;
    private String fSelectedThread = "-1";

    public KernelMemoryUsageViewer(Composite parent) {
        super(parent, Messages.MemoryUsageViewer_title, Messages.MemoryUsageViewer_xAxis, Messages.MemoryUsageViewer_yAxis);
        Chart chart = this.getSwtChart();
        chart.getAxisSet().getYAxis(0).getTick().setFormat(DataSizeWithUnitFormat.getInstance());
        chart.getLegend().setPosition(1024);
        chart.getLegend().setVisible(false);
    }

    protected void initializeDataSource() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            this.fModule = (TmfStateSystemAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, TmfStateSystemAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.core.kernelmemory");
            if (this.fModule == null) {
                return;
            }
            this.fModule.schedule();
        }
    }

    protected void updateData(long start, long end, int nb, IProgressMonitor monitor) {
        TmfStateSystemAnalysisModule module = this.fModule;
        if (this.getTrace() == null || module == null) {
            return;
        }
        if (!module.waitForInitialization()) {
            return;
        }
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            throw new IllegalStateException("No state system for the module " + module.toString());
        }
        double[] xvalues = KernelMemoryUsageViewer.getXAxis((long)start, (long)end, (int)nb);
        if (xvalues.length == 0) {
            return;
        }
        long clampedEnd = Math.min(end, ss.getCurrentEndTime());
        if (clampedEnd < ss.getStartTime()) {
            return;
        }
        this.setXAxis(xvalues);
        try {
            String tid;
            double[] totalKernelMemoryValues = new double[xvalues.length];
            double[] selectedThreadValues = new double[xvalues.length];
            int i = 0;
            while (i < xvalues.length) {
                if (monitor.isCanceled()) {
                    return;
                }
                double x = xvalues[i];
                long t = (long)x + this.getTimeOffset();
                if (ss.getCurrentEndTime() < t || ss.getStartTime() > t) {
                    selectedThreadValues[i] = 0.0;
                } else {
                    List kernelState = ss.queryFullState(t);
                    List threadQuarkList = ss.getSubAttributes(-1, false);
                    for (Integer threadQuark : threadQuarkList) {
                        ITmfStateInterval threadMemoryInterval = (ITmfStateInterval)kernelState.get(threadQuark);
                        long value = threadMemoryInterval.getStateValue().unboxLong();
                        int n = i;
                        totalKernelMemoryValues[n] = totalKernelMemoryValues[n] + (double)value;
                        tid = ss.getAttributeName(threadQuark.intValue());
                        if (!tid.equals(this.fSelectedThread)) continue;
                        selectedThreadValues[i] = value;
                    }
                }
                ++i;
            }
            double totalKernelMemoryValuesShift = 0.0;
            double selectThreadValuesShift = 0.0;
            List kernelState = ss.queryFullState(clampedEnd);
            List threadQuarkList = ss.getSubAttributes(-1, false);
            for (Integer threadQuark : threadQuarkList) {
                int lowestMemoryQuark = ss.getQuarkRelative(threadQuark.intValue(), new String[]{"lowestMemory"});
                ITmfStateInterval lowestMemoryInterval = (ITmfStateInterval)kernelState.get(lowestMemoryQuark);
                long lowestMemoryValue = lowestMemoryInterval.getStateValue().unboxLong();
                totalKernelMemoryValuesShift -= (double)lowestMemoryValue;
                tid = ss.getAttributeName(threadQuark.intValue());
                if (!tid.equals(this.fSelectedThread)) continue;
                selectThreadValuesShift = -lowestMemoryValue;
            }
            int i2 = 0;
            while (i2 < xvalues.length) {
                int n = i2;
                totalKernelMemoryValues[n] = totalKernelMemoryValues[n] + totalKernelMemoryValuesShift;
                int n2 = i2++;
                selectedThreadValues[n2] = selectedThreadValues[n2] + selectThreadValuesShift;
            }
            this.setSeries(Messages.MemoryUsageViewer_Total, totalKernelMemoryValues);
            if (this.fSelectedThread != NOT_SELECTED) {
                this.setSeries(this.fSelectedThread, selectedThreadValues);
            }
            this.updateDisplay();
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    public void setSelectedThread(String tid) {
        this.cancelUpdate();
        this.deleteSeries(this.fSelectedThread);
        this.fSelectedThread = tid;
        this.updateContent();
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        this.initSelection();
        super.traceSelected(signal);
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.initSelection();
        super.traceOpened(signal);
    }

    private void initSelection() {
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        Object data = ctx.getData("org.eclipse.tracecompass.analysis.os.linux.ui.kernelmemoryusageview.KERNEL_MEMORY");
        String thread = data instanceof String ? (String)data : NOT_SELECTED;
        this.setSelectedThread(thread);
    }
}

