/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.composite.cpp;

import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInstanceCache;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.index.composite.ICompositesFactory;
import org.eclipse.cdt.internal.core.index.composite.cpp.CPPCompositesFactory;
import org.eclipse.core.runtime.CoreException;

public class CompositeInstanceCache {
    private final HashMap<String, ICPPTemplateInstance> fMap = new HashMap();
    private ICPPDeferredClassInstance fDeferredInstance;

    public static CompositeInstanceCache getCache(ICompositesFactory cf, IIndexFragmentBinding fb) {
        Object key;
        IIndexFragment frag = fb.getFragment();
        Object cache = frag.getCachedResult(key = CPPCompositesFactory.createInstanceCacheKey(cf, fb));
        if (cache != null) {
            return (CompositeInstanceCache)cache;
        }
        CompositeInstanceCache newCache = new CompositeInstanceCache();
        newCache.populate(cf, fb);
        return (CompositeInstanceCache)frag.putCachedResult(key, newCache, false);
    }

    public final synchronized void addInstance(ICPPTemplateArgument[] arguments, ICPPTemplateInstance instance) {
        try {
            String key = IndexCPPSignatureUtil.getTemplateArgString(arguments, true);
            this.fMap.put(key, instance);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
    }

    public final synchronized ICPPTemplateInstance getInstance(ICPPTemplateArgument[] arguments) {
        try {
            String key = IndexCPPSignatureUtil.getTemplateArgString(arguments, true);
            return this.fMap.get(key);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    private void populate(ICompositesFactory cf, IIndexFragmentBinding fb) {
        if (fb instanceof ICPPInstanceCache) {
            ICPPTemplateInstance[] insts;
            ICPPTemplateInstance[] iCPPTemplateInstanceArray = insts = ((ICPPInstanceCache)((Object)fb)).getAllInstances();
            int n = insts.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateInstance ti = iCPPTemplateInstanceArray[n2];
                if (ti instanceof IIndexFragmentBinding) {
                    ICPPTemplateInstance comp = (ICPPTemplateInstance)((Object)cf.getCompositeBinding((IIndexFragmentBinding)((Object)ti)));
                    ICPPTemplateArgument[] args = comp.getTemplateArguments();
                    this.addInstance(args, comp);
                }
                ++n2;
            }
        }
    }

    public synchronized ICPPTemplateInstance[] getAllInstances() {
        return this.fMap.values().toArray(new ICPPTemplateInstance[this.fMap.size()]);
    }

    public ICPPDeferredClassInstance getDeferredInstance() {
        return this.fDeferredInstance;
    }

    public void putDeferredInstance(ICPPDeferredClassInstance dci) {
        this.fDeferredInstance = dci;
    }
}

