/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.kernel;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public final class KernelThreadInformationProvider {
    private KernelThreadInformationProvider() {
    }

    public static @Nullable Integer getThreadOnCpu(KernelAnalysisModule module, long cpuId, long ts) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return null;
        }
        try {
            int cpuQuark = ss.getQuarkAbsolute(new String[]{"CPUs", Long.toString(cpuId), "Current_thread"});
            ITmfStateInterval interval = ss.querySingleState(ts, cpuQuark);
            ITmfStateValue val = interval.getStateValue();
            if (val.getType().equals((Object)ITmfStateValue.Type.INTEGER)) {
                return val.unboxInt();
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return null;
    }

    public static Collection<Integer> getThreadIds(KernelAnalysisModule module) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return Collections.EMPTY_SET;
        }
        try {
            int threadQuark = ss.getQuarkAbsolute(new String[]{"Threads"});
            TreeSet<@NonNull Integer> tids = new TreeSet<Integer>();
            for (Integer quark : ss.getSubAttributes(threadQuark, false)) {
                @NonNull String attributeName = ss.getAttributeName(quark.intValue());
                tids.add(attributeName.startsWith("0_") ? 0 : Integer.parseInt(attributeName));
            }
            return tids;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return Collections.EMPTY_SET;
        }
    }

    public static @Nullable Integer getParentPid(KernelAnalysisModule module, Integer threadId, long ts) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return null;
        }
        try {
            Integer ppidNode = ss.getQuarkAbsolute(new String[]{"Threads", threadId.toString(), "PPID"});
            ITmfStateInterval ppidInterval = ss.querySingleState(ts, ppidNode.intValue());
            ITmfStateValue ppidValue = ppidInterval.getStateValue();
            if (ppidValue.getType().equals((Object)ITmfStateValue.Type.INTEGER)) {
                return ppidValue.unboxInt();
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return null;
    }

    public static @Nullable String getExecutableName(KernelAnalysisModule module, Integer threadId) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return null;
        }
        try {
            Integer execNameNode = ss.getQuarkAbsolute(new String[]{"Threads", threadId.toString(), "Exec_name"});
            List execNameIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)execNameNode, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
            String execName = null;
            for (ITmfStateInterval interval : execNameIntervals) {
                ITmfStateValue execNameValue = interval.getStateValue();
                if (!execNameValue.getType().equals((Object)ITmfStateValue.Type.STRING)) continue;
                execName = execNameValue.unboxStr();
            }
            return execName;
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            return null;
        }
    }

    public static int getThreadPriority(KernelAnalysisModule module, int threadId, long ts) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return -1;
        }
        int prioQuark = ss.optQuarkAbsolute(new String[]{"Threads", String.valueOf(threadId), "Prio"});
        if (prioQuark == -2) {
            return -1;
        }
        try {
            return ss.querySingleState(ts, prioQuark).getStateValue().unboxInt();
        }
        catch (StateSystemDisposedException e) {
            return -1;
        }
    }

    public static List<ITmfStateInterval> getStatusIntervalsForThread(KernelAnalysisModule module, Integer threadId, long start, long end, long resolution, IProgressMonitor monitor) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            int threadQuark = ss.getQuarkAbsolute(new String[]{"Threads", threadId.toString()});
            int statusQuark = ss.getQuarkRelative(threadQuark, new String[]{"Status"});
            List statusIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)statusQuark, (long)Math.max(start, ss.getStartTime()), (long)Math.min(end - 1L, ss.getCurrentEndTime()), (long)resolution, (IProgressMonitor)monitor);
            return statusIntervals;
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            return Collections.EMPTY_LIST;
        }
    }
}

