/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.ui.texteditor.IUpdate;

public class MatchFilterAction
extends Action
implements IUpdate {
    private MatchFilter fFilter;
    private AbstractTextSearchViewPage fPage;

    public MatchFilterAction(AbstractTextSearchViewPage page, MatchFilter filter) {
        super(filter.getActionLabel(), 2);
        this.fPage = page;
        this.fFilter = filter;
        this.setId("MatchFilterAction." + filter.getID());
        this.setChecked(this.isActiveMatchFilter());
    }

    public void run() {
        AbstractTextSearchResult input = this.fPage.getInput();
        if (input == null) {
            return;
        }
        ArrayList<MatchFilter> newFilters = new ArrayList<MatchFilter>();
        MatchFilter[] activeMatchFilters = input.getActiveMatchFilters();
        if (activeMatchFilters == null) {
            return;
        }
        int i = 0;
        while (i < activeMatchFilters.length) {
            if (!activeMatchFilters[i].equals(this.fFilter)) {
                newFilters.add(activeMatchFilters[i]);
            }
            ++i;
        }
        boolean newState = this.isChecked();
        if (newState) {
            newFilters.add(this.fFilter);
        }
        input.setActiveMatchFilters(newFilters.toArray(new MatchFilter[newFilters.size()]));
    }

    public MatchFilter getFilter() {
        return this.fFilter;
    }

    private boolean isActiveMatchFilter() {
        AbstractTextSearchResult input = this.fPage.getInput();
        if (input != null) {
            MatchFilter[] activeMatchFilters = input.getActiveMatchFilters();
            int i = 0;
            while (i < activeMatchFilters.length) {
                if (this.fFilter.equals(activeMatchFilters[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void update() {
        this.setChecked(this.isActiveMatchFilter());
    }
}

